/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.infinity;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.iface.ISwitchable;
import committee.nova.mods.avaritia.api.iface.IToolTransform;
import committee.nova.mods.avaritia.api.iface.IUndamageable;
import committee.nova.mods.avaritia.api.iface.InitEnchantItem;
import committee.nova.mods.avaritia.common.entity.ImmortalItemEntity;
import committee.nova.mods.avaritia.init.config.ModConfig;
import committee.nova.mods.avaritia.init.registry.ModDamageTypes;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.init.registry.ModToolTiers;
import committee.nova.mods.avaritia.init.registry.ModTooltips;
import committee.nova.mods.avaritia.util.ToolUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfinitySwordItem
extends SwordItem
implements InitEnchantItem,
ISwitchable,
IUndamageable,
IToolTransform {
    public InfinitySwordItem() {
        super(ModToolTiers.INFINITY, 900, 0.0f, new Item.Properties().m_41497_(ModRarities.COSMIC).m_41487_(1).m_41486_());
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        Level level = player.m_9236_();
        Boolean endlessDamage = (Boolean)ModConfig.isSwordAttackEndless.get();
        if (!level.f_46443_ && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity instanceof LivingEntity) {
                LivingEntity victim = (LivingEntity)entity;
                DamageSource damageSource = player.m_269291_().m_268998_(ModDamageTypes.INFINITY, (Entity)victim, (Entity)player);
                ToolUtils.sweepAttack((Level)serverLevel, (LivingEntity)player, (Entity)victim);
                if (victim instanceof EnderDragon) {
                    EnderDragon dragon = (EnderDragon)victim;
                    dragon.m_31120_(dragon.f_31080_, damageSource, endlessDamage != false ? Float.MAX_VALUE : this.m_43314_().m_6631_());
                } else if (victim instanceof Player) {
                    Player pvp = (Player)victim;
                    if (ToolUtils.isInfinite((LivingEntity)pvp)) {
                        serverLevel.m_254849_((Entity)player, (double)pvp.m_146903_(), (double)pvp.m_146904_(), (double)pvp.m_146907_(), 25.0f, Level.ExplosionInteraction.MOB);
                        return true;
                    }
                    this.hurt(victim, damageSource, endlessDamage != false ? Float.MAX_VALUE : this.m_43314_().m_6631_());
                } else {
                    this.hurt(victim, damageSource, endlessDamage != false ? Float.MAX_VALUE : this.m_43314_().m_6631_());
                }
                if (endlessDamage.booleanValue() && victim.m_21224_()) {
                    victim.m_21153_(0.0f);
                    this.die(victim, damageSource);
                    player.m_214076_(serverLevel, victim);
                }
                return true;
            }
        }
        return false;
    }

    public boolean hurt(LivingEntity victim, DamageSource pSource, float pAmount) {
        if (victim.m_9236_().f_46443_) {
            return false;
        }
        if (victim.m_21224_()) {
            return false;
        }
        if (victim.m_5803_() && !victim.m_9236_().f_46443_) {
            victim.m_5796_();
        }
        boolean flag = false;
        victim.m_21310_(0);
        victim.f_267362_.m_267771_(1.5f);
        victim.f_20898_ = pAmount;
        victim.f_19802_ = 20;
        victim.m_21231_().m_289194_(pSource, pAmount);
        victim.m_21153_(victim.m_21223_() - pAmount);
        victim.m_146850_(GameEvent.f_223706_);
        victim.f_20916_ = victim.f_20917_ = 10;
        Entity entity1 = pSource.m_7639_();
        if (entity1 != null) {
            TamableAnimal tamableEntity;
            if (entity1 instanceof LivingEntity) {
                LivingEntity livingentity1 = (LivingEntity)entity1;
                if (!pSource.m_269533_(DamageTypeTags.f_268718_)) {
                    victim.m_6703_(livingentity1);
                }
            }
            if (entity1 instanceof Player) {
                Player player1 = (Player)entity1;
                victim.f_20889_ = 100;
                victim.m_6598_(player1);
            } else if (entity1 instanceof TamableAnimal && (tamableEntity = (TamableAnimal)entity1).m_21824_()) {
                victim.f_20889_ = 100;
                LivingEntity livingentity2 = tamableEntity.m_269323_();
                if (livingentity2 instanceof Player) {
                    Player player2 = (Player)livingentity2;
                    victim.m_6598_(player2);
                } else {
                    victim.m_6598_(null);
                }
            }
        }
        victim.m_9236_().m_269196_((Entity)victim, pSource);
        if (!pSource.m_269533_(DamageTypeTags.f_268467_)) {
            victim.f_19864_ = true;
        }
        if (entity1 != null && !pSource.m_269533_(DamageTypeTags.f_268415_)) {
            double d0 = entity1.m_20185_() - victim.m_20185_();
            double d1 = entity1.m_20189_() - victim.m_20189_();
            while (d0 * d0 + d1 * d1 < 1.0E-4) {
                d0 = (Math.random() - Math.random()) * 0.01;
                d1 = (Math.random() - Math.random()) * 0.01;
            }
            victim.m_147240_((double)0.4f, d0, d1);
            if (!flag) {
                victim.m_269405_(d0, d1);
            }
        }
        if (victim.m_21224_()) {
            this.die(victim, pSource);
        } else {
            SoundEvent soundevent = SoundEvents.f_11915_;
            victim.m_5496_(soundevent, 2.0f, victim.m_6100_());
        }
        boolean flag2 = true;
        victim.f_20958_ = pSource;
        victim.f_20930_ = victim.m_9236_().m_46467_();
        if (victim instanceof ServerPlayer) {
            CriteriaTriggers.f_10574_.m_35174_((ServerPlayer)victim, pSource, pAmount, pAmount, flag);
        }
        if (entity1 instanceof ServerPlayer) {
            CriteriaTriggers.f_10573_.m_60112_((ServerPlayer)entity1, (Entity)victim, pSource, pAmount, pAmount, flag);
        }
        return flag2;
    }

    public void die(LivingEntity victim, DamageSource pDamageSource) {
        if (!victim.m_213877_() && !victim.f_20890_) {
            Entity entity = pDamageSource.m_7639_();
            LivingEntity livingentity = victim.m_21232_();
            if (victim.f_20897_ >= 0 && livingentity != null) {
                livingentity.m_5993_((Entity)victim, victim.f_20897_, pDamageSource);
            }
            if (victim.m_5803_()) {
                victim.m_5796_();
            }
            if (!victim.m_9236_().f_46443_ && victim.m_8077_()) {
                Const.LOGGER.info("Named entity {} died: {}", (Object)this, (Object)victim.m_21231_().m_19293_().getString());
            }
            victim.f_20890_ = true;
            victim.m_21231_().m_19296_();
            Level level = victim.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                if (entity == null || entity.m_214076_(serverlevel, victim)) {
                    victim.m_146850_(GameEvent.f_223707_);
                    victim.m_6668_(pDamageSource);
                    this.createWitherRose(victim, livingentity);
                }
                victim.m_9236_().m_7605_((Entity)victim, (byte)3);
            }
            victim.m_20124_(Pose.DYING);
        }
    }

    protected void createWitherRose(LivingEntity victim, @Nullable LivingEntity pEntitySource) {
        if (!victim.m_9236_().f_46443_) {
            boolean flag = false;
            if (pEntitySource instanceof WitherBoss) {
                BlockPos blockpos = victim.m_20183_();
                BlockState blockstate = Blocks.f_50070_.m_49966_();
                if (victim.m_9236_().m_46859_(blockpos) && blockstate.m_60710_((LevelReader)victim.m_9236_(), blockpos)) {
                    victim.m_9236_().m_7731_(blockpos, blockstate, 3);
                    flag = true;
                }
                if (!flag) {
                    ItemEntity itementity = new ItemEntity(victim.m_9236_(), victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), new ItemStack((ItemLike)Items.f_41951_));
                    victim.m_9236_().m_7967_((Entity)itementity);
                }
            }
        }
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 0;
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        return false;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(Level level, Entity location, ItemStack stack) {
        return ImmortalItemEntity.create((EntityType<ImmortalItemEntity>)((EntityType)ModEntities.IMMORTAL.get()), level, location.m_20185_(), location.m_20186_(), location.m_20189_(), stack);
    }

    @Override
    public int getInitEnchantLevel(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44982_ ? 10 : 0;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)ModTooltips.INIT_ENCHANT.args(Enchantments.f_44982_.m_44700_(10)).build());
        if (this.isActive(stack, "infinity_sword_kill")) {
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.avaritia.sword_kill_mode.active").m_130940_(ChatFormatting.RED));
        }
    }
}

