/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.menu;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.common.container.OffsetContainer;
import committee.nova.mods.avaritia.api.common.menu.BaseMenu;
import committee.nova.mods.avaritia.api.iface.IChangePage;
import committee.nova.mods.avaritia.api.util.InventoryUtils;
import committee.nova.mods.avaritia.common.wrappers.RingStorageWrapper;
import committee.nova.mods.avaritia.init.config.ModConfig;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModMenus;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.NotNull;

public class _NeutronRingMenu
extends BaseMenu
implements IChangePage {
    public ItemStack ring = ItemStack.f_41583_;
    public int slot;
    private final Inventory playerInventory;
    private RingStorageWrapper storageWrapper;
    private DataSlot pageData;
    private ContainerData countData;
    private int mainInventorySize;
    private int swapIndex = -1;

    public _NeutronRingMenu(int id, Inventory playerInventory, FriendlyByteBuf buf) {
        this(id, playerInventory, buf.readInt(), OffsetContainer.dummy(54));
    }

    public _NeutronRingMenu(int id, Inventory playerInventory, int slot, OffsetContainer container) {
        super((MenuType)ModMenus.neutron_ring.get(), id, playerInventory);
        this.playerInventory = playerInventory;
        this.slot = slot;
        if (slot > -1) {
            this.ring = playerInventory.m_8020_(slot);
        }
        if (this.ring.m_41619_()) {
            this.ring = InventoryUtils.findItemInInv(playerInventory.f_35978_, stack -> stack.m_150930_((Item)ModItems.neutron_ring.get()), stack -> stack);
        }
        this.ring.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
            this.storageWrapper = (RingStorageWrapper)itemHandler;
            this.pageData = this.storageWrapper.pageData;
            this.countData = this.storageWrapper.countData;
            this.mainInventorySize = playerInventory.f_35974_.size() + this.storageWrapper.getSlots();
        });
        int rows = (Integer)ModConfig.inventoryRows.get();
        int offset = (rows - 4) * 18;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)container, j + i * 9, 8 + j * 18, 36 + i * 18));
            }
        }
        this.createInventorySlots(playerInventory, 0, 38 + offset);
        this.m_38895_(this.pageData);
        int i2 = 0;
        while (i2 < this.countData.m_6499_()) {
            final int finalI = i2++;
            this.m_38895_(new DataSlot(){
                private int lastKnownPage = -1;

                public int m_6501_() {
                    return _NeutronRingMenu.this.countData.m_6413_(finalI);
                }

                public void m_6422_(int value) {
                    _NeutronRingMenu.this.countData.m_8050_(finalI, value);
                }

                public boolean m_39409_() {
                    if (super.m_39409_()) {
                        return true;
                    }
                    int page = _NeutronRingMenu.this.storageWrapper.getPage();
                    boolean flag = page != this.lastKnownPage;
                    this.lastKnownPage = page;
                    return flag;
                }
            });
        }
    }

    @Override
    public void changePage(int page) {
        Const.LOGGER.info("Changing page to {}", (Object)page);
        Const.LOGGER.info("Current page is {}", (Object)this.pageData.m_6501_());
        int nextPage = Mth.m_14045_((int)page, (int)0, (int)((Integer)ModConfig.maxPageLimit.get() - 1));
        if (nextPage != this.pageData.m_6501_()) {
            this.pageData.m_6422_(nextPage);
            Const.LOGGER.info("Page updated to {}", (Object)nextPage);
        } else {
            Const.LOGGER.info("Page remains unchanged at {}", (Object)nextPage);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getMaxPage() {
        return (Integer)ModConfig.maxPageLimit.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCurrentPage() {
        return this.pageData.m_6501_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public long getItemCount(int slot) {
        return Integer.toUnsignedLong(this.countData.m_6413_(slot));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Inventory getPlayerInventory() {
        return this.playerInventory;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSwapIndex() {
        return this.swapIndex;
    }

    @Override
    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int pIndex) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot1 = (Slot)this.f_38839_.get(pIndex);
        if (slot1.m_6657_()) {
            ItemStack slot1Item = slot1.m_7993_();
            itemStack = slot1Item.m_41777_();
            if (pIndex < 54 ? !this.m_38903_(slot1Item, 54, this.f_38839_.size(), true) : !this.m_38903_(slot1Item, 0, 54, false)) {
                return ItemStack.f_41583_;
            }
            if (slot1Item.m_41619_()) {
                slot1.m_269060_(ItemStack.f_41583_);
            } else {
                slot1.m_6654_();
            }
        }
        return itemStack;
    }
}

