/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.net;

import committee.nova.mods.avaritia.core.singularity.Singularity;
import committee.nova.mods.avaritia.core.singularity.SingularityDataManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class S2CSingularitiesPack {
    private final Collection<Singularity> cacheSingularities;

    public S2CSingularitiesPack(Collection<Singularity> cacheSingularities) {
        this.cacheSingularities = cacheSingularities;
    }

    public S2CSingularitiesPack(FriendlyByteBuf buf) {
        ArrayList<Singularity> cacheSingularities = new ArrayList<Singularity>();
        int cacheSize = buf.m_130242_();
        for (int i = 0; i < cacheSize; ++i) {
            Singularity singularity = Singularity.read(buf);
            cacheSingularities.add(singularity);
        }
        this.cacheSingularities = cacheSingularities;
    }

    public void write(FriendlyByteBuf buffer) {
        this.writeSingularities(buffer, this.cacheSingularities);
    }

    private void writeSingularities(FriendlyByteBuf buffer, Collection<Singularity> singularities) {
        buffer.m_130130_(singularities.size());
        singularities.forEach(singularity -> {
            buffer.m_130085_(singularity.getId());
            buffer.m_130070_(singularity.getName());
            buffer.m_130089_(singularity.getColors());
            buffer.writeBoolean(singularity.getTag() != null);
            buffer.m_130130_(singularity.getTimeRequired());
            if (singularity.getTag() != null) {
                buffer.m_130070_(singularity.getTag());
            } else {
                singularity.getIngredient().m_43923_(buffer);
            }
            buffer.m_130130_(singularity.getIngredientCount());
            buffer.writeBoolean(singularity.isEnabled());
            buffer.writeBoolean(singularity.isRecipeDisabled());
        });
    }

    public void run(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            SingularityDataManager.getInstance().getCachedSingularities().clear();
            SingularityDataManager.getInstance().getCachedSingularities().putAll(this.cacheSingularities.stream().collect(Collectors.toMap(Singularity::getId, s -> s)));
        });
        ctx.get().setPacketHandled(true);
    }
}

