/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.tile;

import committee.nova.mods.avaritia.api.common.crafting.ICompressorRecipe;
import committee.nova.mods.avaritia.api.common.tile.BaseInventoryTileEntity;
import committee.nova.mods.avaritia.api.common.wrapper.ItemStackWrapper;
import committee.nova.mods.avaritia.api.util.ItemUtils;
import committee.nova.mods.avaritia.api.util.lang.Localizable;
import committee.nova.mods.avaritia.common.menu.CompressorMenu;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import committee.nova.mods.avaritia.init.registry.ModTileEntities;
import committee.nova.mods.avaritia.init.registry.enums.CompressorTier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeutronCompressorTile
extends BaseInventoryTileEntity {
    private final ItemStackWrapper inventory;
    private final ItemStackWrapper recipeInventory;
    private final SimpleContainerData data = new SimpleContainerData(1);
    private ICompressorRecipe recipe;
    private ItemStack materialStack = ItemStack.f_41583_;
    private int materialCount;
    private int progress;
    private boolean ejecting = false;
    private CompressorTier tier;

    public NeutronCompressorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.neutron_compressor_tile.get(), pos, state);
        this.inventory = NeutronCompressorTile.createInventoryHandler();
        this.recipeInventory = new ItemStackWrapper(1);
        if (state.m_60713_((Block)ModBlocks.neutron_compressor.get())) {
            this.tier = CompressorTier.DEFAULT;
        } else if (state.m_60713_((Block)ModBlocks.dense_neutron_compressor.get())) {
            this.tier = CompressorTier.DENSE;
        } else if (state.m_60713_((Block)ModBlocks.denser_neutron_compressor.get())) {
            this.tier = CompressorTier.DENSER;
        } else if (state.m_60713_((Block)ModBlocks.densest_neutron_compressor.get())) {
            this.tier = CompressorTier.DENSEST;
        }
    }

    public static ItemStackWrapper createInventoryHandler() {
        ItemStackWrapper inventory = new ItemStackWrapper(2);
        inventory.setOutputSlots(0);
        return inventory;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, NeutronCompressorTile tile) {
        ItemStack output = tile.inventory.getStackInSlot(0);
        ItemStack input = tile.inventory.getStackInSlot(1);
        tile.recipeInventory.setStackInSlot(0, tile.materialStack);
        if (tile.recipe == null || !tile.recipe.m_5818_(tile.recipeInventory.toIInventory(), level)) {
            tile.recipe = level.m_7465_().m_44015_((RecipeType)ModRecipeTypes.COMPRESSOR_RECIPE.get(), tile.recipeInventory.toIInventory(), level).orElse(null);
        }
        if (!level.m_5776_()) {
            int addCount;
            if (!input.m_41619_()) {
                if (tile.materialStack.m_41619_() || tile.materialCount <= 0) {
                    tile.materialStack = input.m_41777_();
                    tile.setChangedFast();
                }
                if (tile.recipe != null && (float)tile.materialCount < (float)tile.recipe.getInputCount() * tile.tier.inputAmplifier && ItemUtils.areStacksSameType(input, tile.materialStack)) {
                    int consumeAmount = input.m_41613_();
                    consumeAmount = Math.min(consumeAmount, Mth.m_14167_((float)((float)tile.recipe.getInputCount() * tile.tier.inputAmplifier)) - tile.materialCount);
                    input.m_41774_(consumeAmount);
                    tile.materialCount += consumeAmount;
                    tile.setChangedFast();
                }
            }
            if (tile.recipe != null && (float)tile.materialCount >= (float)tile.recipe.getInputCount() * tile.tier.inputAmplifier) {
                ItemStack result;
                ++tile.progress;
                tile.data.m_8050_(0, tile.progress);
                if ((float)tile.progress >= (float)tile.recipe.getTimeCost() * tile.tier.timeAmplifier && ItemUtils.canCombineStacks(result = tile.recipe.m_5874_(tile.inventory.toIInventory(), level.m_9598_()), output)) {
                    tile.updateResult(result, tile.tier.outputAmplifier);
                    tile.progress = 0;
                    tile.materialCount -= Mth.m_14167_((float)((float)tile.recipe.getInputCount() * tile.tier.inputAmplifier));
                    if (tile.materialCount <= 0) {
                        tile.materialStack = ItemStack.f_41583_;
                    }
                    tile.setChangedFast();
                }
            }
            if (tile.ejecting && tile.materialCount > 0 && !tile.materialStack.m_41619_() && (output.m_41619_() || ItemUtils.areStacksSameType(tile.materialStack, output)) && (addCount = Math.min(tile.materialCount, tile.materialStack.m_41741_() - output.m_41613_())) > 0) {
                ItemStack toAdd = ItemUtils.withSize(tile.materialStack, addCount, false);
                tile.updateResult(toAdd, tile.tier.outputAmplifier);
                tile.materialCount -= addCount;
                if (tile.materialCount < 1) {
                    tile.materialStack = ItemStack.f_41583_;
                    tile.ejecting = false;
                }
                if (tile.progress > 0) {
                    tile.progress = 0;
                }
                tile.setChangedFast();
            }
        }
        tile.dispatchIfChanged();
    }

    @Override
    @NotNull
    public ItemStackWrapper getInventory() {
        return this.inventory;
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.materialCount = tag.m_128451_("MaterialCount");
        this.materialStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("MaterialStack"));
        this.progress = tag.m_128451_("Progress");
        this.ejecting = tag.m_128471_("Ejecting");
    }

    @Override
    public void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("MaterialCount", this.materialCount);
        tag.m_128365_("MaterialStack", (Tag)this.materialStack.serializeNBT());
        tag.m_128405_("Progress", this.progress);
        tag.m_128379_("Ejecting", this.ejecting);
    }

    @NotNull
    public Component m_5446_() {
        return Localizable.of("block.avaritia." + this.tier.name).build();
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInventory) {
        return new CompressorMenu(windowId, playerInventory, this.inventory, this.m_58899_(), (ContainerData)this.data);
    }

    public CompressorTier getTier() {
        return this.tier;
    }

    public void setTier(CompressorTier tier) {
        this.tier = tier;
    }

    public ItemStack getMaterialStack() {
        return this.materialStack;
    }

    public boolean hasMaterialStack() {
        return !this.materialStack.m_41619_();
    }

    public int getMaterialCount() {
        return this.materialCount;
    }

    public boolean isEjecting() {
        return this.ejecting;
    }

    public void toggleEjecting() {
        if (this.materialCount > 0) {
            this.ejecting = !this.ejecting;
            this.setChangedAndDispatch();
        }
    }

    public boolean hasRecipe() {
        return this.recipe != null;
    }

    public ICompressorRecipe getActiveRecipe() {
        return this.recipe;
    }

    public int getMaterialsRequired() {
        if (this.hasRecipe()) {
            return Mth.m_14167_((float)((float)this.recipe.getInputCount() * this.tier.inputAmplifier));
        }
        return 0;
    }

    public int getTimeRequired() {
        if (this.hasRecipe()) {
            return Mth.m_14167_((float)((float)this.recipe.getTimeCost() * this.tier.timeAmplifier));
        }
        return 0;
    }

    private void updateResult(ItemStack stack, int outputAmplifier) {
        ItemStack result = this.inventory.getStackInSlot(0);
        if (result.m_41619_()) {
            this.inventory.setStackInSlot(0, stack.m_255036_(outputAmplifier));
        } else {
            this.inventory.setStackInSlot(0, ItemUtils.grow(result, stack.m_41613_() * outputAmplifier));
        }
    }
}

