/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.core.channel;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.common.net.channel.ChannelAction;
import committee.nova.mods.avaritia.common.net.channel.S2CChannelActionPack;
import committee.nova.mods.avaritia.core.channel.ChannelInfo;
import committee.nova.mods.avaritia.core.channel.IChannelTerminal;
import committee.nova.mods.avaritia.core.channel.ServerChannelManager;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class ItemChannelTerminal
implements IChannelTerminal {
    private final UUID terminalOwner;
    private final ItemStack terminal;
    private final int slotID;
    private final Inventory inventory;

    public ItemChannelTerminal(Inventory playerInventory, ItemStack itemStack, int slotID) {
        this.inventory = playerInventory;
        this.slotID = slotID;
        this.terminal = itemStack;
        CompoundTag nbt = itemStack.m_41784_();
        this.terminalOwner = nbt.m_128342_("owner");
    }

    @Override
    public UUID getTerminalOwner() {
        return this.terminalOwner;
    }

    @Override
    @Nullable
    public ChannelInfo getChannelInfo() {
        CompoundTag nbt = this.terminal.m_41784_();
        if (!nbt.m_128441_("channel")) {
            return null;
        }
        CompoundTag channel = nbt.m_128469_("channel");
        int channelId = channel.m_128451_("channelID");
        UUID channelOwner = channel.m_128342_("channelOwner");
        return new ChannelInfo(channelOwner, channelId);
    }

    @Override
    public void setChannel(UUID channelOwner, int channelId) {
        CompoundTag channel;
        CompoundTag nbt = this.terminal.m_41784_();
        if (nbt.m_128441_("channel")) {
            channel = nbt.m_128469_("channel");
        } else {
            channel = new CompoundTag();
            nbt.m_128365_("channel", (Tag)channel);
        }
        channel.m_128362_("channelOwner", channelOwner);
        channel.m_128405_("channelID", channelId);
        ServerChannelManager.sendChannelSet((ServerPlayer)this.inventory.f_35978_, this.terminalOwner, channelOwner, channelId);
    }

    @Override
    public void addChannelSelector(ServerPlayer player) {
        ChannelInfo info = this.getChannelInfo();
        if (info == null) {
            return;
        }
        ServerChannelManager.sendChannelSet((ServerPlayer)this.inventory.f_35978_, this.terminalOwner, info.owner(), info.id());
    }

    @Override
    public void removeChannel(ServerPlayer actor) {
        ChannelInfo info = this.getChannelInfo();
        if (info == null) {
            return;
        }
        if (info.owner().equals(actor.m_20148_()) || info.owner().equals(Const.AVARITIA_FAKE_PLAYER.getId())) {
            if (!ServerChannelManager.getInstance().tryRemoveChannel(info.owner(), info.id())) {
                return;
            }
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.inventory.f_35978_), (Object)new S2CChannelActionPack(ChannelAction.SET, -1, "", -1));
            this.terminal.m_41783_().m_128473_("channel");
        }
    }

    @Override
    public void renameChannel(ServerPlayer actor, String name) {
        ChannelInfo info = this.getChannelInfo();
        if (info == null) {
            return;
        }
        if (info.owner().equals(actor.m_20148_()) || info.owner().equals(Const.AVARITIA_FAKE_PLAYER.getId())) {
            ServerChannelManager.getInstance().renameChannel(info, name);
        }
    }

    @Override
    public void removeChannelSelector(ServerPlayer player) {
    }

    @Override
    public boolean stillValid() {
        return this.terminal == this.inventory.m_8020_(this.slotID);
    }

    @Override
    public void tryReOpenMenu(ServerPlayer player) {
        if (this.getChannelInfo() != null) {
            this.terminal.m_41682_(player.m_9236_(), (Player)player, InteractionHand.MAIN_HAND);
        }
    }
}

