/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.core.channel;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.common.net.channel.ChannelAction;
import committee.nova.mods.avaritia.common.net.channel.ChannelState;
import committee.nova.mods.avaritia.common.net.channel.S2CChannelActionPack;
import committee.nova.mods.avaritia.common.net.channel.S2CChannelListPack;
import committee.nova.mods.avaritia.common.net.channel.S2CChannelStatePack;
import committee.nova.mods.avaritia.core.channel.ChannelInfo;
import committee.nova.mods.avaritia.core.channel.NullChannel;
import committee.nova.mods.avaritia.core.channel.ServerChannel;
import committee.nova.mods.avaritia.init.config.ModConfig;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="avaritia", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerChannelManager {
    private static volatile ServerChannelManager instance;
    private CompoundTag userCache;
    private File saveDataPath;
    private boolean loadSuccess = true;
    private final MinecraftServer server;
    private final NullChannel nullChannel = NullChannel.INSTANCE;
    private final HashMap<UUID, HashMap<Integer, ServerChannel>> channelList = new HashMap();
    private final HashMap<ServerPlayer, UUID> channelSelector = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServerChannelManager getInstance() {
        if (instance != null) return instance;
        Class<ServerChannelManager> clazz = ServerChannelManager.class;
        synchronized (ServerChannelManager.class) {
            if (instance != null) return instance;
            instance = new ServerChannelManager(ServerLifecycleHooks.getCurrentServer());
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void newInstance(MinecraftServer server) {
        if (instance != null) return;
        Class<ServerChannelManager> clazz = ServerChannelManager.class;
        synchronized (ServerChannelManager.class) {
            if (instance != null) return;
            instance = new ServerChannelManager(server);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @SubscribeEvent
    public static void onServerLoad(ServerAboutToStartEvent event) {
        ServerChannelManager.newInstance(event.getServer());
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        this.userCache.m_128469_("nameCache").m_128359_(event.getEntity().m_20148_().toString(), event.getEntity().m_36316_().getName());
        NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new S2CChannelStatePack(ChannelState.NAME, this.userCache));
        if (!this.loadSuccess) {
            event.getEntity().m_213846_((Component)Component.m_237115_((String)"info.avaritia.channel.load_error"));
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server = event.getServer();
        if (server == null) {
            return;
        }
        int tickCount = server.m_129921_();
        if (tickCount % (Integer)ModConfig.CHANNEL_FULL_UPDATE_RATE.get() == 0) {
            this.channelList.forEach((uuid, map) -> map.forEach((id, channel) -> channel.sendFullUpdate()));
        } else if (tickCount % (Integer)ModConfig.CHANNEL_FAST_UPDATE_RATE.get() == 0) {
            this.channelList.forEach((uuid, map) -> map.forEach((id, channel) -> channel.sendUpdate()));
        }
    }

    @SubscribeEvent
    public void onLevelSave(LevelEvent.Save event) {
        if (this.isOverworld(event.getLevel())) {
            this.save(event.getLevel().m_7654_());
        }
    }

    @SubscribeEvent
    public void onServerDown(ServerStoppingEvent event) {
        this.save(event.getServer());
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        instance = null;
    }

    private ServerChannelManager(MinecraftServer server) {
        this.server = server;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.load();
    }

    private void load() {
        this.saveDataPath = new File(this.server.m_129843_(LevelResource.f_78182_).toFile(), "data/avaritia/tesseract");
        try {
            File userCacheFile;
            if (!this.saveDataPath.exists()) {
                this.saveDataPath.mkdirs();
            }
            if ((userCacheFile = new File(this.saveDataPath, "UserCache.dat")).exists() && userCacheFile.isFile()) {
                this.userCache = NbtIo.m_128937_((File)userCacheFile);
                if (!this.userCache.m_128441_("nameCache")) {
                    this.initializeNameCache();
                }
            } else {
                this.initializeNameCache();
            }
            Const.LOGGER.info(Component.m_237115_((String)"info.avaritia.channel.load_success").getString());
            File[] channelDirs = this.saveDataPath.listFiles(pathname -> pathname.isDirectory() && pathname.getName().matches("^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$"));
            if (channelDirs != null) {
                for (File dir : channelDirs) {
                    UUID player = UUID.fromString(dir.getName());
                    File[] channels = dir.listFiles(pathname -> pathname.isFile() && pathname.getName().matches("^(0|[1-9][0-9]{0,3})\\.dat$"));
                    if (channels == null) continue;
                    HashMap<Integer, ServerChannel> playerChannels = new HashMap<Integer, ServerChannel>();
                    for (File channelFile : channels) {
                        CompoundTag channelDat = NbtIo.m_128937_((File)channelFile);
                        int channelID = Integer.parseInt(channelFile.getName().substring(0, channelFile.getName().length() - 4));
                        ServerChannel channel = new ServerChannel(channelDat);
                        playerChannels.put(channelID, channel);
                        Const.LOGGER.info(Component.m_237110_((String)"info.avaritia.channel.load_success", (Object[])new Object[]{dir.getName(), channelID, channel.getName()}).getString());
                    }
                    this.channelList.put(player, playerChannels);
                }
            }
            Const.LOGGER.info(Component.m_237115_((String)"info.avaritia.channel.load_finish").getString());
        }
        catch (Exception e) {
            this.loadSuccess = false;
            throw new RuntimeException("\u5728\u52a0\u8f7d\u6570\u636e\u7684\u65f6\u5019\u51fa\u9519\u4e86\uff01 \u672c\u6b21\u6e38\u620f\u5c06\u4e0d\u4f1a\u4fdd\u5b58\u6570\u636e\uff01", e);
        }
    }

    private void save(MinecraftServer server) {
        if (!this.loadSuccess) {
            return;
        }
        try {
            File userCache = new File(this.saveDataPath, "UserCache.dat");
            if (!userCache.exists()) {
                userCache.createNewFile();
            }
            NbtIo.m_128944_((CompoundTag)this.userCache, (File)userCache);
            this.channelList.forEach((uuid, channels) -> {
                File user = new File(this.saveDataPath, uuid.toString());
                if (!user.exists()) {
                    user.mkdir();
                }
                channels.forEach((id, channel) -> {
                    File channelDat = new File(user, id + ".dat");
                    try {
                        if (!channelDat.exists()) {
                            channelDat.createNewFile();
                        }
                        NbtIo.m_128944_((CompoundTag)channel.buildData(), (File)channelDat);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    Const.LOGGER.info(Component.m_237110_((String)"info.avaritia.channel.save_success", (Object[])new Object[]{uuid, id, channel.getName()}).getString());
                });
            });
        }
        catch (Exception e) {
            throw new RuntimeException("\u5728\u4fdd\u5b58\u6570\u636e\u7684\u65f6\u5019\u51fa\u9519\u4e86\uff01 \u4ec0\u4e48\u60c5\u51b5\u5462\uff1f", e);
        }
    }

    private void initializeUserCache() {
        this.userCache = new CompoundTag();
        this.userCache.m_128405_("dataVersion", 1);
    }

    private void initializeNameCache() {
        CompoundTag nameCache = new CompoundTag();
        nameCache.m_128359_(Const.AVARITIA_FAKE_PLAYER.getId().toString(), Const.AVARITIA_FAKE_PLAYER.getName());
        if (this.userCache == null) {
            this.initializeUserCache();
        }
        this.userCache.m_128365_("nameCache", (Tag)nameCache);
    }

    private boolean isOverworld(LevelAccessor level) {
        return !level.m_5776_();
    }

    public CompoundTag getUserCache() {
        return this.userCache;
    }

    public String getUserName(UUID uuid) {
        String userName = this.userCache.m_128469_("nameCache").m_128461_(uuid.toString());
        if (userName.isEmpty()) {
            this.userCache.m_128469_("nameCache").m_128359_(uuid.toString(), "unknownUser");
            NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new S2CChannelStatePack(ChannelState.NAME, this.userCache));
            userName = "unknownUser";
        }
        return userName;
    }

    public ServerChannel getChannel(UUID ownerUUID, int channelId) {
        HashMap<Integer, ServerChannel> list;
        if (this.channelList.containsKey(ownerUUID) && (list = this.channelList.get(ownerUUID)).containsKey(channelId)) {
            return list.get(channelId);
        }
        return this.nullChannel;
    }

    public String getChannelName(UUID ownerUUID, int id) {
        if (!this.channelList.containsKey(ownerUUID)) {
            return "RemovedChannel";
        }
        if (!this.channelList.get(ownerUUID).containsKey(id)) {
            return "RemovedChannel";
        }
        return this.channelList.get(ownerUUID).get(id).getName();
    }

    public void addChannelSelector(ServerPlayer player, UUID otherUUID) {
        this.channelSelector.put(player, otherUUID);
        CompoundTag myChannels = new CompoundTag();
        CompoundTag otherChannels = new CompoundTag();
        CompoundTag publicChannels = new CompoundTag();
        if (this.channelList.containsKey(player.m_20148_())) {
            this.channelList.get(player.m_20148_()).forEach((id, channel) -> myChannels.m_128359_(String.valueOf(id), channel.getName()));
        }
        if (!player.m_20148_().equals(otherUUID) && this.channelList.containsKey(otherUUID)) {
            this.channelList.get(otherUUID).forEach((id, channel) -> otherChannels.m_128359_(String.valueOf(id), channel.getName()));
        }
        if (this.channelList.containsKey(Const.AVARITIA_FAKE_PLAYER.getId())) {
            this.channelList.get(Const.AVARITIA_FAKE_PLAYER.getId()).forEach((id, channel) -> publicChannels.m_128359_(String.valueOf(id), channel.getName()));
        }
        if (!(myChannels.m_128456_() && otherChannels.m_128456_() && publicChannels.m_128456_())) {
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CChannelListPack(myChannels, otherChannels, publicChannels));
        }
    }

    public void tryAddChannel(ServerPlayer player, String name, boolean pub) {
        HashMap<Object, Object> playerChannels;
        UUID uuid = pub ? Const.AVARITIA_FAKE_PLAYER.getId() : player.m_20148_();
        int max = pub ? (Integer)ModConfig.MAX_PUBLIC_CHANNELS.get() : (Integer)ModConfig.MAX_CHANNELS_PRE_PLAYER.get();
        if (this.channelList.containsKey(uuid)) {
            playerChannels = this.channelList.get(uuid);
        } else {
            playerChannels = new HashMap();
            this.channelList.put(uuid, playerChannels);
        }
        if (playerChannels.size() >= max) {
            return;
        }
        for (int i = 0; i < playerChannels.size() + 1; ++i) {
            if (playerChannels.containsKey(i)) continue;
            playerChannels.put(i, new ServerChannel(name));
            this.sendChannelAdd(uuid, name, i);
            Const.LOGGER.info(Component.m_237110_((String)"info.avaritia.channel.add_success", (Object[])new Object[]{uuid, i, name}).getString());
            break;
        }
    }

    public void tryAddChannel(ServerPlayer player, ServerChannel channel, boolean pub) {
        this.tryAddChannel(player, channel.getName(), pub);
    }

    private void sendChannelAdd(UUID channelOwner, String name, int id) {
        if (channelOwner.equals(Const.AVARITIA_FAKE_PLAYER.getId())) {
            this.channelSelector.forEach((player, other) -> NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CChannelActionPack(ChannelAction.ADD, 2, name, id)));
        } else {
            this.channelSelector.forEach((player, other) -> {
                if (player.m_20148_().equals(channelOwner)) {
                    NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CChannelActionPack(ChannelAction.ADD, 0, name, id));
                } else if (channelOwner.equals(other)) {
                    NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CChannelActionPack(ChannelAction.ADD, 1, name, id));
                }
            });
        }
    }

    public boolean tryRemoveChannel(UUID channelOwner, int id) {
        if (!this.channelList.containsKey(channelOwner)) {
            return false;
        }
        HashMap<Integer, ServerChannel> list = this.channelList.get(channelOwner);
        if (!list.containsKey(id)) {
            return false;
        }
        ServerChannel channel = list.get(id);
        if (!channel.isEmpty()) {
            return false;
        }
        if (list.remove(id) != null) {
            channel.setRemoved();
            this.sandChannelRemove(channelOwner, id);
            File file = new File(this.saveDataPath, channelOwner + "/" + id + ".dat");
            file.delete();
            return true;
        }
        return false;
    }

    private void sandChannelRemove(UUID channelOwner, int id) {
        if (channelOwner.equals(Const.AVARITIA_FAKE_PLAYER.getId())) {
            this.channelSelector.forEach((player, other) -> NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CChannelActionPack(ChannelAction.REMOVE, 2, "", id)));
        } else {
            this.channelSelector.forEach((player, other) -> {
                if (player.m_20148_().equals(channelOwner)) {
                    NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CChannelActionPack(ChannelAction.REMOVE, 0, "", id));
                } else if (channelOwner.equals(other)) {
                    NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CChannelActionPack(ChannelAction.REMOVE, 1, "", id));
                }
            });
        }
    }

    public void renameChannel(ChannelInfo info, String name) {
        if (!this.channelList.containsKey(info.owner())) {
            return;
        }
        HashMap<Integer, ServerChannel> list = this.channelList.get(info.owner());
        if (!list.containsKey(info.id())) {
            return;
        }
        ServerChannel channel = list.get(info.id());
        channel.setName(name);
        this.sendChannelAdd(info.owner(), name, info.id());
    }

    public void removeChannelSelector(ServerPlayer player) {
        this.channelSelector.remove(player);
    }

    public static void sendChannelSet(ServerPlayer player, UUID terminalOwner, UUID channelOwner, int channelId) {
        String name = ServerChannelManager.getInstance().getChannelName(channelOwner, channelId);
        if (player.m_20148_().equals(channelOwner)) {
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CChannelActionPack(ChannelAction.SET, 0, name, channelId));
        } else if (terminalOwner.equals(channelOwner)) {
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CChannelActionPack(ChannelAction.SET, 1, name, channelId));
        } else if (Const.AVARITIA_FAKE_PLAYER.getId().equals(channelOwner)) {
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CChannelActionPack(ChannelAction.SET, 2, name, channelId));
        } else if (!name.isEmpty()) {
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CChannelActionPack(ChannelAction.SET, -1, name, -1));
        }
    }
}

