/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.core.singularity;

import committee.nova.mods.avaritia.api.util.lang.Localizable;
import committee.nova.mods.avaritia.init.config.ModConfig;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fml.loading.FMLLoader;

public class Singularity {
    private final ResourceLocation id;
    private final String name;
    private final int[] colors;
    private final String tag;
    private final int ingredientCount;
    private final int timeRequired;
    private Ingredient ingredient;
    private boolean enabled = true;
    private boolean recipeDisabled = false;

    public Singularity(ResourceLocation id, String name, int[] colors, Ingredient ingredient, int ingredientCount, int timeRequired) {
        this.id = id;
        this.name = name;
        this.colors = colors;
        this.ingredient = ingredient;
        this.tag = null;
        this.ingredientCount = ingredientCount;
        this.timeRequired = timeRequired;
    }

    public Singularity(ResourceLocation id, String name, int[] colors, Ingredient ingredient) {
        this(id, name, colors, ingredient, -1, FMLLoader.isProduction() ? (Integer)ModConfig.singularityTimeRequired.get() : 240);
    }

    public Singularity(ResourceLocation id, String name, int[] colors, String tag, int ingredientCount, int timeRequired) {
        this.id = id;
        this.name = name;
        this.colors = colors;
        this.ingredient = Ingredient.f_43901_;
        this.tag = tag;
        this.ingredientCount = ingredientCount;
        this.timeRequired = timeRequired;
    }

    public Singularity(ResourceLocation id, String name, int[] colors, String tag) {
        this(id, name, colors, tag, -1, FMLLoader.isProduction() ? (Integer)ModConfig.singularityTimeRequired.get() : 240);
    }

    public static Singularity read(FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.m_130281_();
        String name = buffer.m_130277_();
        int[] colors = buffer.m_130100_();
        boolean isTagIngredient = buffer.readBoolean();
        int timeRequired = buffer.m_130242_();
        String tag = null;
        Ingredient ingredient = Ingredient.f_43901_;
        if (isTagIngredient) {
            tag = buffer.m_130277_();
        } else {
            ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        }
        int ingredientCount = buffer.m_130242_();
        Singularity singularity = isTagIngredient ? new Singularity(id, name, colors, tag, ingredientCount, timeRequired) : new Singularity(id, name, colors, ingredient, ingredientCount, timeRequired);
        singularity.enabled = buffer.readBoolean();
        singularity.recipeDisabled = buffer.readBoolean();
        return singularity;
    }

    public int getOverlayColor() {
        return this.colors[0];
    }

    public int getUnderlayColor() {
        return this.colors[1];
    }

    public Ingredient getIngredient() {
        if (this.tag != null && this.ingredient == Ingredient.f_43901_) {
            TagKey tag = ItemTags.create((ResourceLocation)new ResourceLocation(this.tag));
            this.ingredient = Ingredient.m_204132_((TagKey)tag);
        }
        return this.ingredient;
    }

    public int getIngredientCount() {
        if (this.ingredientCount == -1) {
            return 1000;
        }
        return this.ingredientCount;
    }

    public Component getDisplayName() {
        return Localizable.of(this.name).build();
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.id);
        buffer.m_130070_(this.name);
        buffer.m_130089_(this.colors);
        buffer.writeBoolean(this.tag != null);
        buffer.m_130130_(this.timeRequired);
        if (this.tag != null) {
            buffer.m_130070_(this.tag);
        } else {
            this.ingredient.m_43923_(buffer);
        }
        buffer.m_130130_(this.ingredientCount);
        buffer.writeBoolean(this.enabled);
        buffer.writeBoolean(this.recipeDisabled);
    }

    @Generated
    public ResourceLocation getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int[] getColors() {
        return this.colors;
    }

    @Generated
    public String getTag() {
        return this.tag;
    }

    @Generated
    public int getTimeRequired() {
        return this.timeRequired;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public void setRecipeDisabled(boolean recipeDisabled) {
        this.recipeDisabled = recipeDisabled;
    }

    @Generated
    public boolean isRecipeDisabled() {
        return this.recipeDisabled;
    }
}

