/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.compat.emi.category.tables;

import committee.nova.mods.avaritia.common.crafting.recipe.EternalSingularityCraftRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.ITierCraftingRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.InfinityCatalystCraftRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.ShapedTableCraftingRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.ShapelessTableCraftingRecipe;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.ModItems;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public record ExtremeCraftingTableCategory(ITierCraftingRecipe recipe) implements EmiRecipe
{
    private static final EmiTexture TEXTURE = new EmiTexture(ResourceLocation.m_214293_((String)"avaritia", (String)"textures/gui/jei/tables/extreme_jei.png"), 0, 0, 189, 162);
    public static final EmiStack WORKSTATION = EmiStack.of((ItemLike)((ItemLike)ModBlocks.extreme_crafting_table.get()));
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(ResourceLocation.m_214293_((String)"avaritia", (String)"extreme_crafting_table"), (EmiRenderable)WORKSTATION);

    public EmiRecipeCategory getCategory() {
        return CATEGORY;
    }

    @NotNull
    public ResourceLocation getId() {
        return this.recipe.m_6423_();
    }

    public List<EmiIngredient> getInputs() {
        return this.recipe.m_7527_().stream().map(EmiIngredient::of).toList();
    }

    public List<EmiStack> getOutputs() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        assert (level != null);
        return List.of(EmiStack.of((ItemStack)this.recipe.m_8043_(level.m_9598_())));
    }

    public boolean supportsRecipeTree() {
        return true;
    }

    public int getDisplayWidth() {
        return 191;
    }

    public int getDisplayHeight() {
        return 164;
    }

    public void addWidgets(WidgetHolder widgets) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        assert (level != null);
        NonNullList inputs = this.recipe.m_7527_();
        ItemStack output = this.recipe.m_8043_(level.m_9598_());
        widgets.addTexture(TEXTURE, 1, 1);
        ITierCraftingRecipe iTierCraftingRecipe = this.recipe;
        if (iTierCraftingRecipe instanceof ShapedTableCraftingRecipe) {
            ShapedTableCraftingRecipe shaped = (ShapedTableCraftingRecipe)iTierCraftingRecipe;
            int stackIndex = 0;
            int heightOffset = Math.floorDiv(9 - shaped.getHeight(), 2);
            int widthOffset = Math.floorDiv(9 - shaped.getWidth(), 2);
            for (int i = heightOffset; i < shaped.getHeight() + heightOffset; ++i) {
                for (int j = widthOffset; j < shaped.getWidth() + widthOffset; ++j) {
                    widgets.addSlot(EmiIngredient.of((Ingredient)((Ingredient)inputs.get(stackIndex))), j * 18 + 2, i * 18 + 2).drawBack(false);
                    ++stackIndex;
                }
            }
            widgets.addSlot((EmiIngredient)EmiStack.of((ItemStack)output), 164, 70).large(true).recipeContext((EmiRecipe)this).drawBack(false);
        } else if (this.recipe instanceof ShapelessTableCraftingRecipe) {
            this.shapelessRecipe(widgets, (NonNullList<Ingredient>)inputs);
            widgets.addSlot((EmiIngredient)EmiStack.of((ItemStack)output), 164, 70).large(true).recipeContext((EmiRecipe)this).drawBack(false);
        } else if (this.recipe instanceof InfinityCatalystCraftRecipe) {
            this.shapelessRecipe(widgets, (NonNullList<Ingredient>)inputs);
            widgets.addSlot((EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModItems.infinity_catalyst.get())), 164, 70).large(true).recipeContext((EmiRecipe)this).drawBack(false);
        } else if (this.recipe instanceof EternalSingularityCraftRecipe) {
            this.shapelessRecipe(widgets, (NonNullList<Ingredient>)inputs);
            widgets.addSlot((EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModItems.eternal_singularity.get())), 164, 70).large(true).recipeContext((EmiRecipe)this).drawBack(false);
        }
    }

    private void shapelessRecipe(@NotNull WidgetHolder widgetHolder, NonNullList<Ingredient> inputs) {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                int index = j + i * 9;
                if (index >= inputs.size()) continue;
                widgetHolder.addSlot(EmiIngredient.of((Ingredient)((Ingredient)inputs.get(index))), j * 18 + 2, i * 18 + 2).drawBack(false);
            }
        }
        widgetHolder.addTexture(EmiTexture.SHAPELESS, 166, 150);
    }
}

