/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.compat.jei.category.tables;

import committee.nova.mods.avaritia.api.util.lang.Localizable;
import committee.nova.mods.avaritia.common.crafting.recipe.EternalSingularityCraftRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.ITierCraftingRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.InfinityCatalystCraftRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.ShapedTableCraftingRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.ShapelessTableCraftingRecipe;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.ModItems;
import java.util.Collections;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ExtremeCraftingTableCategory
implements IRecipeCategory<ITierCraftingRecipe> {
    public static final RecipeType<ITierCraftingRecipe> RECIPE_TYPE = RecipeType.create((String)"avaritia", (String)"extreme_craft", ITierCraftingRecipe.class);
    private static final ResourceLocation TEXTURE = new ResourceLocation("avaritia", "textures/gui/jei/tables/extreme_jei.png");
    private final IDrawable background;
    private final IDrawable icon;

    public ExtremeCraftingTableCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 189, 163);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.extreme_crafting_table.get()));
    }

    @NotNull
    public RecipeType<ITierCraftingRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Localizable.of("jei.category.avaritia.extreme_crafting_table").build();
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return 189;
    }

    public int getHeight() {
        return 163;
    }

    public void draw(@NotNull ITierCraftingRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, ITierCraftingRecipe recipe, @NotNull IFocusGroup focuses) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        assert (level != null);
        NonNullList inputs = recipe.m_7527_();
        ItemStack output = recipe.m_8043_(level.m_9598_());
        if (recipe instanceof ShapedTableCraftingRecipe) {
            ShapedTableCraftingRecipe shaped = (ShapedTableCraftingRecipe)recipe;
            int stackIndex = 0;
            int heightOffset = Math.floorDiv(9 - shaped.getHeight(), 2);
            int widthOffset = Math.floorDiv(9 - shaped.getWidth(), 2);
            for (int i = heightOffset; i < shaped.getHeight() + heightOffset; ++i) {
                for (int j = widthOffset; j < shaped.getWidth() + widthOffset; ++j) {
                    builder.addSlot(RecipeIngredientRole.INPUT, j * 18 + 2, i * 18 + 2).addIngredients((Ingredient)inputs.get(stackIndex));
                    ++stackIndex;
                }
            }
            builder.addSlot(RecipeIngredientRole.OUTPUT, 167, 73).addItemStack(output);
        } else if (recipe instanceof ShapelessTableCraftingRecipe) {
            this.shapelessRecipe(builder, (NonNullList<Ingredient>)inputs);
            builder.addSlot(RecipeIngredientRole.OUTPUT, 167, 73).addItemStack(output);
        } else if (recipe instanceof InfinityCatalystCraftRecipe) {
            this.shapelessRecipe(builder, (NonNullList<Ingredient>)inputs);
            builder.addSlot(RecipeIngredientRole.OUTPUT, 167, 73).addItemStack(new ItemStack((ItemLike)ModItems.infinity_catalyst.get()));
        } else if (recipe instanceof EternalSingularityCraftRecipe) {
            this.shapelessRecipe(builder, (NonNullList<Ingredient>)inputs);
            builder.addSlot(RecipeIngredientRole.OUTPUT, 167, 73).addItemStack(new ItemStack((ItemLike)ModItems.eternal_singularity.get()));
        }
        builder.moveRecipeTransferButton(170, 120);
    }

    private void shapelessRecipe(@NotNull IRecipeLayoutBuilder builder, NonNullList<Ingredient> inputs) {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                int index = j + i * 9;
                if (index >= inputs.size()) continue;
                builder.addSlot(RecipeIngredientRole.INPUT, j * 18 + 2, i * 18 + 2).addIngredients((Ingredient)inputs.get(index));
            }
        }
        builder.setShapeless(163, 150);
    }

    public void getTooltip(@NotNull ITooltipBuilder tooltip, @NotNull ITierCraftingRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        boolean shapeless = recipe instanceof ShapelessTableCraftingRecipe;
        int sX = (shapeless ? 340 : 306) / 2;
        int sY = 100;
        if (shapeless && mouseX > (double)(sX + 10) && mouseX < (double)(sX + 20) && mouseY > (double)(sY - 1) && mouseY < (double)(sY + 8)) {
            tooltip.addAll(Collections.singletonList(Localizable.of("jei.tooltip.shapeless.recipe").build()));
        }
    }
}

