/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.compat.kubejs;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.core.singularity.Singularity;
import committee.nova.mods.avaritia.core.singularity.SingularityDataManager;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.component.BooleanComponent;
import dev.latvian.mods.kubejs.recipe.component.ItemComponents;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.component.StringComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import java.util.Arrays;

public interface SingularitySchema {
    public static final RecipeKey<String> ID = StringComponent.NON_BLANK.key("id").alt("\u5947\u70b9id").optional((Object)"NULL");
    public static final RecipeKey<String> NAME = StringComponent.NON_BLANK.key("name").alt("\u5947\u70b9\u663e\u793a\u540d\u79f0").optional((Object)"Custom Singularity");
    public static final RecipeKey<String[]> COLORS = StringComponent.NON_BLANK.asArray().key("colors").alt("\u5947\u70b9\u989c\u8272 [\u8986\u76d6\u8272, \u5e95\u5c42\u8272]").optional((Object)new String[]{"FFFFFF", "000000"});
    public static final RecipeKey<InputItem> INGREDIENT = ItemComponents.INPUT.key("ingredient").alt("\u5947\u70b9\u6750\u6599").allowEmpty().optional((Object)InputItem.EMPTY);
    public static final RecipeKey<String> TAG = StringComponent.ANY.key("tag").alt("\u6750\u6599\u6807\u7b7e").allowEmpty().optional((Object)"");
    public static final RecipeKey<Integer> MATERIAL_COUNT = NumberComponent.INT.key("materialCount").alt("\u6240\u9700\u6750\u6599\u6570\u91cf").optional((Object)1000);
    public static final RecipeKey<Integer> TIME_REQUIRED = NumberComponent.INT.key("timeRequired").alt("\u538b\u7f29\u65f6\u95f4(\u523b)").optional((Object)200);
    public static final RecipeKey<Boolean> ENABLED = BooleanComponent.BOOLEAN.key("enabled").alt("\u662f\u5426\u542f\u7528").optional((Object)true);
    public static final RecipeKey<Boolean> RECIPE_DISABLED = BooleanComponent.BOOLEAN.key("recipeDisabled").alt("\u662f\u5426\u7981\u7528\u914d\u65b9").optional((Object)false);
    public static final RecipeSchema SCHEMA = new RecipeSchema(SingularityJS.class, SingularityJS::new, new RecipeKey[]{ID, NAME, COLORS, INGREDIENT, TAG, MATERIAL_COUNT, TIME_REQUIRED, ENABLED, RECIPE_DISABLED});

    public static class SingularityJS
    extends RecipeJS {
        private Singularity singularity;

        public boolean hasInput(ReplacementMatch match) {
            return this.getValue(INGREDIENT) != null || this.getValue(TAG) != null;
        }

        public void afterLoaded() {
            super.afterLoaded();
            String id = (String)this.getValue(ID);
            String name = (String)this.getValue(NAME);
            Object[] colors = (String[])this.getValue(COLORS);
            InputItem ingredient = (InputItem)this.getValue(INGREDIENT);
            String tag = (String)this.getValue(TAG);
            int materialCount = (Integer)this.getValue(MATERIAL_COUNT);
            int timeRequired = (Integer)this.getValue(TIME_REQUIRED);
            boolean enabled = (Boolean)this.getValue(ENABLED);
            boolean recipeDisabled = (Boolean)this.getValue(RECIPE_DISABLED);
            int[] colorInts = new int[2];
            try {
                if (colors.length >= 2) {
                    colorInts[0] = Integer.parseInt((String)colors[0], 16);
                    colorInts[1] = Integer.parseInt((String)colors[1], 16);
                } else if (colors.length == 1) {
                    colorInts[0] = Integer.parseInt((String)colors[0], 16);
                    colorInts[1] = 0;
                } else {
                    colorInts[0] = 0xFFFFFF;
                    colorInts[1] = 0;
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid color format: " + Arrays.toString(colors) + ". Colors should be 6-digit hex strings (e.g., 'FF0000')");
            }
            if (tag != null && !tag.isEmpty()) {
                this.singularity = new Singularity(Const.rl(id), name, colorInts, tag, materialCount, timeRequired);
            } else if (ingredient != null && !ingredient.isEmpty()) {
                this.singularity = new Singularity(Const.rl(id), name, colorInts, ingredient.kjs$asIngredient(), materialCount, timeRequired);
            } else {
                throw new IllegalArgumentException("Singularity must have either 'ingredient' or 'tag' specified");
            }
            this.singularity.setEnabled(enabled);
            this.singularity.setRecipeDisabled(recipeDisabled);
            SingularityDataManager manager = SingularityDataManager.getInstance();
            if (manager.isInitialized()) {
                manager.registerRuntimeSingularity(this.singularity);
            }
        }

        public Singularity getSingularity() {
            return this.singularity;
        }
    }
}

