/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.compat.projecte;

import committee.nova.mods.avaritia.common.crafting.recipe.CompressorRecipe;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import committee.nova.mods.avaritia.util.IngredientUtils;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;

@RecipeTypeMapper
public class AvaritiaCompressorRecipeMapper
implements IRecipeTypeMapper {
    public String getName() {
        return "Avaritia Compressor";
    }

    public String getDescription() {
        return "Maps avaritia recipes.";
    }

    public boolean canHandle(RecipeType<?> recipeType) {
        return recipeType == ModRecipeTypes.COMPRESSOR_RECIPE.get();
    }

    public boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, Recipe<?> recipe, RegistryAccess registryAccess, INSSFakeGroupManager fakeGroupManager) {
        if (!(recipe instanceof CompressorRecipe)) {
            return false;
        }
        CompressorRecipe compressorRecipe = (CompressorRecipe)recipe;
        boolean handled = false;
        NonNullList<Ingredient> ingredients = compressorRecipe.m_7527_();
        int timeRequire = compressorRecipe.getTimeCost();
        for (Ingredient representation : ingredients) {
            for (ItemStack input : representation.m_43908_()) {
                NSSItem inputStack = NSSItem.createItem((ItemStack)input);
                ItemStack output = compressorRecipe.getResultItem();
                if (output.m_41619_()) continue;
                IngredientUtils ingredientHelper = new IngredientUtils(mapper);
                ingredientHelper.put((NormalizedSimpleStack)inputStack, compressorRecipe.getInputCount() * timeRequire / 240);
                if (!ingredientHelper.addAsConversion(output)) continue;
                handled = true;
            }
        }
        return handled;
    }
}

