/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.data.provider;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.core.singularity.Singularity;
import committee.nova.mods.avaritia.init.registry.ModSingularities;
import committee.nova.mods.avaritia.util.SingularityUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class ModSingularityProvider
implements DataProvider {
    private final DataGenerator generator;
    private final PackOutput.PathProvider pathProvider;
    private final ExistingFileHelper fileHelper;
    private final Map<ResourceLocation, Singularity> singularities = new TreeMap<ResourceLocation, Singularity>();

    public ModSingularityProvider(DataGenerator generator, ExistingFileHelper fileHelper) {
        this.generator = generator;
        this.pathProvider = generator.getPackOutput().m_245269_(PackOutput.Target.DATA_PACK, "singularities");
        this.fileHelper = fileHelper;
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput output) {
        ArrayList<CompletableFuture> list = new ArrayList<CompletableFuture>();
        this.singularities.clear();
        this.collectDefaultSingularities();
        for (Map.Entry<ResourceLocation, Singularity> entry : this.singularities.entrySet()) {
            ResourceLocation id = entry.getKey();
            Singularity singularity = entry.getValue();
            JsonObject json = SingularityUtils.writeToJson(singularity);
            Path path = this.pathProvider.m_245731_(id);
            list.add(DataProvider.m_253162_((CachedOutput)output, (JsonElement)json, (Path)path));
        }
        Const.LOGGER.info("Generated {} singularity data files", (Object)this.singularities.size());
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    private void collectDefaultSingularities() {
        for (Singularity singularity : ModSingularities.getDefaults()) {
            this.singularities.put(singularity.getId(), singularity);
        }
        Const.LOGGER.debug("Collected {} default singularities for data generation", (Object)this.singularities.size());
    }

    @NotNull
    public String m_6055_() {
        return "Avaritia Singularities Data Provider";
    }
}

