/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.registry;

import committee.nova.mods.avaritia.api.common.block.BaseBlock;
import committee.nova.mods.avaritia.common.block.ResourceBlock;
import committee.nova.mods.avaritia.common.block.cake.EndlessCakeBlock;
import committee.nova.mods.avaritia.common.block.chest.CompressedChestBlock;
import committee.nova.mods.avaritia.common.block.chest.InfinityChestBlock;
import committee.nova.mods.avaritia.common.block.chest.TesseractBlock;
import committee.nova.mods.avaritia.common.block.collector.NeutronCollectorBlock;
import committee.nova.mods.avaritia.common.block.compressor.NeutronCompressorBlock;
import committee.nova.mods.avaritia.common.block.craft.CompressedCraftTableBlock;
import committee.nova.mods.avaritia.common.block.craft.DoubleCompressedCraftTableBlock;
import committee.nova.mods.avaritia.common.block.craft.TierCraftTableBlock;
import committee.nova.mods.avaritia.common.block.extreme.ExtremeAnvilBlock;
import committee.nova.mods.avaritia.common.block.extreme.ExtremeSmithingTableBlock;
import committee.nova.mods.avaritia.common.block.misc.SoulFarmLandBlock;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.init.registry.enums.ModCraftTier;
import committee.nova.mods.avaritia.init.registry.enums.ModResourceBlocks;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"avaritia");
    public static RegistryObject<Block> compressed_crafting_table = ModBlocks.itemBlock("compressed_crafting_table", CompressedCraftTableBlock::new, ModRarities.UNCOMMON);
    public static RegistryObject<Block> double_compressed_crafting_table = ModBlocks.itemBlock("double_compressed_crafting_table", DoubleCompressedCraftTableBlock::new, ModRarities.UNCOMMON);
    public static RegistryObject<Block> neutron = ModBlocks.itemBlock("neutron", () -> new ResourceBlock(ModResourceBlocks.NEUTRON), ModRarities.EPIC);
    public static RegistryObject<Block> infinity = ModBlocks.itemBlock("infinity", () -> new ResourceBlock(ModResourceBlocks.INFINITY), ModRarities.COSMIC);
    public static RegistryObject<Block> crystal_matrix = ModBlocks.itemBlock("crystal_matrix", () -> new ResourceBlock(ModResourceBlocks.CRYSTAL), ModRarities.RARE);
    public static RegistryObject<Block> blaze_cube_block = ModBlocks.itemBlock("blaze_cube_block", () -> new ResourceBlock(ModResourceBlocks.BLAZE), ModRarities.RARE);
    public static RegistryObject<Block> compressed_chest = ModBlocks.itemBlock("compressed_chest", CompressedChestBlock::new, ModRarities.RARE);
    public static RegistryObject<Block> infinity_chest = ModBlocks.baseBlock("infinity_chest", InfinityChestBlock::new);
    public static RegistryObject<Block> tesseract = ModBlocks.itemBlock("tesseract", TesseractBlock::new, ModRarities.LEGEND);
    public static RegistryObject<Block> soul_farmland = ModBlocks.itemBlock("soul_farmland", SoulFarmLandBlock::new, ModRarities.RARE);
    public static RegistryObject<Block> diamond_lattice_block = ModBlocks.itemBlock("diamond_lattice_block", () -> new BaseBlock(BlockBehaviour.Properties.m_284310_().m_60913_(100.0f, 100.0f).m_60918_(SoundType.f_56744_)), true, new Item.Properties().m_41497_(ModRarities.UNCOMMON));
    public static RegistryObject<Block> star_fuel_block = ModBlocks.itemBurnBlock("star_fuel_block", () -> new BaseBlock(BlockBehaviour.Properties.m_284310_().m_60913_(100.0f, 200.0f).m_60918_(SoundType.f_56742_)), true, new Item.Properties().m_41497_(ModRarities.RARE), Integer.MAX_VALUE);
    public static RegistryObject<Block> refined_coal_block = ModBlocks.itemBurnBlock("refined_coal_block", () -> new BaseBlock(BlockBehaviour.Properties.m_284310_().m_60913_(50.0f, 50.0f).m_60918_(SoundType.f_56742_)), true, new Item.Properties().m_41497_(ModRarities.UNCOMMON), 1440000);
    public static RegistryObject<Block> sculk_crafting_table = ModBlocks.itemBlock("sculk_crafting_table", () -> new TierCraftTableBlock(ModCraftTier.SCULK), ModRarities.COMMON);
    public static RegistryObject<Block> nether_crafting_table = ModBlocks.itemBlock("nether_crafting_table", () -> new TierCraftTableBlock(ModCraftTier.NETHER), ModRarities.UNCOMMON);
    public static RegistryObject<Block> end_crafting_table = ModBlocks.itemBlock("end_crafting_table", () -> new TierCraftTableBlock(ModCraftTier.END), ModRarities.RARE);
    public static RegistryObject<Block> extreme_crafting_table = ModBlocks.itemBlock("extreme_crafting_table", () -> new TierCraftTableBlock(ModCraftTier.EXTREME), ModRarities.EPIC);
    public static RegistryObject<Block> neutron_collector = ModBlocks.itemBlock("neutron_collector", NeutronCollectorBlock::new, ModRarities.RARE);
    public static RegistryObject<Block> dense_neutron_collector = ModBlocks.itemBlock("dense_neutron_collector", NeutronCollectorBlock::new, ModRarities.EPIC);
    public static RegistryObject<Block> denser_neutron_collector = ModBlocks.itemBlock("denser_neutron_collector", NeutronCollectorBlock::new, ModRarities.LEGEND);
    public static RegistryObject<Block> densest_neutron_collector = ModBlocks.itemBlock("densest_neutron_collector", NeutronCollectorBlock::new, ModRarities.COSMIC);
    public static RegistryObject<Block> neutron_compressor = ModBlocks.itemBlock("neutron_compressor", NeutronCompressorBlock::new, ModRarities.RARE);
    public static RegistryObject<Block> dense_neutron_compressor = ModBlocks.itemBlock("dense_neutron_compressor", NeutronCompressorBlock::new, ModRarities.EPIC);
    public static RegistryObject<Block> denser_neutron_compressor = ModBlocks.itemBlock("denser_neutron_compressor", NeutronCompressorBlock::new, ModRarities.LEGEND);
    public static RegistryObject<Block> densest_neutron_compressor = ModBlocks.itemBlock("densest_neutron_compressor", NeutronCompressorBlock::new, ModRarities.COSMIC);
    public static RegistryObject<Block> extreme_smithing_table = ModBlocks.itemBlock("extreme_smithing_table", ExtremeSmithingTableBlock::new, ModRarities.LEGEND);
    public static RegistryObject<Block> extreme_anvil = ModBlocks.itemBlock("extreme_anvil", ExtremeAnvilBlock::new, ModRarities.LEGEND);
    public static RegistryObject<Block> endless_cake = ModBlocks.itemBlock("endless_cake", EndlessCakeBlock::new, ModRarities.UNCOMMON);

    private static RegistryObject<Block> baseBlock(String name, Supplier<Block> block) {
        return BLOCKS.register(name, block);
    }

    public static RegistryObject<Block> itemBlock(String name, Supplier<Block> block) {
        return ModBlocks.itemBlock(name, block, true);
    }

    public static RegistryObject<Block> itemBlock(String name, Supplier<Block> block, boolean hasItem) {
        return ModBlocks.itemBlock(name, block, hasItem, true, new Item.Properties());
    }

    public static RegistryObject<Block> itemBlock(String name, Supplier<Block> block, boolean hasItem, boolean exist) {
        return ModBlocks.itemBlock(name, block, hasItem, exist, new Item.Properties());
    }

    public static RegistryObject<Block> itemBlock(String name, Supplier<Block> block, Rarity rarity) {
        return ModBlocks.itemBlock(name, block, true, true, new Item.Properties().m_41497_(rarity));
    }

    public static RegistryObject<Block> itemBlock(String name, Supplier<Block> block, boolean hasItem, Item.Properties properties) {
        return ModBlocks.itemBlock(name, block, hasItem, true, properties);
    }

    public static RegistryObject<Block> itemBlock(String name, Supplier<Block> block, boolean hasItem, boolean exist, Item.Properties properties) {
        RegistryObject reg = BLOCKS.register(name, block);
        if (hasItem) {
            ModItems.item(name, () -> new BlockItem((Block)reg.get(), properties), exist);
        }
        return reg;
    }

    public static RegistryObject<Block> itemBurnBlock(String name, Supplier<Block> block, boolean hasItem, Item.Properties properties, final int burnTime) {
        RegistryObject reg = BLOCKS.register(name, block);
        if (hasItem) {
            ModItems.item(name, () -> new BlockItem((Block)reg.get(), properties){

                public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
                    return burnTime;
                }
            });
        }
        return reg;
    }
}

