/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.util.NBTUtils;
import committee.nova.mods.avaritia.core.singularity.Singularity;
import committee.nova.mods.avaritia.core.singularity.SingularityDataManager;
import committee.nova.mods.avaritia.init.config.ModConfig;
import committee.nova.mods.avaritia.init.registry.ModItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class SingularityUtils {
    public static Singularity loadFromJson(ResourceLocation id, JsonObject json, ICondition.IContext context) {
        Singularity singularity;
        if (!CraftingHelper.processConditions((JsonObject)json, (String)"conditions", (ICondition.IContext)context)) {
            Const.LOGGER.info("Skipping loading Singularity {} as its conditions were not met!", (Object)id);
            return null;
        }
        String name = GsonHelper.m_13906_((JsonObject)json, (String)"name");
        JsonArray colors = GsonHelper.m_13933_((JsonObject)json, (String)"colors");
        int materialCount = Const.isLoad("projecte") ? 10000 : GsonHelper.m_13824_((JsonObject)json, (String)"materialCount", (int)1000);
        int overlayColor = Integer.parseInt(colors.get(0).getAsString(), 16);
        int underlayColor = Integer.parseInt(colors.get(1).getAsString(), 16);
        JsonObject ing = GsonHelper.m_13841_((JsonObject)json, (String)"ingredient", null);
        int time = GsonHelper.m_13824_((JsonObject)json, (String)"timeRequired", (int)((Integer)ModConfig.singularityTimeRequired.get()));
        if (ing == null) {
            singularity = new Singularity(id, name, new int[]{overlayColor, underlayColor}, Ingredient.f_43901_, materialCount, time);
        } else if (ing.has("tag")) {
            String tag = ing.get("tag").getAsString();
            singularity = new Singularity(id, name, new int[]{overlayColor, underlayColor}, tag, materialCount, time);
        } else {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            singularity = new Singularity(id, name, new int[]{overlayColor, underlayColor}, ingredient, materialCount, time);
        }
        boolean enabled = GsonHelper.m_13855_((JsonObject)json, (String)"enabled", (boolean)true);
        boolean recipeDisabled = GsonHelper.m_13855_((JsonObject)json, (String)"recipeDisabled", (boolean)false);
        singularity.setEnabled(enabled);
        singularity.setRecipeDisabled(recipeDisabled);
        return singularity;
    }

    public static JsonObject writeToJson(Singularity singularity) {
        JsonElement ingredient;
        JsonObject json = new JsonObject();
        json.addProperty("name", singularity.getName());
        JsonArray colors = new JsonArray();
        colors.add(Integer.toString(singularity.getOverlayColor(), 16));
        colors.add(Integer.toString(singularity.getUnderlayColor(), 16));
        json.add("colors", (JsonElement)colors);
        json.addProperty("timeRequired", (Number)singularity.getTimeRequired());
        if (singularity.getTag() != null) {
            JsonObject obj = new JsonObject();
            obj.addProperty("tag", singularity.getTag());
            ingredient = obj;
            JsonArray array = new JsonArray();
            JsonObject main = new JsonObject();
            JsonObject sub = new JsonObject();
            main.addProperty("type", "forge:not");
            sub.addProperty("tag", singularity.getTag());
            sub.addProperty("type", "forge:tag_empty");
            main.add("value", (JsonElement)sub);
            array.add((JsonElement)main);
            json.add("conditions", (JsonElement)array);
        } else {
            ingredient = singularity.getIngredient().m_43942_();
        }
        json.add("ingredient", ingredient);
        json.addProperty("enabled", Boolean.valueOf(singularity.isEnabled()));
        json.addProperty("recipeDisabled", Boolean.valueOf(singularity.isRecipeDisabled()));
        return json;
    }

    public static CompoundTag makeTag(Singularity singularity) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("Id", singularity.getId().toString());
        return nbt;
    }

    public static ItemStack getItemForSingularity(Singularity singularity) {
        CompoundTag nbt = SingularityUtils.makeTag(singularity);
        ItemStack stack = new ItemStack((ItemLike)ModItems.singularity.get());
        stack.m_41751_(nbt);
        return stack;
    }

    public static Singularity getSingularity(ItemStack stack) {
        SingularityDataManager manager;
        String id = NBTUtils.getString(stack, "Id");
        if (!id.isEmpty() && (manager = SingularityDataManager.getInstance()) != null && manager.isInitialized()) {
            return manager.getSingularity(ResourceLocation.m_135820_((String)id));
        }
        return null;
    }
}

