/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import committee.nova.mods.avaritia.api.util.InventoryUtils;
import committee.nova.mods.avaritia.common.entity.BladeSlashEntity;
import committee.nova.mods.avaritia.common.entity.arrow.HeavenSubArrowEntity;
import committee.nova.mods.avaritia.common.entity.arrow.TraceArrowEntity;
import committee.nova.mods.avaritia.common.item.tools.InfinityArmorItem;
import committee.nova.mods.avaritia.init.config.ModConfig;
import committee.nova.mods.avaritia.init.registry.ModDamageTypes;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModTags;
import committee.nova.mods.avaritia.util.ClustersUtils;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolUtils {
    public static final Set<TagKey<Block>> materialsPick = Sets.newHashSet((Object[])new TagKey[]{BlockTags.f_144282_, Tags.Blocks.STONE, Tags.Blocks.STORAGE_BLOCKS, Tags.Blocks.GLASS, Tags.Blocks.ORES, BlockTags.f_215824_, Tags.Blocks.ORE_BEARING_GROUND_DEEPSLATE, Tags.Blocks.COBBLESTONE_DEEPSLATE, BlockTags.f_144287_});
    public static final Set<TagKey<Block>> materialsAxe = Sets.newHashSet((Object[])new TagKey[]{BlockTags.f_13106_, BlockTags.f_201924_, BlockTags.f_13035_});
    public static final Set<TagKey<Block>> materialsShovel = Sets.newHashSet((Object[])new TagKey[]{BlockTags.f_144283_});
    private static final List<String> projectileAntiImmuneEntities = Lists.newArrayList((Object[])new String[]{"minecraft:enderman", "minecraft:wither", "minecraft:ender_dragon", "draconicevolution:guardian_wither"});

    public static boolean canUseTool(BlockState state, Set<TagKey<Block>> keySets) {
        return state.m_204343_().collect(Collectors.toSet()).retainAll(keySets);
    }

    public static void destroy(ServerLevel world, Player player, BlockPos pos) {
        world.m_46597_(pos, Blocks.f_50016_.m_49966_());
        world.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)world.m_8055_(pos)));
    }

    public static boolean isPlayerWearing(LivingEntity entity, EquipmentSlot slot, Predicate<Item> predicate) {
        ItemStack stack = entity.m_6844_(slot);
        return !stack.m_41619_() && predicate.test(stack.m_41720_());
    }

    public static boolean isInfinite(LivingEntity player) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || !(stack = player.m_6844_(slot)).m_41619_() && stack.m_41720_() instanceof InfinityArmorItem) continue;
            return false;
        }
        return true;
    }

    public static void destroyMaterialBlocks(ServerPlayer player, BlockPos startPos, int range, Set<TagKey<Block>> materials) {
        ServerLevel world = player.m_284548_();
        int halfRange = range / 2;
        BlockPos minPos = startPos.m_7918_(-halfRange, -halfRange, -halfRange);
        BlockPos maxPos = startPos.m_7918_(halfRange, halfRange, halfRange);
        HashSet drops = Sets.newHashSet();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)minPos, (BlockPos)maxPos)) {
            BlockPos currentPos = pos.m_7949_();
            BlockState state = world.m_8055_(currentPos);
            if (!ToolUtils.canUseTool(state, materials) || !state.m_60734_().canHarvestBlock(state, (BlockGetter)world, currentPos, (Player)player)) continue;
            List blockDrops = Block.m_49869_((BlockState)state, (ServerLevel)world, (BlockPos)currentPos, null);
            if (!blockDrops.isEmpty()) {
                drops.addAll(blockDrops);
            } else {
                ResourceLocation blockKey = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
                Item blockItem = (Item)ForgeRegistries.ITEMS.getValue(blockKey);
                if (blockItem != Items.f_41852_ && blockItem != null) {
                    drops.add(new ItemStack((ItemLike)blockItem));
                }
            }
            world.m_46953_(currentPos, false, (Entity)player);
            world.m_5594_(null, currentPos, state.m_60827_().m_56775_(), SoundSource.BLOCKS, 0.5f, 1.0f);
            world.m_46796_(2001, currentPos, Block.m_49956_((BlockState)state));
        }
        ClustersUtils.spawnClusters((Level)world, (Player)player, drops);
    }

    public static void removeBlockWithDrops(ServerLevel world, Player player, BlockPos pos, ItemStack stack, Set<ItemStack> drops, Set<TagKey<Block>> validMaterials) {
        if (!world.m_46749_(pos)) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (world.f_46443_) {
            return;
        }
        if (state.m_60713_(Blocks.f_50034_) && stack.m_150930_((Item)ModItems.infinity_pickaxe.get())) {
            world.m_46597_(pos, Blocks.f_50493_.m_49966_());
        }
        if (!block.canHarvestBlock(state, (BlockGetter)world, pos, player) || !ToolUtils.canUseTool(state, validMaterials)) {
            return;
        }
        List blockDrops = Block.m_49869_((BlockState)state, (ServerLevel)world, (BlockPos)pos, null);
        if (!blockDrops.isEmpty()) {
            drops.addAll(blockDrops);
        } else {
            ResourceLocation blockKey = BuiltInRegistries.f_256975_.m_7981_((Object)block);
            Item blockItem = (Item)BuiltInRegistries.f_257033_.m_7745_(blockKey);
            drops.add(new ItemStack((ItemLike)blockItem));
        }
        if (!(block instanceof BaseFireBlock)) {
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
        ToolUtils.destroy(world, player, pos);
    }

    public static void arrowBarrage(Entity shooter, Level level, List<Entity> piercedAndKilledEntities, AbstractArrow.Pickup pickup, RandomSource randy, BlockPos pos) {
        for (int i = 0; i < 50; ++i) {
            double angle = randy.m_188500_() * 9.0 * Math.PI;
            double dist = randy.m_188583_() * 0.8;
            double x = Math.sin(angle) * dist + (double)pos.m_123341_();
            double z = Math.cos(angle) * dist + (double)pos.m_123343_();
            double y = (double)pos.m_123342_() + 25.0;
            double dangle = randy.m_188500_() * 9.0 * Math.PI;
            double dDist = randy.m_188500_() * 0.35;
            double dx = Math.sin(dangle) * dDist;
            double dz = Math.cos(dangle) * dDist;
            HeavenSubArrowEntity subArrow = new HeavenSubArrowEntity(level, shooter, x, y, z);
            subArrow.f_36702_ = piercedAndKilledEntities;
            subArrow.m_5997_(dx, -(randy.m_188500_() * 1.85 + 0.15), dz);
            subArrow.m_36762_(true);
            subArrow.m_36781_(((Integer)ModConfig.subArrowDamage.get()).intValue());
            subArrow.f_36705_ = pickup;
            level.m_7967_((Entity)subArrow);
        }
    }

    public static DamageSource getArrowDamageSource(Level level, AbstractArrow arrow, Entity owner, Entity target) {
        DamageSource damagesource;
        if (owner == null) {
            damagesource = target.m_269291_().m_269418_(arrow, (Entity)arrow);
        } else {
            damagesource = target.m_269291_().m_269418_(arrow, owner);
            if (owner instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)owner;
                livingEntity.m_21335_(target);
            }
        }
        if (owner != null && projectileAntiImmuneEntities.contains(Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_())).toString())) {
            damagesource = ModDamageTypes.causeRandomDamage(level, owner);
        }
        return damagesource;
    }

    public static void infinityTraceArrowDamage(Level level, @NotNull EntityHitResult result, TraceArrowEntity arrow) {
        Player player;
        TraceArrowEntity owner;
        Entity entity = result.m_82443_();
        float f = (float)arrow.m_20184_().m_82553_();
        int i = Mth.m_14165_((double)Mth.m_14008_((double)((double)f * arrow.m_36789_()), (double)0.0, (double)2.147483647E9));
        TraceArrowEntity traceArrowEntity = owner = arrow.m_19749_() == null ? arrow : arrow.m_19749_();
        if (arrow.m_36796_() > 0) {
            if (arrow.f_36701_ == null) {
                arrow.f_36701_ = new IntOpenHashSet(5);
            }
            if (arrow.f_36702_ == null) {
                arrow.f_36702_ = Lists.newArrayListWithCapacity((int)5);
            }
            if (arrow.f_36701_.size() >= arrow.m_36796_() + 1) {
                arrow.m_146870_();
                return;
            }
            arrow.f_36701_.add(entity.m_19879_());
        }
        if (arrow.m_36792_()) {
            long j = arrow.f_19796_.m_188503_(i / 2 + 2);
            i = (int)Math.min(j + (long)i, Integer.MAX_VALUE);
        }
        DamageSource damagesource = ToolUtils.getArrowDamageSource(level, (AbstractArrow)arrow, (Entity)owner, entity);
        boolean isEnderman = entity.m_6095_() == EntityType.f_20566_;
        int k = entity.m_20094_();
        if (arrow.m_6060_() && !isEnderman) {
            entity.m_20254_(5);
        }
        if (entity instanceof Player && (player = (Player)entity).m_6117_() && player.m_21211_().m_41720_() instanceof ShieldItem) {
            player.m_36335_().m_41524_(player.m_21211_().m_41720_(), 100);
            arrow.m_9236_().m_7605_((Entity)player, (byte)30);
            player.m_5810_();
        }
        if (entity.m_6469_(damagesource, (float)i)) {
            if (entity instanceof LivingEntity) {
                ServerPlayer serverPlayer;
                Vec3 vector3d;
                LivingEntity livingentity = (LivingEntity)entity;
                if (!arrow.m_9236_().f_46443_ && arrow.m_36796_() <= 0) {
                    livingentity.m_21317_(livingentity.m_21234_() + 1);
                }
                if (arrow.f_36699_ > 0 && (vector3d = arrow.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)arrow.f_36699_ * 0.6)).m_82556_() > 0.0) {
                    livingentity.m_5997_(vector3d.f_82479_, 0.1, vector3d.f_82481_);
                }
                if (!arrow.m_9236_().f_46443_ && owner instanceof LivingEntity) {
                    LivingEntity livingOwner = (LivingEntity)owner;
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity, (Entity)livingOwner);
                    EnchantmentHelper.m_44896_((LivingEntity)livingOwner, (Entity)livingentity);
                }
                arrow.m_7761_(livingentity);
                if (livingentity != owner && livingentity instanceof Player && owner instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)owner;
                    if (!arrow.m_20067_()) {
                        serverPlayer.f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
                    }
                }
                if (!entity.m_6084_() && arrow.f_36702_ != null) {
                    arrow.f_36702_.add(livingentity);
                }
                if (!arrow.m_9236_().f_46443_ && owner instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)owner;
                    if (arrow.f_36702_ != null && arrow.m_36795_()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverPlayer, (Collection)arrow.f_36702_);
                    } else if (!entity.m_6084_() && arrow.m_36795_()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverPlayer, List.of(entity));
                    }
                }
            }
            arrow.m_5496_(arrow.m_36784_(), 1.0f, 1.2f / (arrow.f_19796_.m_188501_() * 0.2f + 0.9f));
            if (arrow.m_36796_() <= 0) {
                arrow.m_20256_(entity.m_20184_().m_82490_(0.0));
                arrow.m_146884_(entity.m_20182_());
                arrow.seekNextTarget();
                arrow.m_9236_().m_6263_(null, arrow.m_20185_(), arrow.m_20186_(), arrow.m_20189_(), SoundEvents.f_11685_, SoundSource.PLAYERS, 4.0f, 1.0f);
            }
        } else {
            entity.m_7311_(k);
            arrow.m_20256_(arrow.m_20184_().m_82490_(0.0));
            arrow.m_146922_(arrow.m_146908_() + 180.0f);
            arrow.m_146884_(entity.m_20182_());
            arrow.f_19859_ += 180.0f;
            if (!arrow.m_9236_().f_46443_ && arrow.m_20184_().m_82556_() < 1.0E-7) {
                if (arrow.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    arrow.m_5552_(arrow.m_7941_(), 0.1f);
                }
                arrow.seekNextTarget();
                arrow.m_9236_().m_6263_(null, arrow.m_20185_(), arrow.m_20186_(), arrow.m_20189_(), SoundEvents.f_11685_, SoundSource.PLAYERS, 4.0f, 1.0f);
            }
        }
    }

    public static void sweepAttack(Level level, LivingEntity livingEntity, Entity victim) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            for (LivingEntity livingentity : level.m_45976_(LivingEntity.class, player.m_21120_(InteractionHand.MAIN_HAND).getSweepHitBox(player, victim))) {
                double entityReachSq = Mth.m_144952_((double)player.getEntityReach());
                if (player.m_7307_((Entity)livingentity) || livingentity instanceof ArmorStand && ((ArmorStand)livingentity).m_31677_() || !(player.m_20280_((Entity)livingentity) < entityReachSq)) continue;
                livingentity.m_147240_((double)0.6f, (double)Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)))));
            }
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, player.m_5720_(), 1.0f, 1.0f);
            double d0 = -Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180)));
            double d1 = Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)));
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, player.m_20185_() + d0, player.m_20227_(0.5), player.m_20189_() + d1, 0, d0, 0.0, d1, 0.0);
            }
        }
    }

    public static void aoeAttack(Player player, float range, float damage, boolean hurtAnimal, boolean lightOn) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        AABB aabb = player.m_20191_().m_82377_((double)range, (double)range, (double)range);
        List toAttack = player.m_9236_().m_45933_((Entity)player, aabb);
        DamageSource src = player.m_269291_().m_268998_(ModDamageTypes.INFINITY, (Entity)player, (Entity)player);
        toAttack.stream().filter(entity -> {
            boolean attack = (Boolean)ModConfig.isSwordAttackItemEntity.get();
            if (!attack) {
                return !(entity instanceof ItemEntity);
            }
            return true;
        }).filter(entity -> !entity.getClass().getSimpleName().equals("ImmortalItemEntity")).filter(entity -> {
            if (hurtAnimal) {
                return true;
            }
            return entity instanceof Enemy && !entity.m_6095_().m_204039_(ModTags.NEUTRAL_CREATURES);
        }).forEach(entity -> {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (livingEntity instanceof EnderDragon) {
                    EnderDragon dragon = (EnderDragon)livingEntity;
                    dragon.m_21153_(0.0f);
                } else if (livingEntity instanceof WitherBoss) {
                    WitherBoss wither = (WitherBoss)livingEntity;
                    wither.m_31510_(0);
                    wither.m_6469_(src, damage);
                } else {
                    livingEntity.m_6469_(src, damage);
                }
            } else if (entity instanceof ExperienceOrb || entity instanceof AbstractArrow) {
                entity.m_146870_();
            } else if (entity instanceof Entity) {
                entity.m_6469_(src, damage);
            }
            if (lightOn) {
                ServerPlayer serverPlayer;
                ToolUtils.trySummonLightning(player.m_9236_(), 1, entity.m_20183_(), player instanceof ServerPlayer ? (serverPlayer = (ServerPlayer)player) : null);
            }
        });
    }

    public static boolean trySummonLightning(Level level, int bolts, BlockPos hitPos, @Nullable ServerPlayer thrower) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            boolean hasAction = false;
            for (int i = 0; i < bolts; ++i) {
                LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_((Level)serverLevel);
                if (lightning != null) {
                    lightning.m_20219_(Vec3.m_82539_((Vec3i)hitPos));
                    lightning.m_20879_(thrower);
                    serverLevel.m_7967_((Entity)lightning);
                }
                hasAction = true;
            }
            return hasAction;
        }
        return false;
    }

    public static void rangeHarvest(ServerLevel serverLevel, Player player, ItemStack stack, BlockPos blockPos, int rang, int height) {
        BlockPos minPos = blockPos.m_7918_(-rang, -height, -rang);
        BlockPos maxPos = blockPos.m_7918_(rang, height, rang);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)minPos, (BlockPos)maxPos)) {
            CropBlock cropBlock;
            BlockState state = serverLevel.m_8055_(pos);
            Block block = state.m_60734_();
            HashMap<ItemStack, Integer> map = new HashMap<ItemStack, Integer>();
            if (block instanceof CropBlock && ((cropBlock = (CropBlock)block) instanceof BeetrootBlock ? (Integer)state.m_61143_((Property)BeetrootBlock.f_49657_) >= 3 : (Integer)state.m_61143_((Property)CropBlock.f_52244_) >= 7)) {
                ClustersUtils.putMapDrops((Level)serverLevel, pos, player, stack, map);
                serverLevel.m_7731_(pos, (BlockState)state.m_61124_((Property)(block instanceof BeetrootBlock ? BeetrootBlock.f_49657_ : CropBlock.f_52244_), (Comparable)Integer.valueOf(0)), 11);
            }
            if (block instanceof CocoaBlock && (Integer)state.m_61143_((Property)CocoaBlock.f_51736_) >= 2) {
                ClustersUtils.putMapDrops((Level)serverLevel, pos, player, stack, map);
                serverLevel.m_7731_(pos, (BlockState)state.m_61124_((Property)CocoaBlock.f_51736_, (Comparable)Integer.valueOf(0)), 11);
            }
            if (block instanceof StemGrownBlock) {
                ClustersUtils.putMapDrops((Level)serverLevel, pos, player, stack, map);
                serverLevel.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
            }
            if (block instanceof SweetBerryBushBlock && (Integer)state.m_61143_((Property)SweetBerryBushBlock.f_57244_) >= 3) {
                ClustersUtils.putMapDrops((Level)serverLevel, pos, player, stack, map);
                serverLevel.m_7731_(pos, (BlockState)state.m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(0)), 11);
            }
            if (block instanceof NetherWartBlock && (Integer)state.m_61143_((Property)NetherWartBlock.f_54967_) >= 3) {
                ClustersUtils.putMapDrops((Level)serverLevel, pos, player, stack, map);
                serverLevel.m_7731_(pos, (BlockState)state.m_61124_((Property)NetherWartBlock.f_54967_, (Comparable)Integer.valueOf(0)), 11);
            }
            ClustersUtils.spawnClusters((Level)serverLevel, player, map);
        }
    }

    public static void rangeBonemealable(ServerLevel serverLevel, BlockPos blockPos, int rang, int height, int cost) {
        BlockPos minPos = blockPos.m_7918_(-rang, -height, -rang);
        BlockPos maxPos = blockPos.m_7918_(rang, height, rang);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)minPos, (BlockPos)maxPos)) {
            BlockState state = serverLevel.m_8055_(pos);
            Block block = state.m_60734_();
            if (!(block instanceof BonemealableBlock)) continue;
            BonemealableBlock bonemealableBlock = (BonemealableBlock)block;
            if (block instanceof GrassBlock || !bonemealableBlock.m_7370_((LevelReader)serverLevel, pos, state, false) || !ForgeHooks.onCropsGrowPre((Level)serverLevel, (BlockPos)pos, (BlockState)state, (boolean)true)) continue;
            for (int i = 0; i < cost; ++i) {
                bonemealableBlock.m_214148_(serverLevel, serverLevel.f_46441_, pos, state);
                serverLevel.m_46796_(2005, pos, 0);
                ForgeHooks.onCropsGrowPost((Level)serverLevel, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public static boolean canHarvest(BlockPos pos, Level world) {
        if (!ToolUtils.isLogOrLeaves(world, pos)) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        if (state.m_61147_().stream().anyMatch(p -> p.equals((Object)RotatedPillarBlock.f_55923_))) {
            return ((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_)).equals((Object)Direction.Axis.Y);
        }
        return true;
    }

    public static void destroyTree(Player player, ServerLevel world, BlockPos pos, BlockState state) {
        List<BlockPos> connectedLogs = ToolUtils.getConnectedLogs((Level)world, pos);
        HashSet drops = Sets.newHashSet();
        for (BlockPos logPos : connectedLogs) {
            List blockDrops = Block.m_49869_((BlockState)world.m_8055_(logPos), (ServerLevel)world, (BlockPos)logPos, null);
            if (!blockDrops.isEmpty()) {
                drops.addAll(blockDrops);
            } else {
                ResourceLocation blockKey = BuiltInRegistries.f_256975_.m_7981_((Object)world.m_8055_(logPos).m_60734_());
                Item blockItem = (Item)BuiltInRegistries.f_257033_.m_7745_(blockKey);
                drops.add(new ItemStack((ItemLike)blockItem));
            }
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
            ToolUtils.destroy(world, player, logPos);
        }
        ClustersUtils.spawnClusters((Level)world, player, drops);
    }

    private static List<BlockPos> getConnectedLogs(Level world, BlockPos pos) {
        BlockPosList positions = new BlockPosList();
        ToolUtils.collectLogs(world, pos, positions);
        return positions;
    }

    private static void collectLogs(Level world, BlockPos pos, BlockPosList positions) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos p = pos.m_7918_(x, y, z);
                    if (!ToolUtils.isLogOrLeaves(world, p) || !positions.add(p)) continue;
                    posList.add(p);
                }
            }
        }
        for (BlockPos p : posList) {
            ToolUtils.collectLogs(world, p, positions);
        }
    }

    private static boolean isLogOrLeaves(Level world, BlockPos pos) {
        BlockState b = world.m_8055_(pos);
        return b.m_204336_(BlockTags.f_13106_) || b.m_204336_(BlockTags.f_13035_);
    }

    public static ItemStack getPlayerTotemItem(Player player) {
        return InventoryUtils.findItemInInv(player, stack -> stack.m_150930_((Item)ModItems.infinity_totem.get()), stack -> stack);
    }

    public static void melting(Block block, BlockState state, Level world, BlockPos pos, Player player, ItemStack tool, BlockEvent.BreakEvent event) {
        boolean flag;
        if (!block.canHarvestBlock(state, (BlockGetter)world, pos, player) || block instanceof CropBlock) {
            return;
        }
        List drops = Block.m_49869_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, null);
        int unLuck = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44987_, (ItemStack)tool);
        boolean bl = flag = unLuck > 0 && world.f_46441_.m_188500_() < (double)unLuck * 0.2;
        if (drops.isEmpty() || flag) {
            return;
        }
        drops.forEach(itemStack -> {
            ItemStack dropStack = ToolUtils.getMeltingItem(world, itemStack, tool);
            if (!dropStack.equals(itemStack)) {
                ToolUtils.meltingAchieve(world, player, pos, event);
                world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, dropStack));
            }
        });
    }

    public static ItemStack getMeltingItem(Level world, ItemStack itemStack, ItemStack tool) {
        ItemStack dropStack = world.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{itemStack}), world).map(smeltingRecipe -> smeltingRecipe.m_8043_(world.m_9598_())).filter(e -> !e.m_41619_()).map(e -> ItemHandlerHelper.copyStackWithSize((ItemStack)e, (int)(tool.m_41613_() * e.m_41613_()))).orElse(itemStack);
        int fortune = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44987_, (ItemStack)tool);
        if (fortune > 0) {
            RandomSource random = RandomSource.m_216327_();
            int count = 1;
            if (random.m_188500_() < 0.3 + (double)fortune * 0.1) {
                count += Mth.m_216271_((RandomSource)random, (int)0, (int)(fortune + 1));
            }
            if (random.m_188500_() < 0.1 + (double)fortune * 0.05) {
                count *= Mth.m_216271_((RandomSource)random, (int)1, (int)fortune);
            }
            dropStack.m_41764_(count);
        }
        return dropStack;
    }

    public static void meltingAchieve(Level world, Player player, BlockPos pos, BlockEvent.BreakEvent event) {
        if (!world.f_46443_) {
            ServerLevel serverWorld = (ServerLevel)world;
            for (int i = 0; i < 10; ++i) {
                serverWorld.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)pos.m_123341_() + world.f_46441_.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + world.f_46441_.m_188500_(), 1.0, 0.0, 0.0);
            }
        }
        world.m_5594_(player, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, 1.0f);
        world.m_46597_(event.getPos(), Blocks.f_50016_.m_49966_());
    }

    public static void shootBladeSlash(ItemStack stack, Player player) {
        Level world = player.m_9236_();
        BladeSlashEntity projectile = new BladeSlashEntity(world, (LivingEntity)player, EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44983_, (ItemStack)stack));
        world.m_7967_((Entity)projectile);
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, player.m_5720_(), 1.0f, 1.0f);
        player.m_6674_(player.m_7655_());
    }

    @Deprecated
    public static void speedBlockTick(BlockPos pos, ServerLevel level, int speed, int randomTicks) {
        BlockEntity blockEntity;
        int random_tick_rate = 4;
        BlockState targetState = level.m_8055_(pos);
        Block targetBlock = targetState.m_60734_();
        if (!(targetBlock instanceof EntityBlock)) {
            return;
        }
        EntityBlock entityBlock = (EntityBlock)targetBlock;
        if (level instanceof ServerLevel && targetBlock.m_6724_(targetState) && level.m_213780_().m_188503_(Mth.m_14045_((int)(4096 / (speed * random_tick_rate)), (int)1, (int)4096)) < randomTicks) {
            targetState.m_222972_(level, pos, level.m_213780_());
        }
        if ((blockEntity = level.m_7702_(pos)) != null) {
            BlockEntityTicker ticker = entityBlock.m_142354_((Level)level, targetState, blockEntity.m_58903_());
            if (blockEntity.m_58901_() || ticker == null) {
                return;
            }
            for (int i = 0; i < speed && !blockEntity.m_58901_(); ++i) {
                ticker.m_155252_((Level)level, pos, targetState, blockEntity);
            }
        }
    }

    public static void accelerateBlockEntity(ServerLevel level, BlockPos pos, BlockEntity be, int times) {
        BlockEntityType type;
        EntityBlock entityBlock;
        BlockEntityTicker ticker;
        if (be.m_58901_()) {
            return;
        }
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof EntityBlock && (ticker = (entityBlock = (EntityBlock)block).m_142354_((Level)level, state, type = be.m_58903_())) != null) {
            for (int i = 0; i < times; ++i) {
                ticker.m_155252_((Level)level, pos, state, be);
                if (be.m_58901_()) break;
            }
            be.m_6596_();
            level.m_7260_(pos, state, state, 3);
        }
    }

    private static class BlockPosList
    extends ArrayList<BlockPos> {
        private BlockPosList() {
        }

        @Override
        public boolean add(BlockPos pos) {
            if (!this.contains(pos)) {
                return super.add(pos);
            }
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return this.stream().anyMatch(pos1 -> pos1.equals(o));
        }
    }
}

