/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;

public class StoneOfTemperanceItem
extends Item {
    public static final String TAG_ACTIVE = "active";

    public StoneOfTemperanceItem(Item.Properties builder) {
        super(builder);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        this.toggleActive(stack, player, world);
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.m_5776_());
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> stacks, TooltipFlag flags) {
        if (ItemNBTHelper.getBoolean(stack, TAG_ACTIVE, false)) {
            stacks.add((Component)Component.m_237115_((String)"botaniamisc.active"));
        } else {
            stacks.add((Component)Component.m_237115_((String)"botaniamisc.inactive"));
        }
    }

    public static boolean hasTemperanceActive(Player player) {
        Inventory inv = player.m_150109_();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !stack.m_150930_(BotaniaItems.temperanceStone) || !ItemNBTHelper.getBoolean(stack, TAG_ACTIVE, false)) continue;
            return true;
        }
        return false;
    }

    public boolean m_142305_(ItemStack stack, ItemStack cursor, Slot slot, ClickAction click, Player player, SlotAccess access) {
        Level world = player.m_9236_();
        if (click == ClickAction.SECONDARY && slot.m_150651_(player) && cursor.m_41619_()) {
            this.toggleActive(stack, player, world);
            access.m_142104_(cursor);
            return true;
        }
        return false;
    }

    private void toggleActive(ItemStack stack, Player player, Level world) {
        ItemNBTHelper.setBoolean(stack, TAG_ACTIVE, !ItemNBTHelper.getBoolean(stack, TAG_ACTIVE, false));
        world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), BotaniaSounds.temperanceStoneConfigure, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }
}

