/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.StoneOfTemperanceItem;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;

public class RingOfChordataItem
extends BaubleItem {
    private static final int MANA_COST = 3;
    private static final int CONDUIT_POWER_AMPLIFIER = 0;
    private static final int DOLPHINS_GRACE_AMPLIFIER = 0;
    private static final int OUT_OF_MANA_DURATION = 60;

    public RingOfChordataItem(Item.Properties props) {
        super(props);
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity living) {
        Player player;
        block11: {
            block10: {
                if (!(living instanceof Player)) break block10;
                player = (Player)living;
                if (!player.m_9236_().f_46443_) break block11;
            }
            return;
        }
        if (player.m_20072_()) {
            ItemStack result = EquipmentHandler.findOrEmpty(BotaniaItems.waterRing, living);
            if (result != stack) {
                return;
            }
            boolean hasMana = ManaItemHandler.instance().requestManaExact(stack, player, 3, false);
            if (hasMana) {
                EntityHelper.addStaticEffect(living, MobEffects.f_19592_, 0);
                if (StoneOfTemperanceItem.hasTemperanceActive(player)) {
                    EntityHelper.removeStaticEffect(living, MobEffects.f_19593_, 0);
                } else {
                    EntityHelper.addStaticEffect(living, MobEffects.f_19593_, 0);
                }
                ManaItemHandler.instance().requestManaExact(stack, player, 3, true);
            } else {
                EntityHelper.convertStaticEffectToFinite(living, MobEffects.f_19592_, 0, 60);
                EntityHelper.convertStaticEffectToFinite(living, MobEffects.f_19593_, 0, 60);
            }
        } else {
            this.onUnequipped(stack, living);
        }
    }

    @Override
    public void onEquipped(ItemStack stack, LivingEntity living) {
        Player player;
        if (living instanceof Player && (player = (Player)living).m_20072_() && ManaItemHandler.instance().requestManaExact(stack, player, 3, false)) {
            EntityHelper.addStaticEffect(living, MobEffects.f_19592_, 0);
            if (!StoneOfTemperanceItem.hasTemperanceActive(player)) {
                EntityHelper.addStaticEffect(living, MobEffects.f_19593_, 0);
            }
        }
    }

    @Override
    public void onUnequipped(ItemStack stack, LivingEntity living) {
        EntityHelper.removeStaticEffect(living, MobEffects.f_19592_, 0);
        EntityHelper.removeStaticEffect(living, MobEffects.f_19593_, 0);
    }
}

