/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.api.conduit;

import com.enderio.api.UseOnly;
import com.enderio.api.conduit.ClientConduitData;
import com.enderio.api.conduit.ConduitMenuData;
import com.enderio.api.conduit.ConduitRegistries;
import com.enderio.api.conduit.ExtendedConduitData;
import com.enderio.api.conduit.NodeIdentifier;
import com.enderio.api.conduit.ticker.ConduitTicker;
import com.enderio.api.misc.RedstoneControl;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public interface ConduitType<T extends ExtendedConduitData<T>> {
    public ResourceLocation getTexture(T var1);

    public ResourceLocation getItemTexture();

    default public Item getConduitItem() {
        return (Item)ForgeRegistries.ITEMS.getValue(ConduitRegistries.getRegistry().getKey((Object)this));
    }

    default public boolean canBeInSameBlock(ConduitType<?> other) {
        return true;
    }

    default public boolean canBeReplacedBy(ConduitType<?> other) {
        return false;
    }

    public ConduitTicker getTicker();

    @UseOnly(value=LogicalSide.CLIENT)
    public ClientConduitData<T> getClientData();

    public ConduitMenuData getMenuData();

    public T createExtendedConduitData(Level var1, BlockPos var2);

    default public <K> Optional<LazyOptional<K>> proxyCapability(Capability<K> cap, T extendedConduitData, Level level, BlockPos pos, @Nullable Direction direction, @Nullable Optional<NodeIdentifier.IOState> state) {
        return Optional.empty();
    }

    default public ConduitConnectionData getDefaultConnection(Level level, BlockPos pos, Direction direction) {
        return new ConduitConnectionData(false, true, RedstoneControl.NEVER_ACTIVE);
    }

    public record ConduitConnectionData(boolean isInsert, boolean isExtract, RedstoneControl control) {
    }
}

