/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.api.conduit;

import com.enderio.api.conduit.ExtendedConduitData;
import com.enderio.api.misc.ColorControl;
import com.enderio.api.misc.RedstoneControl;
import dev.gigaherz.graph3.Graph;
import dev.gigaherz.graph3.GraphObject;
import dev.gigaherz.graph3.Mergeable;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class NodeIdentifier<T extends ExtendedConduitData<?>>
implements GraphObject<Mergeable.Dummy> {
    private final BlockPos pos;
    @Nullable
    private Graph<Mergeable.Dummy> graph = null;
    private final Map<Direction, IOState> ioStates = new EnumMap<Direction, IOState>(Direction.class);
    private final T extendedConduitData;

    @ApiStatus.Internal
    public NodeIdentifier(BlockPos pos, T extendedConduitData) {
        this.pos = pos;
        this.extendedConduitData = extendedConduitData;
    }

    @Nullable
    @ApiStatus.Internal
    public Graph<Mergeable.Dummy> getGraph() {
        return this.graph;
    }

    @ApiStatus.Internal
    public void setGraph(Graph<Mergeable.Dummy> graph) {
        this.graph = graph;
    }

    @ApiStatus.Internal
    public void pushState(Direction direction, @Nullable ColorControl insert, @Nullable ColorControl extract, RedstoneControl control, ColorControl redstoneChannel) {
        this.ioStates.put(direction, IOState.of(insert, extract, control, redstoneChannel));
    }

    public Optional<IOState> getIOState(Direction direction) {
        return Optional.ofNullable(this.ioStates.get(direction));
    }

    public T getExtendedConduitData() {
        return this.extendedConduitData;
    }

    @ApiStatus.Internal
    public void clearState(Direction direction) {
        this.ioStates.remove(direction);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public record IOState(Optional<ColorControl> insert, Optional<ColorControl> extract, RedstoneControl control, ColorControl redstoneChannel) {
        public boolean isInsert() {
            return this.insert().isPresent();
        }

        public boolean isExtract() {
            return this.extract().isPresent();
        }

        private static IOState of(@Nullable ColorControl in, @Nullable ColorControl extract, RedstoneControl control, ColorControl redstoneChannel) {
            return new IOState(Optional.ofNullable(in), Optional.ofNullable(extract), control, redstoneChannel);
        }
    }
}

