/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.api.conduit;

import com.enderio.api.UseOnly;
import com.enderio.api.conduit.ClientConduitData;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.ExtendedConduitData;
import com.enderio.api.misc.Vector2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;

public abstract class TieredConduit<T extends ExtendedConduitData<T>>
implements ConduitType<T> {
    private final ResourceLocation texture;
    private final ResourceLocation type;
    private final int tier;
    @UseOnly(value=LogicalSide.CLIENT)
    protected ClientConduitData<T> clientConduitData;

    public TieredConduit(ResourceLocation texture, ResourceLocation type, int tier, ResourceLocation iconTexture, Vector2i iconTexturePos) {
        this.texture = texture;
        this.type = type;
        this.tier = tier;
        this.clientConduitData = new ClientConduitData.Simple(iconTexture, iconTexturePos);
    }

    @Override
    public ResourceLocation getTexture(T data) {
        return this.texture;
    }

    @Override
    public ResourceLocation getItemTexture() {
        return this.texture;
    }

    @Override
    public boolean canBeReplacedBy(ConduitType<?> other) {
        if (!(other instanceof TieredConduit)) {
            return false;
        }
        TieredConduit tieredOther = (TieredConduit)other;
        if (this.type.equals((Object)tieredOther.getType())) {
            return this.tier < tieredOther.getTier();
        }
        return false;
    }

    @Override
    public boolean canBeInSameBlock(ConduitType<?> other) {
        if (!(other instanceof TieredConduit)) {
            return true;
        }
        TieredConduit tieredOther = (TieredConduit)other;
        return !this.type.equals((Object)tieredOther.getType());
    }

    public ResourceLocation getType() {
        return this.type;
    }

    public int getTier() {
        return this.tier;
    }

    @Override
    public ClientConduitData<T> getClientData() {
        return this.clientConduitData;
    }
}

