/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.api.conduit.ticker;

import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.ExtendedConduitData;
import com.enderio.api.conduit.ticker.IOAwareConduitTicker;
import com.enderio.api.misc.ColorControl;
import dev.gigaherz.graph3.Graph;
import dev.gigaherz.graph3.Mergeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import org.apache.commons.lang3.function.TriFunction;

public abstract class CapabilityAwareConduitTicker<T>
implements IOAwareConduitTicker {
    @Override
    public final void tickColoredGraph(ConduitType<?> type, List<IOAwareConduitTicker.Connection> inserts, List<IOAwareConduitTicker.Connection> extracts, ColorControl color, ServerLevel level, Graph<Mergeable.Dummy> graph, TriFunction<ServerLevel, BlockPos, ColorControl, Boolean> isRedstoneActive) {
        ArrayList<CapabilityConnection> insertCaps = new ArrayList<CapabilityConnection>();
        for (IOAwareConduitTicker.Connection insert : inserts) {
            Optional.ofNullable(level.m_7702_(insert.move())).flatMap(b -> b.getCapability(this.getCapability(), insert.dir().m_122424_()).resolve()).ifPresent(cap -> insertCaps.add(new CapabilityConnection(cap, insert.data(), insert.dir())));
        }
        if (!insertCaps.isEmpty()) {
            ArrayList<CapabilityConnection> extractCaps = new ArrayList<CapabilityConnection>();
            for (IOAwareConduitTicker.Connection extract : extracts) {
                Optional.ofNullable(level.m_7702_(extract.move())).flatMap(b -> b.getCapability(this.getCapability(), extract.dir().m_122424_()).resolve()).ifPresent(cap -> extractCaps.add(new CapabilityConnection(cap, extract.data(), extract.dir())));
            }
            if (!extractCaps.isEmpty()) {
                this.tickCapabilityGraph(type, insertCaps, extractCaps, level, graph, isRedstoneActive);
            }
        }
    }

    @Override
    public boolean canConnectTo(Level level, BlockPos conduitPos, Direction direction) {
        return Optional.ofNullable(level.m_7702_(conduitPos.m_121945_(direction))).flatMap(be -> be.getCapability(this.getCapability(), direction.m_122424_()).resolve()).isPresent();
    }

    protected abstract void tickCapabilityGraph(ConduitType<?> var1, List<CapabilityConnection> var2, List<CapabilityConnection> var3, ServerLevel var4, Graph<Mergeable.Dummy> var5, TriFunction<ServerLevel, BlockPos, ColorControl, Boolean> var6);

    protected abstract Capability<T> getCapability();

    public class CapabilityConnection {
        public final T cap;
        public final ExtendedConduitData<?> data;
        public final Direction direction;

        private CapabilityConnection(T cap, ExtendedConduitData<?> data, Direction direction) {
            this.cap = cap;
            this.data = data;
            this.direction = direction;
        }
    }
}

