/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.api.conduit.ticker;

import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.ExtendedConduitData;
import com.enderio.api.conduit.NodeIdentifier;
import com.enderio.api.conduit.ticker.LoadedAwareConduitTicker;
import com.enderio.api.misc.ColorControl;
import com.enderio.api.misc.RedstoneControl;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import dev.gigaherz.graph3.Graph;
import dev.gigaherz.graph3.GraphObject;
import dev.gigaherz.graph3.Mergeable;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import org.apache.commons.lang3.function.TriFunction;

public interface IOAwareConduitTicker
extends LoadedAwareConduitTicker {
    @Override
    default public void tickGraph(ConduitType<?> type, List<NodeIdentifier<?>> loadedNodes, ServerLevel level, Graph<Mergeable.Dummy> graph, TriFunction<ServerLevel, BlockPos, ColorControl, Boolean> isRedstoneActive) {
        ArrayListMultimap extracts = ArrayListMultimap.create();
        ArrayListMultimap inserts = ArrayListMultimap.create();
        for (GraphObject graphObject : loadedNodes) {
            if (!(graphObject instanceof NodeIdentifier)) continue;
            NodeIdentifier nodeIdentifier = (NodeIdentifier)graphObject;
            for (Direction direction : Direction.values()) {
                nodeIdentifier.getIOState(direction).ifPresent(arg_0 -> this.lambda$tickGraph$3(type, level, nodeIdentifier, isRedstoneActive, (ListMultimap)extracts, direction, (ListMultimap)inserts, arg_0));
            }
        }
        for (ColorControl color : ColorControl.values()) {
            List extractList = extracts.get((Object)color);
            List insertList = inserts.get((Object)color);
            if (extractList.isEmpty() || insertList.isEmpty()) continue;
            this.tickColoredGraph(type, insertList, extractList, color, level, graph, isRedstoneActive);
        }
    }

    public void tickColoredGraph(ConduitType<?> var1, List<Connection> var2, List<Connection> var3, ColorControl var4, ServerLevel var5, Graph<Mergeable.Dummy> var6, TriFunction<ServerLevel, BlockPos, ColorControl, Boolean> var7);

    default public boolean isRedstoneMode(ConduitType<?> type, ServerLevel level, BlockPos pos, NodeIdentifier.IOState state, TriFunction<ServerLevel, BlockPos, ColorControl, Boolean> isRedstoneActive) {
        if (!type.getMenuData().showRedstoneExtract()) {
            return true;
        }
        if (state.control() == RedstoneControl.ALWAYS_ACTIVE) {
            return true;
        }
        if (state.control() == RedstoneControl.NEVER_ACTIVE) {
            return false;
        }
        boolean hasRedstone = false;
        for (Direction direction : Direction.values()) {
            if (level.m_277185_(pos.m_121945_(direction), direction) <= 0) continue;
            hasRedstone = true;
            break;
        }
        return state.control().isActive(hasRedstone || (Boolean)isRedstoneActive.apply((Object)level, (Object)pos, (Object)state.redstoneChannel()) != false);
    }

    private /* synthetic */ void lambda$tickGraph$3(ConduitType type, ServerLevel level, NodeIdentifier nodeIdentifier, TriFunction isRedstoneActive, ListMultimap extracts, Direction direction, ListMultimap inserts, NodeIdentifier.IOState ioState) {
        ioState.extract().filter(extract -> this.isRedstoneMode(type, level, nodeIdentifier.getPos(), ioState, (TriFunction<ServerLevel, BlockPos, ColorControl, Boolean>)isRedstoneActive)).ifPresent(color -> extracts.get(color).add(new Connection(nodeIdentifier.getPos(), direction, (ExtendedConduitData<?>)nodeIdentifier.getExtendedConduitData())));
        ioState.insert().ifPresent(color -> inserts.get(color).add(new Connection(nodeIdentifier.getPos(), direction, (ExtendedConduitData<?>)nodeIdentifier.getExtendedConduitData())));
    }

    public record Connection(BlockPos pos, Direction dir, ExtendedConduitData<?> data) {
        public BlockPos move() {
            return this.pos.m_121945_(this.dir);
        }
    }
}

