/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.api.io;

import com.enderio.api.UseOnly;
import com.enderio.api.capability.IEnderCapabilityProvider;
import com.enderio.api.capability.SideConfig;
import com.enderio.api.io.IOMode;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.LogicalSide;

public interface IIOConfig
extends INBTSerializable<CompoundTag>,
IEnderCapabilityProvider<SideConfig> {
    public IOMode getIOMode(Direction var1);

    public void setIOMode(Direction var1, IOMode var2);

    public boolean supportsIOMode(Direction var1, IOMode var2);

    default public IOMode getNextIOMode(Direction side) {
        return this.getNextIOMode(side, this.getIOMode(side));
    }

    default public IOMode getNextIOMode(Direction side, IOMode currentMode) {
        int curOrd = currentMode.ordinal();
        int nextOrd = (curOrd + 1) % IOMode.values().length;
        while (nextOrd != curOrd) {
            IOMode next = IOMode.values()[nextOrd];
            if (this.supportsIOMode(side, next)) {
                return next;
            }
            nextOrd = (nextOrd + 1) % IOMode.values().length;
        }
        return currentMode;
    }

    default public void cycleIOMode(Direction side) {
        this.setIOMode(side, this.getNextIOMode(side));
    }

    @UseOnly(value=LogicalSide.CLIENT)
    public boolean renderOverlay();
}

