/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.api.misc;

import com.enderio.api.misc.ApiLang;
import com.enderio.api.misc.Icon;
import com.enderio.api.misc.Vector2i;
import java.util.Locale;
import java.util.function.UnaryOperator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;

public enum RedstoneControl implements Icon,
StringRepresentable
{
    ALWAYS_ACTIVE(bool -> true, ApiLang.REDSTONE_ALWAYS_ACTIVE),
    ACTIVE_WITH_SIGNAL(bool -> bool, ApiLang.REDSTONE_ACTIVE_WITH_SIGNAL),
    ACTIVE_WITHOUT_SIGNAL(bool -> bool == false, ApiLang.REDSTONE_ACTIVE_WITHOUT_SIGNAL),
    NEVER_ACTIVE(bool -> false, ApiLang.REDSTONE_NEVER_ACTIVE);

    public static final StringRepresentable.EnumCodec<RedstoneControl> CODEC;
    private static final ResourceLocation TEXTURE;
    private static final Vector2i SIZE;
    private final UnaryOperator<Boolean> isActive;
    private final Vector2i pos;
    private final Component tooltip;

    private RedstoneControl(UnaryOperator<Boolean> isActive, Component tooltip) {
        this.isActive = isActive;
        this.pos = new Vector2i(16 * this.ordinal(), 0);
        this.tooltip = tooltip;
    }

    public boolean isActive(boolean hasRedstone) {
        return (Boolean)this.isActive.apply(hasRedstone);
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return TEXTURE;
    }

    @Override
    public Vector2i getIconSize() {
        return SIZE;
    }

    @Override
    public Vector2i getTexturePosition() {
        return this.pos;
    }

    @Override
    public Vector2i getTextureSize() {
        return new Vector2i(64, 16);
    }

    @Override
    public Component getTooltip() {
        return this.tooltip;
    }

    public String m_7912_() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    static {
        CODEC = StringRepresentable.m_216439_(RedstoneControl::values);
        TEXTURE = new ResourceLocation("enderio", "textures/gui/icons/redstone_control.png");
        SIZE = new Vector2i(16, 16);
    }
}

