/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.armory.common.item.darksteel;

import com.enderio.api.capability.IDarkSteelUpgrade;
import com.enderio.armory.common.item.darksteel.upgrades.DarkSteelUpgradeRegistry;
import com.enderio.armory.common.lang.ArmoryLang;
import com.enderio.core.client.item.AdvancedTooltipProvider;
import com.enderio.core.common.item.ITabVariants;
import com.enderio.core.common.util.TooltipUtil;
import com.tterrag.registrate.util.CreativeModeTabModifier;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.Nullable;

public class DarkSteelUpgradeItem
extends Item
implements AdvancedTooltipProvider,
ITabVariants {
    private final ForgeConfigSpec.ConfigValue<Integer> levelsRequired;
    private final Supplier<? extends IDarkSteelUpgrade> upgrade;

    public DarkSteelUpgradeItem(Item.Properties pProperties, ForgeConfigSpec.ConfigValue<Integer> levelsRequired, Supplier<? extends IDarkSteelUpgrade> upgrade) {
        super(pProperties.m_41487_(1));
        this.levelsRequired = levelsRequired;
        this.upgrade = upgrade;
    }

    public boolean m_5812_(ItemStack pStack) {
        return DarkSteelUpgradeRegistry.instance().hasUpgrade(pStack);
    }

    @Override
    public void addAllVariants(CreativeModeTabModifier modifier) {
        modifier.m_246326_((ItemLike)this);
        ItemStack is = new ItemStack((ItemLike)this);
        DarkSteelUpgradeRegistry.instance().writeUpgradeToItemStack(is, this.upgrade.get());
        modifier.m_246342_(is);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        if (!DarkSteelUpgradeRegistry.instance().hasUpgrade(stack)) {
            if (pPlayer.f_36078_ >= (Integer)this.levelsRequired.get() || pPlayer.m_7500_()) {
                if (!pPlayer.m_7500_()) {
                    pPlayer.m_6749_(-((Integer)this.levelsRequired.get()).intValue());
                }
                DarkSteelUpgradeRegistry.instance().writeUpgradeToItemStack(stack, this.upgrade.get());
                pLevel.m_5594_(pPlayer, pPlayer.m_20097_(), SoundEvents.f_11887_, SoundSource.BLOCKS, 1.0f, new Random().nextFloat() * 0.1f + 0.9f);
            } else if (pLevel.f_46443_) {
                pPlayer.m_213846_(ArmoryLang.DS_UPGRADE_ITEM_NO_XP);
            }
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    @Override
    public void addDetailedTooltips(ItemStack itemStack, @Nullable Player player, List<Component> tooltips) {
        Collection<Component> desc = this.upgrade.get().getDescription();
        for (Component component : desc) {
            tooltips.add((Component)component.m_6881_().m_130940_(ChatFormatting.GRAY));
        }
        if (!DarkSteelUpgradeRegistry.instance().hasUpgrade(itemStack)) {
            tooltips.add((Component)TooltipUtil.withArgs(ArmoryLang.DS_UPGRADE_XP_COST, this.levelsRequired.get()).m_130940_(ChatFormatting.DARK_PURPLE));
            tooltips.add((Component)ArmoryLang.DS_UPGRADE_ACTIVATE.m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
    }
}

