/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.client.tooltip;

import com.enderio.api.capacitor.CapacitorModifier;
import com.enderio.api.grindingball.GrindingBallData;
import com.enderio.base.common.capacitor.CapacitorUtil;
import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.base.common.lang.EIOLang;
import com.enderio.base.common.util.GrindingBallManager;
import com.enderio.core.client.item.AdvancedTooltipProvider;
import com.enderio.core.common.util.EntityUtil;
import com.enderio.core.common.util.TooltipUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TooltipHandler {
    private static final Component DETAIL_TOOLTIP = EIOLang.SHOW_DETAIL_TOOLTIP.m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});

    @SubscribeEvent
    public static void addAdvancedTooltips(ItemTooltipEvent evt) {
        ItemStack forItem = evt.getItemStack();
        boolean advanced = Screen.m_96638_();
        TooltipHandler.addCapacitorTooltips(forItem, evt.getToolTip(), advanced);
        TooltipHandler.addGrindingBallTooltips(forItem, evt.getToolTip(), advanced);
        TooltipHandler.addEntityDataTooltips(forItem, evt.getToolTip(), advanced);
        TooltipHandler.getAdvancedProvider(forItem.m_41720_()).ifPresent(provider -> TooltipHandler.addAdvancedTooltips(provider, forItem, evt.getEntity(), evt.getToolTip(), advanced));
    }

    private static void addCapacitorTooltips(ItemStack itemStack, List<Component> components, boolean showAdvanced) {
        if (CapacitorUtil.isCapacitor(itemStack)) {
            CapacitorUtil.getCapacitorData(itemStack).ifPresent(data -> {
                NumberFormat fmt = NumberFormat.getInstance(Locale.ENGLISH);
                components.add(TooltipUtil.styledWithArgs(EIOLang.CAPACITOR_TOOLTIP_BASE, fmt.format(data.base())));
                for (Map.Entry<CapacitorModifier, Float> modifier : data.modifiers().entrySet()) {
                    components.add(TooltipUtil.styledWithArgs(new ResourceLocation("tooltip", modifier.getKey().modifierId.m_214298_()), fmt.format(modifier.getValue())));
                }
            });
        }
    }

    private static void addGrindingBallTooltips(ItemStack itemStack, List<Component> components, boolean showAdvanced) {
        if (GrindingBallManager.isGrindingBall(itemStack)) {
            if (showAdvanced) {
                GrindingBallData data = GrindingBallManager.getData(itemStack);
                components.add(TooltipUtil.styledWithArgs(EIOLang.GRINDINGBALL_MAIN_OUTPUT, (int)(data.getOutputMultiplier() * 100.0f)));
                components.add(TooltipUtil.styledWithArgs(EIOLang.GRINDINGBALL_BONUS_OUTPUT, (int)(data.getBonusMultiplier() * 100.0f)));
                components.add(TooltipUtil.styledWithArgs(EIOLang.GRINDINGBALL_POWER_USE, (int)(data.getPowerUse() * 100.0f)));
            } else {
                TooltipHandler.addShowDetailsTooltip(components);
            }
        }
    }

    private static void addEntityDataTooltips(ItemStack itemStack, List<Component> components, boolean showAdvanced) {
        itemStack.getCapability(EIOCapabilities.ENTITY_STORAGE).ifPresent(storedEntityData -> {
            if (storedEntityData.hasStoredEntity()) {
                components.add(TooltipUtil.style(Component.m_237115_((String)EntityUtil.getEntityDescriptionId(storedEntityData.getStoredEntityData().getEntityType().get()))));
            } else {
                components.add(TooltipUtil.style(EIOLang.TOOLTIP_NO_SOULBOUND));
            }
        });
    }

    private static Optional<AdvancedTooltipProvider> getAdvancedProvider(Item item) {
        BlockItem blockItem;
        Block block;
        if (item instanceof AdvancedTooltipProvider) {
            AdvancedTooltipProvider provider = (AdvancedTooltipProvider)item;
            return Optional.of(provider);
        }
        if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).m_40614_()) instanceof AdvancedTooltipProvider) {
            AdvancedTooltipProvider provider = (AdvancedTooltipProvider)block;
            return Optional.of(provider);
        }
        return Optional.empty();
    }

    private static void addAdvancedTooltips(AdvancedTooltipProvider tooltipProvider, ItemStack itemstack, @Nullable Player player, List<Component> components, boolean showAdvanced) {
        tooltipProvider.addCommonTooltips(itemstack, player, components);
        if (showAdvanced) {
            tooltipProvider.addDetailedTooltips(itemstack, player, components);
        } else {
            tooltipProvider.addBasicTooltips(itemstack, player, components);
            if (TooltipHandler.hasDetailedTooltip(tooltipProvider, itemstack, player)) {
                TooltipHandler.addShowDetailsTooltip(components);
            }
        }
    }

    private static void addShowDetailsTooltip(List<Component> components) {
        if (!components.contains(DETAIL_TOOLTIP)) {
            components.add(DETAIL_TOOLTIP);
        }
    }

    private static boolean hasDetailedTooltip(AdvancedTooltipProvider tooltipProvider, ItemStack stack, @Nullable Player player) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        tooltipProvider.addDetailedTooltips(stack, player, tooltips);
        return !tooltips.isEmpty();
    }
}

