/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.handler;

import com.enderio.api.integration.IntegrationManager;
import com.enderio.api.travel.ITravelTarget;
import com.enderio.base.common.config.BaseConfig;
import com.enderio.base.common.init.EIOItems;
import com.enderio.base.common.network.RequestTravelPacket;
import com.enderio.base.common.travel.TravelSavedData;
import com.enderio.core.common.network.CoreNetwork;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public class TravelHandler {
    public static final int MIN_TELEPORTATION_DISTANCE_SQUARED = 25;

    public static boolean canTeleport(Player player) {
        return TravelHandler.canItemTeleport(player) || TravelHandler.canBlockTeleport(player);
    }

    public static boolean canItemTeleport(Player player) {
        return TravelHandler.canItemTeleport(player, InteractionHand.MAIN_HAND) || TravelHandler.canItemTeleport(player, InteractionHand.OFF_HAND);
    }

    private static boolean canItemTeleport(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        return stack.m_41720_() == EIOItems.TRAVEL_STAFF.get();
    }

    public static boolean canBlockTeleport(Player player) {
        return IntegrationManager.anyMatch(integration -> integration.canBlockTeleport(player));
    }

    public static boolean shortTeleport(Level level, Player player) {
        Optional<Vec3> pos = TravelHandler.teleportPosition(level, player);
        if (pos.isPresent()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Optional<Vec3> eventPos = TravelHandler.teleportEvent(player, pos.get());
                if (eventPos.isPresent()) {
                    player.m_6021_(eventPos.get().m_7096_(), eventPos.get().m_7098_(), eventPos.get().m_7094_());
                    serverPlayer.f_8906_.m_9953_();
                    player.f_19789_ = 0.0f;
                    player.m_6330_(SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    player.m_6330_(SoundEvents.f_11797_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean blockTeleport(Level level, Player player) {
        return TravelHandler.blockTeleport(level, player, false);
    }

    public static boolean blockTeleport(Level level, Player player, boolean sendToServer) {
        return TravelHandler.getAnchorTarget(player).filter(iTravelTarget -> TravelHandler.blockTeleportTo(level, player, iTravelTarget, sendToServer)).isPresent();
    }

    public static boolean blockElevatorTeleport(Level level, Player player, Direction direction, boolean sendToServer) {
        if (direction.m_122430_() != 0) {
            return TravelHandler.getElevatorAnchorTarget(player, direction).filter(iTravelTarget -> TravelHandler.blockTeleportTo(level, player, iTravelTarget, sendToServer)).isPresent();
        }
        return false;
    }

    public static boolean blockTeleportTo(Level level, Player player, ITravelTarget target, boolean sendToServer) {
        Optional<Double> height = TravelHandler.isTeleportPositionClear((BlockGetter)level, target.getPos());
        if (height.isEmpty()) {
            return false;
        }
        BlockPos blockPos = target.getPos();
        Vec3 teleportPosition = new Vec3((double)((float)blockPos.m_123341_() + 0.5f), (double)blockPos.m_123342_() + height.get() + 1.0, (double)((float)blockPos.m_123343_() + 0.5f));
        if ((teleportPosition = (Vec3)TravelHandler.teleportEvent(player, teleportPosition).orElse(null)) != null) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                player.m_6021_(teleportPosition.m_7096_(), teleportPosition.m_7098_(), teleportPosition.m_7094_());
                serverPlayer.f_8906_.m_9953_();
                player.m_6330_(SoundEvents.f_11852_, SoundSource.PLAYERS, 0.75f, 1.0f);
            } else if (sendToServer) {
                CoreNetwork.sendToServer(new RequestTravelPacket(target.getPos()));
            }
            player.m_183634_();
            return true;
        }
        return false;
    }

    public static Optional<Vec3> teleportPosition(Level level, Player player) {
        BlockPos failPosition;
        boolean aimingUp;
        Vec3 traverseFrom;
        BlockPos newTarget;
        int range;
        Vec3 lookVec;
        Vec3 toPos;
        @Nullable BlockPos target = null;
        double floorHeight = 0.0;
        Vec3 playerPos = player.m_146892_();
        ClipContext clipCtx = new ClipContext(playerPos, toPos = playerPos.m_82549_((lookVec = player.m_20154_().m_82541_()).m_82490_((double)(range = ((Integer)BaseConfig.COMMON.ITEMS.TRAVELLING_BLINK_RANGE.get()).intValue()))), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, null);
        BlockHitResult bhr = level.m_45547_(clipCtx);
        if (bhr.m_6662_() == HitResult.Type.MISS) {
            target = bhr.m_82425_();
        } else if (bhr.m_6662_() == HitResult.Type.BLOCK) {
            Direction dir = bhr.m_82434_();
            if (dir == Direction.UP) {
                target = bhr.m_82425_();
            } else if (dir == Direction.DOWN) {
                target = bhr.m_82425_().m_6625_((int)Math.ceil(player.m_20206_()));
            } else {
                target = bhr.m_82425_().m_7918_(dir.m_122429_(), 0, dir.m_122431_());
                if (level.m_8055_(target).m_60812_((BlockGetter)level, target).m_83281_()) {
                    target = target.m_7495_();
                }
            }
        }
        if (playerPos.m_82557_(bhr.m_82450_()) < 9.0 && (newTarget = (BlockPos)BlockGetter.m_151361_((Vec3)(traverseFrom = bhr.m_82450_().m_82549_(lookVec.m_82490_(0.01))), (Vec3)toPos, (Object)clipCtx, (arg_0, arg_1) -> TravelHandler.lambda$teleportPosition$3(aimingUp = lookVec.f_82480_ > 0.5, level, arg_0, arg_1), arg_0 -> TravelHandler.lambda$teleportPosition$4(failPosition = new BlockPos(0, Integer.MAX_VALUE, 0), arg_0))) != failPosition) {
            target = newTarget.m_7949_();
        }
        if (target != null) {
            Optional<Double> ground = TravelHandler.isTeleportPositionClear((BlockGetter)level, target.m_7495_());
            if (ground.isPresent()) {
                floorHeight = ground.get();
            } else {
                target = null;
            }
        }
        if (target == null || player.m_20183_().m_123333_((Vec3i)target) < 2) {
            return Optional.empty();
        }
        return Optional.of(Vec3.m_82539_((Vec3i)target).m_82520_(0.0, floorHeight, 0.0));
    }

    @Nullable
    private static BlockPos traversalCheck(Level level, BlockPos traversePos) {
        BlockState blockState = level.m_8055_(traversePos);
        VoxelShape collision = blockState.m_60812_((BlockGetter)level, traversePos);
        if (collision.m_83281_() && TravelHandler.isTeleportPositionClear((BlockGetter)level, traversePos.m_7495_()).isPresent()) {
            return traversePos;
        }
        return null;
    }

    public static Optional<ITravelTarget> getAnchorTarget(Player player) {
        Vec3 positionVec = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
        return TravelSavedData.getTravelData(player.m_9236_()).getTravelTargetsInItemRange(player.m_20183_()).filter(target -> target.canTravelTo()).filter(target -> target.getPos().m_203193_((Position)player.m_20182_()) > 25.0).filter(target -> Math.abs(TravelHandler.getAngleRadians(positionVec, target.getPos(), player.m_146908_(), player.m_146909_())) <= Math.toRadians(15.0)).filter(target -> TravelHandler.isTeleportPositionClear((BlockGetter)player.m_9236_(), target.getPos()).isPresent()).min(Comparator.comparingDouble(target -> Math.abs(TravelHandler.getAngleRadians(positionVec, target.getPos(), player.m_146908_(), player.m_146909_()))));
    }

    public static Optional<ITravelTarget> getElevatorAnchorTarget(Player player, Direction direction) {
        int lowerY;
        int upperY;
        int anchorRange = (Integer)BaseConfig.COMMON.ITEMS.TRAVELLING_BLOCK_TO_BLOCK_RANGE.get();
        BlockPos anchorPos = player.m_20183_().m_7495_();
        int anchorX = anchorPos.m_123341_();
        int anchorY = anchorPos.m_123342_();
        int anchorZ = anchorPos.m_123343_();
        if (direction == Direction.UP) {
            upperY = anchorY + anchorRange + 1;
            lowerY = anchorY + 1;
        } else {
            upperY = anchorY - 1;
            lowerY = anchorY - anchorRange - 1;
        }
        return TravelSavedData.getTravelData(player.m_9236_()).getTravelTargets().stream().filter(target -> target.getPos().m_123341_() == anchorX && target.getPos().m_123343_() == anchorZ).filter(target -> target.getPos().m_123342_() > lowerY && target.getPos().m_123342_() < upperY).filter(target -> target.canTravelTo()).filter(target -> TravelHandler.isTeleportPositionClear((BlockGetter)player.m_9236_(), target.getPos()).isPresent()).min(Comparator.comparingDouble(target -> Math.abs(target.getPos().m_123342_() - anchorY)));
    }

    private static double getAngleRadians(Vec3 positionVec, BlockPos anchor, float yRot, float xRot) {
        Vec3 blockVec = new Vec3((double)anchor.m_123341_() + 0.5 - positionVec.f_82479_, (double)anchor.m_123342_() + 1.0 - positionVec.f_82480_, (double)anchor.m_123343_() + 0.5 - positionVec.f_82481_).m_82541_();
        Vec3 lookVec = Vec3.m_82498_((float)xRot, (float)yRot).m_82541_();
        return Math.acos(lookVec.m_82526_(blockVec));
    }

    public static Optional<Double> isTeleportPositionClear(BlockGetter level, BlockPos target) {
        if (level.m_151570_(target)) {
            return Optional.empty();
        }
        BlockPos above = target.m_7494_();
        double height = level.m_8055_(above).m_60812_(level, above).m_83297_(Direction.Axis.Y);
        if (height <= 0.2) {
            return Optional.of(Math.max(height, 0.0));
        }
        boolean noCollisionAbove = level.m_8055_(above = above.m_7494_()).m_60812_(level, above).m_83281_();
        if (noCollisionAbove) {
            return Optional.of(Math.max(height, 0.0));
        }
        return Optional.empty();
    }

    private static Optional<Vec3> teleportEvent(Player player, Vec3 target) {
        EntityTeleportEvent event = new EntityTeleportEvent((Entity)player, target.m_7096_(), target.m_7098_(), target.m_7094_());
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return Optional.empty();
        }
        return Optional.of(new Vec3(event.getTargetX(), event.getTargetY(), event.getTargetZ()));
    }

    private static /* synthetic */ BlockPos lambda$teleportPosition$4(BlockPos failPosition, ClipContext failCtx) {
        return failPosition;
    }

    private static /* synthetic */ BlockPos lambda$teleportPosition$3(boolean aimingUp, Level level, ClipContext traverseCtx, BlockPos traversePos) {
        BlockPos checkBelow;
        if (!aimingUp && (checkBelow = TravelHandler.traversalCheck(level, traversePos.m_7495_())) != null) {
            return checkBelow;
        }
        return TravelHandler.traversalCheck(level, traversePos);
    }
}

