/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.item.tool;

import com.enderio.api.capability.IMultiCapabilityItem;
import com.enderio.api.capability.MultiCapabilityProvider;
import com.enderio.base.common.capability.EnergyStorageItemStack;
import com.enderio.base.common.capability.Toggled;
import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.base.common.lang.EIOLang;
import com.enderio.core.client.item.AdvancedTooltipProvider;
import com.enderio.core.common.item.ITabVariants;
import com.enderio.core.common.util.EnergyUtil;
import com.enderio.core.common.util.TooltipUtil;
import com.tterrag.registrate.util.CreativeModeTabModifier;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public abstract class PoweredToggledItem
extends Item
implements IMultiCapabilityItem,
AdvancedTooltipProvider,
ITabVariants {
    public PoweredToggledItem(Item.Properties pProperties) {
        super(pProperties.m_41487_(1));
    }

    protected abstract void onTickWhenActive(Player var1, ItemStack var2, Level var3, Entity var4, int var5, boolean var6);

    protected abstract int getEnergyUse();

    protected abstract int getMaxEnergy();

    protected void enable(ItemStack stack) {
        Toggled.setEnabled(stack, true);
    }

    protected void disable(ItemStack stack) {
        Toggled.setEnabled(stack, false);
    }

    protected boolean hasCharge(ItemStack pStack) {
        return EnergyUtil.extractEnergy(pStack, this.getEnergyUse(), true) > 0;
    }

    protected void consumeCharge(ItemStack pStack) {
        EnergyUtil.extractEnergy(pStack, this.getEnergyUse(), false);
    }

    protected void setFullCharge(ItemStack pStack) {
        EnergyUtil.setFull(pStack);
    }

    public boolean m_5812_(ItemStack pStack) {
        return Toggled.isEnabled(pStack);
    }

    public static ItemStack getCharged(PoweredToggledItem item) {
        ItemStack is = new ItemStack((ItemLike)item);
        item.setFullCharge(is);
        return is;
    }

    @Override
    public void addAllVariants(CreativeModeTabModifier modifier) {
        modifier.m_246326_((ItemLike)this);
        modifier.m_246342_(PoweredToggledItem.getCharged(this));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pPlayer.m_6047_()) {
            ItemStack stack = pPlayer.m_21120_(pUsedHand);
            if (Toggled.isEnabled(stack)) {
                this.disable(stack);
            } else if (this.hasCharge(stack)) {
                this.enable(stack);
            }
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            if (Toggled.isEnabled(pStack)) {
                if (this.hasCharge(pStack)) {
                    this.consumeCharge(pStack);
                    this.onTickWhenActive(player, pStack, pLevel, pEntity, pSlotId, pIsSelected);
                } else {
                    this.disable(pStack);
                }
            }
        }
    }

    @Override
    @Nullable
    public MultiCapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt, MultiCapabilityProvider provider) {
        provider.add(EIOCapabilities.TOGGLED, LazyOptional.of(() -> new Toggled(stack)));
        provider.add(ForgeCapabilities.ENERGY, LazyOptional.of(() -> new EnergyStorageItemStack(stack, this.getMaxEnergy())));
        return provider;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged) {
            return super.shouldCauseReequipAnimation(oldStack, newStack, true);
        }
        return oldStack.m_41720_() != newStack.m_41720_() || Toggled.isEnabled(oldStack) != Toggled.isEnabled(newStack);
    }

    public boolean m_142522_(ItemStack pStack) {
        return true;
    }

    public int m_142158_(ItemStack pStack) {
        return pStack.getCapability(ForgeCapabilities.ENERGY).map(energyStorage -> Math.round((float)energyStorage.getEnergyStored() * 13.0f / (float)energyStorage.getMaxEnergyStored())).orElse(0);
    }

    public int m_142159_(ItemStack pStack) {
        return 11626724;
    }

    @Override
    public void addCommonTooltips(ItemStack itemStack, @Nullable Player player, List<Component> tooltips) {
        String energy = String.format("%,d", EnergyUtil.getEnergyStored(itemStack)) + "/" + String.format("%,d", EnergyUtil.getMaxEnergyStored(itemStack));
        tooltips.add(TooltipUtil.styledWithArgs(EIOLang.ENERGY_AMOUNT, energy));
    }
}

