/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.item.tool;

import com.enderio.api.capability.SideConfig;
import com.enderio.base.common.blockentity.IWrenchable;
import com.enderio.base.common.init.EIOCapabilities;
import com.mojang.datafixers.util.Either;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;

public class YetaWrenchItem
extends Item {
    public YetaWrenchItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext pContext) {
        LazyOptional optSideConfig;
        Level level = pContext.m_43725_();
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = pContext.m_8083_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IWrenchable) {
            IWrenchable wrenchable = (IWrenchable)blockEntity;
            return wrenchable.onWrenched(pContext.m_43723_(), pContext.m_43719_());
        }
        BlockEntity be = level.m_7702_(pos);
        if (be != null && (optSideConfig = be.getCapability(EIOCapabilities.SIDE_CONFIG, pContext.m_43719_())).isPresent()) {
            if (level.m_5776_()) {
                return InteractionResult.m_19078_((boolean)true);
            }
            optSideConfig.ifPresent(SideConfig::cycleMode);
            return InteractionResult.SUCCESS;
        }
        BlockState state = level.m_8055_(pContext.m_8083_());
        Optional<Either<DirectionProperty, EnumProperty<Direction.Axis>>> property = YetaWrenchItem.getRotationProperty(state);
        if (property.isPresent()) {
            BlockState newState = YetaWrenchItem.getNextState(pContext, state, property.get());
            pContext.m_43725_().m_7731_(pContext.m_8083_(), newState, 3);
            return InteractionResult.SUCCESS;
        }
        return super.onItemUseFirst(stack, pContext);
    }

    private static Optional<Either<DirectionProperty, EnumProperty<Direction.Axis>>> getRotationProperty(BlockState state) {
        for (Property property : state.m_61147_()) {
            EnumProperty enumProperty;
            DirectionProperty directionProperty;
            if (property instanceof DirectionProperty && (directionProperty = (DirectionProperty)property).m_61708_().equals("facing")) {
                return Optional.of(Either.left((Object)directionProperty));
            }
            if (!(property instanceof EnumProperty) || !(enumProperty = (EnumProperty)property).m_61708_().equals("axis") || !enumProperty.m_61709_().equals(Direction.Axis.class)) continue;
            return Optional.of(Either.right((Object)enumProperty));
        }
        return Optional.empty();
    }

    private static BlockState getNextState(UseOnContext pContext, BlockState state, Either<DirectionProperty, EnumProperty<Direction.Axis>> property) {
        return YetaWrenchItem.handleProperties(pContext, state, property.left(), property.right());
    }

    private static BlockState handleProperties(UseOnContext pContext, BlockState state, Optional<DirectionProperty> directionProperty, Optional<EnumProperty<Direction.Axis>> axisProperty) {
        if (directionProperty.isPresent()) {
            return YetaWrenchItem.handleProperty(pContext, state, (Property)directionProperty.get());
        }
        if (axisProperty.isPresent()) {
            return YetaWrenchItem.handleProperty(pContext, state, (Property)axisProperty.get());
        }
        throw new IllegalArgumentException("At least one Optional should be set");
    }

    private static <T extends Comparable<T>> BlockState handleProperty(UseOnContext pContext, BlockState state, Property<T> property) {
        int noValidStateIndex = 0;
        do {
            state = YetaWrenchItem.getNextBlockState(state, property);
        } while (++noValidStateIndex != property.m_6908_().size() && !state.m_60734_().m_7898_(state, (LevelReader)pContext.m_43725_(), pContext.m_8083_()));
        return state;
    }

    private static <T extends Comparable<T>> BlockState getNextBlockState(BlockState currentState, Property<T> property) {
        return (BlockState)currentState.m_61124_(property, YetaWrenchItem.getNextValue(currentState.m_61143_(property), property));
    }

    private static <T extends Comparable<T>> T getNextValue(T value, Property<T> property) {
        boolean foundValid = false;
        for (Comparable possibleValue : property.m_6908_()) {
            if (foundValid) {
                return (T)possibleValue;
            }
            foundValid = possibleValue == value;
        }
        return (T)((Comparable)property.m_6908_().iterator().next());
    }
}

