/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.recipe;

import com.enderio.EnderIO;
import com.enderio.api.grindingball.GrindingBallData;
import com.enderio.base.common.init.EIORecipes;
import com.enderio.core.common.recipes.EnderRecipe;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class GrindingBallRecipe
implements GrindingBallData,
EnderRecipe<Container> {
    private final ResourceLocation id;
    private final Item item;
    private final float doublingChance;
    private final float bonusMultiplier;
    private final float powerUse;
    private final int durability;

    public GrindingBallRecipe(ResourceLocation id, Item item, float doublingChance, float bonusMultiplier, float powerUse, int durability) {
        this.id = id;
        this.item = item;
        this.doublingChance = doublingChance;
        this.bonusMultiplier = bonusMultiplier;
        this.powerUse = powerUse;
        this.durability = durability;
    }

    public Item getItem() {
        return this.item;
    }

    public boolean m_5818_(Container container, Level level) {
        return container.m_8020_(0).m_150930_(this.item);
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.m_8043_(registryAccess);
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public ResourceLocation getGrindingBallId() {
        return this.m_6423_();
    }

    public RecipeSerializer<GrindingBallRecipe> m_7707_() {
        return (RecipeSerializer)EIORecipes.GRINDING_BALL.serializer().get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)EIORecipes.GRINDING_BALL.type().get();
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_122779_();
        list.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.item}));
        return list;
    }

    @Override
    public float getOutputMultiplier() {
        return this.doublingChance;
    }

    @Override
    public float getBonusMultiplier() {
        return this.bonusMultiplier;
    }

    @Override
    public float getPowerUse() {
        return this.powerUse;
    }

    @Override
    public int getDurability() {
        return this.durability;
    }

    public static class Serializer
    implements RecipeSerializer<GrindingBallRecipe> {
        public GrindingBallRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            ResourceLocation grindingBallId = new ResourceLocation(serializedRecipe.get("item").getAsString());
            Item grindingBall = (Item)ForgeRegistries.ITEMS.getValue(grindingBallId);
            if (grindingBall == null) {
                throw new ResourceLocationException("Grinding ball item not found!");
            }
            float grinding = serializedRecipe.get("grinding").getAsFloat();
            float chance = serializedRecipe.get("chance").getAsFloat();
            float power = serializedRecipe.get("power").getAsFloat();
            int durability = serializedRecipe.get("durability").getAsInt();
            return new GrindingBallRecipe(recipeId, grindingBall, grinding, chance, power, durability);
        }

        public GrindingBallRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            try {
                ResourceLocation grindingBallId = buffer.m_130281_();
                Item grindingBall = (Item)ForgeRegistries.ITEMS.getValue(grindingBallId);
                if (grindingBall == null) {
                    throw new ResourceLocationException("Grinding ball item not found!");
                }
                float grinding = buffer.readFloat();
                float chance = buffer.readFloat();
                float power = buffer.readFloat();
                int durability = buffer.readInt();
                return new GrindingBallRecipe(recipeId, grindingBall, grinding, chance, power, durability);
            }
            catch (Exception e) {
                EnderIO.LOGGER.error("Error reading grinding ball recipe from packet.", (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(FriendlyByteBuf buffer, GrindingBallRecipe recipe) {
            try {
                buffer.m_130085_(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)recipe.item)));
                buffer.writeFloat(recipe.doublingChance);
                buffer.writeFloat(recipe.bonusMultiplier);
                buffer.writeFloat(recipe.powerUse);
                buffer.writeInt(recipe.durability);
            }
            catch (Exception ex) {
                EnderIO.LOGGER.error("Error writing grinding ball recipe to packet.", (Throwable)ex);
                throw ex;
            }
        }
    }
}

