/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.util;

import net.minecraft.world.entity.player.Player;

public class ExperienceUtil {
    public static int EXP_TO_FLUID = 20;

    public static int getXpNeededForNextLevel(int currentLevel) {
        if (currentLevel >= 30) {
            return 112 + (currentLevel - 30) * 9;
        }
        return currentLevel >= 15 ? 37 + (currentLevel - 15) * 5 : 7 + currentLevel * 2;
    }

    public static long getTotalXpFromLevel(int level) {
        if (level >= 32) {
            return (long)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
        }
        if (level >= 17) {
            return (long)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        }
        return (long)(Math.pow(level, 2.0) + (double)(6L * (long)level));
    }

    public static int getTotalLevelFromXp(long experience) {
        if (experience >= 1508L) {
            return (int)(18.055555555555557 + Math.sqrt(0.2222222222222222 * ((double)experience - 752.9861111111111)));
        }
        if (experience >= 353L) {
            return (int)(8.1 + Math.sqrt(0.4 * ((double)experience - 195.975)));
        }
        return (int)(Math.sqrt(experience + 9L) - 3.0);
    }

    public static long getPlayerTotalXp(Player player) {
        return ExperienceUtil.getTotalXpFromLevel(player.f_36078_) + (long)Math.floor(player.f_36080_ * (float)ExperienceUtil.getXpNeededForNextLevel(player.f_36078_));
    }

    public static ExperienceLevel getLevelForExpWithLeftover(int experience, int startLevel, int stopLevel) {
        long startXp = ExperienceUtil.getTotalXpFromLevel(startLevel);
        long totalXp = startXp + (long)experience;
        int maxLevel = Math.min(ExperienceUtil.getTotalLevelFromXp(totalXp), stopLevel);
        int remainder = (int)(totalXp - ExperienceUtil.getTotalXpFromLevel(maxLevel));
        return new ExperienceLevel(maxLevel, remainder);
    }

    public static ExperienceLevel getLevelFromFluidWithLeftover(int fluidAmount, int startLevel, int stopLevel) {
        ExperienceLevel res = ExperienceUtil.getLevelForExpWithLeftover(fluidAmount / EXP_TO_FLUID, startLevel, stopLevel);
        return new ExperienceLevel(res.level(), res.experience() + fluidAmount % EXP_TO_FLUID);
    }

    public static ExperienceLevel getLevelFromFluidWithLeftover(int fluidAmount) {
        return ExperienceUtil.getLevelFromFluidWithLeftover(fluidAmount, 0, Integer.MAX_VALUE);
    }

    public static int getLevelFromFluid(int fluidAmount) {
        return ExperienceUtil.getLevelFromFluidWithLeftover(fluidAmount).level();
    }

    public static long getFluidFromLevel(int level) {
        return ExperienceUtil.getTotalXpFromLevel(level) * (long)EXP_TO_FLUID;
    }

    public record ExperienceLevel(int level, int experience) {
    }
}

