/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.util;

import com.enderio.api.grindingball.GrindingBallData;
import com.enderio.base.common.init.EIORecipes;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class GrindingBallManager {
    private static final HashMap<Item, GrindingBallData> ITEM_TO_DATA = new HashMap();
    private static final HashMap<ResourceLocation, GrindingBallData> ID_TO_DATA = new HashMap();
    private static boolean clearCache = false;

    public static boolean isGrindingBall(ItemStack stack) {
        GrindingBallManager.checkCacheRebuild();
        return !stack.m_41619_() && ITEM_TO_DATA.containsKey(stack.m_41720_());
    }

    public static GrindingBallData getData(ItemStack stack) {
        GrindingBallManager.checkCacheRebuild();
        Item item = stack.m_41720_();
        return ITEM_TO_DATA.getOrDefault(item, GrindingBallData.IDENTITY);
    }

    public static List<Item> getGrindingBalls() {
        GrindingBallManager.checkCacheRebuild();
        return List.copyOf(ITEM_TO_DATA.keySet());
    }

    public static GrindingBallData getData(ResourceLocation dataId) {
        GrindingBallManager.checkCacheRebuild();
        return ID_TO_DATA.getOrDefault(dataId, GrindingBallData.IDENTITY);
    }

    @SubscribeEvent
    public static void registerReloadListener(AddReloadListenerEvent event) {
        clearCache = true;
    }

    @SubscribeEvent
    public static void onRecipesUpdated(RecipesUpdatedEvent event) {
        GrindingBallManager.rebuildCache(event.getRecipeManager());
    }

    private static void checkCacheRebuild() {
        if (clearCache && EffectiveSide.get().isServer()) {
            GrindingBallManager.rebuildCache(ServerLifecycleHooks.getCurrentServer().m_129894_());
            clearCache = false;
        }
    }

    private static void rebuildCache(RecipeManager manager) {
        ITEM_TO_DATA.clear();
        ID_TO_DATA.clear();
        manager.m_44013_((RecipeType)EIORecipes.GRINDING_BALL.type().get()).forEach(grindingBallRecipe -> {
            ITEM_TO_DATA.put(grindingBallRecipe.getItem(), (GrindingBallData)grindingBallRecipe);
            ID_TO_DATA.put(grindingBallRecipe.getGrindingBallId(), (GrindingBallData)grindingBallRecipe);
        });
    }
}

