/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.client.gui;

import com.enderio.EnderIO;
import com.enderio.api.conduit.ConduitMenuData;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.ExtendedConduitData;
import com.enderio.api.misc.ColorControl;
import com.enderio.api.misc.RedstoneControl;
import com.enderio.api.misc.Vector2i;
import com.enderio.base.common.lang.EIOLang;
import com.enderio.conduits.client.gui.ConduitSelectionButton;
import com.enderio.conduits.common.blockentity.ConduitBlockEntity;
import com.enderio.conduits.common.blockentity.ConduitBundle;
import com.enderio.conduits.common.blockentity.SlotType;
import com.enderio.conduits.common.blockentity.connection.DynamicConnectionState;
import com.enderio.conduits.common.blockentity.connection.IConnectionState;
import com.enderio.conduits.common.init.ConduitLang;
import com.enderio.conduits.common.menu.ConduitMenu;
import com.enderio.conduits.common.menu.ConduitSlot;
import com.enderio.conduits.common.network.C2SSetConduitConnectionState;
import com.enderio.conduits.common.network.C2SSetConduitExtendedData;
import com.enderio.core.client.gui.screen.EIOScreen;
import com.enderio.core.client.gui.widgets.CheckBox;
import com.enderio.core.client.gui.widgets.EnumIconWidget;
import com.enderio.core.common.network.CoreNetwork;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;

public class ConduitScreen
extends EIOScreen<ConduitMenu> {
    public static final ResourceLocation TEXTURE = EnderIO.loc("textures/gui/conduit.png");
    private final List<ConduitSelectionButton> typeSelectionButtons = new ArrayList<ConduitSelectionButton>();
    private final List<GuiEventListener> typedButtons = new ArrayList<GuiEventListener>();
    private boolean recalculateTypedButtons = true;

    public ConduitScreen(ConduitMenu pMenu, Inventory pPlayerInventory, Component title) {
        super(pMenu, pPlayerInventory, title);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.updateConnectionWidgets(true);
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
        ConduitMenuData data = ((ConduitMenu)this.f_97732_).getConduitType().getMenuData();
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.getGuiLeft(), (float)this.getGuiTop(), 0.0f);
        if (data.showBarSeperator()) {
            guiGraphics.m_280218_(this.getBackgroundImage(), 102, 7, 255, 0, 1, 97);
        }
        for (SlotType type : SlotType.values()) {
            if (!type.isAvailableFor(data)) continue;
            guiGraphics.m_280218_(this.getBackgroundImage(), type.getX() - 1, type.getY() - 1, 206, 0, 18, 18);
        }
        guiGraphics.m_280168_().m_85849_();
    }

    @Override
    protected void m_280003_(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
        super.m_280003_(guiGraphics, pMouseX, pMouseY);
        ConduitMenuData data = ((ConduitMenu)this.f_97732_).getConduitType().getMenuData();
        guiGraphics.m_280614_(this.f_96547_, ConduitLang.CONDUIT_INSERT, 38, 11, 0x404040, false);
        if (data.showBothEnable()) {
            guiGraphics.m_280614_(this.f_96547_, ConduitLang.CONDUIT_EXTRACT, 128, 11, 0x404040, false);
        }
    }

    private void updateConnectionWidgets(boolean forceUpdate) {
        if (forceUpdate || this.recalculateTypedButtons) {
            this.recalculateTypedButtons = false;
            this.typedButtons.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
            this.typedButtons.clear();
            ConduitMenuData data = ((ConduitMenu)this.f_97732_).getConduitType().getMenuData();
            Vector2i pos = new Vector2i(22, 7).add(this.getGuiLeft(), this.getGuiTop());
            this.addTypedButton((AbstractWidget)new CheckBox(pos, () -> this.getOnDynamic(dyn -> dyn.isInsert(), false), bool -> this.actOnDynamic(dyn -> dyn.withEnabled(false, (boolean)bool))));
            if (data.showBothEnable()) {
                this.addTypedButton((AbstractWidget)new CheckBox(pos.add(90, 0), () -> this.getOnDynamic(dyn -> dyn.isExtract(), false), bool -> this.actOnDynamic(dyn -> dyn.withEnabled(true, (boolean)bool))));
            }
            if (data.showColorInsert()) {
                this.addTypedButton(new EnumIconWidget<ColorControl, ConduitScreen>(this, pos.x(), pos.y() + 20, () -> this.getOnDynamic(dyn -> dyn.insert(), ColorControl.GREEN), color -> this.actOnDynamic(dyn -> dyn.withColor(false, (ColorControl)color)), EIOLang.CONDUIT_CHANNEL));
            }
            if (data.showColorExtract()) {
                this.addTypedButton(new EnumIconWidget<ColorControl, ConduitScreen>(this, pos.x() + 90, pos.y() + 20, () -> this.getOnDynamic(dyn -> dyn.extract(), ColorControl.GREEN), color -> this.actOnDynamic(dyn -> dyn.withColor(true, (ColorControl)color)), EIOLang.CONDUIT_CHANNEL));
            }
            if (data.showRedstoneExtract()) {
                this.addTypedButton(new EnumIconWidget<RedstoneControl, ConduitScreen>(this, pos.x() + 90, pos.y() + 40, () -> this.getOnDynamic(dyn -> dyn.control(), RedstoneControl.ACTIVE_WITH_SIGNAL), mode -> this.actOnDynamic(dyn -> dyn.withRedstoneMode((RedstoneControl)mode)), EIOLang.REDSTONE_MODE));
                this.addTypedButton(new EnumIconWidget<ColorControl, ConduitScreen>(this, pos.x() + 90 + 20, pos.y() + 40, () -> this.getOnDynamic(dyn -> dyn.redstoneChannel(), ColorControl.GREEN), color -> this.actOnDynamic(dyn -> dyn.withRedstoneChannel((ColorControl)color)), EIOLang.REDSTONE_CHANNEL));
            }
            ((ConduitMenu)this.f_97732_).getConduitType().getClientData().createWidgets((Screen)this, this.getBundle().getNodeFor(((ConduitMenu)this.f_97732_).getConduitType()).getExtendedConduitData().cast(), mapper -> this.sendExtendedConduitUpdate(mapper), ((ConduitMenu)this.f_97732_)::getDirection, new Vector2i(22, 7).add(this.getGuiLeft(), this.getGuiTop())).forEach(this::addTypedButton);
        }
        ArrayList validConnections = new ArrayList();
        for (ConduitType<?> type2 : this.getBundle().getTypes()) {
            if (!(this.getConnectionState(type2) instanceof DynamicConnectionState)) continue;
            validConnections.add(type2);
        }
        if (forceUpdate || !this.typeSelectionButtons.stream().map(ConduitSelectionButton::getType).toList().equals(validConnections)) {
            this.typeSelectionButtons.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
            this.typeSelectionButtons.clear();
            for (int i = 0; i < validConnections.size(); ++i) {
                ConduitType connection = (ConduitType)validConnections.get(i);
                ConduitSelectionButton button = new ConduitSelectionButton(this.getGuiLeft() + 206, this.getGuiTop() + 4 + 24 * i, connection, ((ConduitMenu)this.f_97732_)::getConduitType, type -> {
                    ((ConduitMenu)this.f_97732_).setConduitType((ConduitType<?>)type);
                    this.recalculateTypedButtons = true;
                });
                this.typeSelectionButtons.add(button);
                this.m_142416_((GuiEventListener)button);
            }
        }
    }

    private void sendExtendedConduitUpdate(Function<ExtendedConduitData<?>, ExtendedConduitData<?>> map) {
        Object currentData = this.getBundle().getNodeFor(((ConduitMenu)this.f_97732_).getConduitType()).getExtendedConduitData().cast();
        ConduitMenu menu = (ConduitMenu)this.m_6262_();
        CoreNetwork.sendToServer(new C2SSetConduitExtendedData(((ConduitBlockEntity)((Object)menu.getBlockEntity())).m_58899_(), menu.getConduitType(), map.apply((ExtendedConduitData<?>)currentData)));
    }

    private void addTypedButton(AbstractWidget button) {
        this.typedButtons.add((GuiEventListener)button);
        this.m_142416_((GuiEventListener)button);
    }

    private void actOnDynamic(Function<DynamicConnectionState, DynamicConnectionState> map) {
        IConnectionState iConnectionState = this.getConnectionState();
        if (iConnectionState instanceof DynamicConnectionState) {
            DynamicConnectionState dyn = (DynamicConnectionState)iConnectionState;
            CoreNetwork.sendToServer(new C2SSetConduitConnectionState(((ConduitBlockEntity)((Object)((ConduitMenu)this.m_6262_()).getBlockEntity())).m_58899_(), ((ConduitMenu)this.m_6262_()).getDirection(), ((ConduitMenu)this.m_6262_()).getConduitType(), map.apply(dyn)));
        }
    }

    private <T> T getOnDynamic(Function<DynamicConnectionState, T> map, T defaultValue) {
        T t;
        IConnectionState iConnectionState = this.getConnectionState();
        if (iConnectionState instanceof DynamicConnectionState) {
            DynamicConnectionState dyn = (DynamicConnectionState)iConnectionState;
            t = map.apply(dyn);
        } else {
            t = defaultValue;
        }
        return t;
    }

    private IConnectionState getConnectionState() {
        return this.getConnectionState(((ConduitMenu)this.f_97732_).getConduitType());
    }

    private IConnectionState getConnectionState(ConduitType<?> type) {
        return this.getBundle().getConnection(((ConduitMenu)this.f_97732_).getDirection()).getConnectionState(type);
    }

    private ConduitBundle getBundle() {
        return ((ConduitBlockEntity)((Object)((ConduitMenu)this.f_97732_).getBlockEntity())).getBundle();
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (!((ConduitMenu)this.f_97732_).m_6875_((Player)this.f_96541_.f_91074_)) {
            this.f_96541_.f_91074_.m_6915_();
        } else {
            this.updateConnectionWidgets(false);
            ((ConduitMenu)this.f_97732_).getConduitSlots().forEach(ConduitSlot::updateVisibilityPosition);
            super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public ResourceLocation getBackgroundImage() {
        return TEXTURE;
    }

    @Override
    protected Vector2i getBackgroundImageSize() {
        return new Vector2i(206, 195);
    }
}

