/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common;

import com.enderio.api.capability.IConduitFilter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ConduitFilter
implements IConduitFilter {
    public static String TAG_FILTER_INVERT_MODE = "invert_mode";
    public static String TAG_FILTER_STRICT_MODE = "strict_mode";
    private final ItemStack stack;
    private final int size;
    private boolean invertMode;
    private boolean strictMode;
    @Nullable
    private List<ItemStack> filterItems;

    public ConduitFilter(ItemStack stack, int size) {
        this.stack = stack;
        this.size = size;
        this.invertMode = stack.m_41784_().m_128471_(TAG_FILTER_INVERT_MODE);
        this.strictMode = stack.m_41784_().m_128471_(TAG_FILTER_STRICT_MODE);
    }

    @Override
    public List<ItemStack> getItems() {
        if (this.filterItems == null) {
            if (this.stack.m_41782_()) {
                ListTag list = this.stack.m_41783_().m_128437_("items", 10);
                this.filterItems = new ArrayList<ItemStack>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    ItemStack stack = ItemStack.m_41712_((CompoundTag)list.m_128728_(i));
                    if (stack.m_41619_()) continue;
                    this.filterItems.add(stack);
                }
            } else {
                this.filterItems = new ArrayList<ItemStack>(2);
            }
        }
        return this.filterItems;
    }

    @Override
    public boolean testItem(ItemStack item) {
        for (ItemStack ourItem : this.getItems()) {
            if (!(this.strictMode ? ItemStack.m_150942_((ItemStack)item, (ItemStack)ourItem) : ItemStack.m_41656_((ItemStack)item, (ItemStack)ourItem))) continue;
            return !this.invertMode;
        }
        return this.invertMode;
    }

    @Override
    public void save() {
        if (this.stack.m_41619_()) {
            return;
        }
        if (this.getItems().isEmpty()) {
            this.stack.m_41749_("items");
            return;
        }
        ListTag list = new ListTag();
        for (ItemStack stack : this.getItems()) {
            list.add((Object)stack.m_41739_(new CompoundTag()));
        }
        this.stack.m_41700_("items", (Tag)list);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public boolean getIgnoreMode() {
        return this.invertMode;
    }

    @Override
    public void setIgnoreMode(boolean newState) {
        if (this.stack.m_41619_()) {
            return;
        }
        if (this.invertMode == newState) {
            return;
        }
        this.invertMode = newState;
        this.stack.m_41784_().m_128379_(TAG_FILTER_INVERT_MODE, this.invertMode);
    }

    @Override
    public boolean getStrictMode() {
        return this.strictMode;
    }

    @Override
    public void setStrictMode(boolean newState) {
        if (this.stack.m_41619_()) {
            return;
        }
        if (this.strictMode == newState) {
            return;
        }
        this.strictMode = newState;
        this.stack.m_41784_().m_128379_(TAG_FILTER_STRICT_MODE, this.strictMode);
    }
}

