/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.blockentity;

import com.enderio.api.UseOnly;
import com.enderio.api.conduit.ConduitMenuData;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.ExtendedConduitData;
import com.enderio.api.conduit.NodeIdentifier;
import com.enderio.conduits.common.ConduitShape;
import com.enderio.conduits.common.blockentity.ConduitBundle;
import com.enderio.conduits.common.blockentity.ConduitBundleNetworkDataSlot;
import com.enderio.conduits.common.blockentity.ConduitConnection;
import com.enderio.conduits.common.blockentity.RightClickAction;
import com.enderio.conduits.common.blockentity.SlotData;
import com.enderio.conduits.common.blockentity.SlotType;
import com.enderio.conduits.common.blockentity.connection.DynamicConnectionState;
import com.enderio.conduits.common.blockentity.connection.IConnectionState;
import com.enderio.conduits.common.blockentity.connection.StaticConnectionStates;
import com.enderio.conduits.common.init.ConduitItems;
import com.enderio.conduits.common.menu.ConduitMenu;
import com.enderio.conduits.common.network.ConduitSavedData;
import com.enderio.core.common.blockentity.EnderBlockEntity;
import dev.gigaherz.graph3.Graph;
import dev.gigaherz.graph3.GraphObject;
import dev.gigaherz.graph3.Mergeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConduitBlockEntity
extends EnderBlockEntity {
    public static final ModelProperty<ConduitBundle> BUNDLE_MODEL_PROPERTY = new ModelProperty();
    public static final ModelProperty<BlockPos> POS = new ModelProperty();
    private final ConduitShape shape = new ConduitShape();
    private final ConduitBundle bundle;
    @UseOnly(value=LogicalSide.CLIENT)
    private ConduitBundle clientBundle;
    private UpdateState checkConnection = UpdateState.NONE;
    private final Map<ConduitType<?>, NodeIdentifier<?>> lazyNodes = new HashMap();
    private ListTag lazyNodeNBT = new ListTag();

    public ConduitBlockEntity(BlockEntityType<?> type, BlockPos worldPosition, BlockState blockState) {
        super(type, worldPosition, blockState);
        this.bundle = new ConduitBundle(this::scheduleTick, worldPosition);
        this.clientBundle = this.bundle.deepCopy();
        this.addDataSlot(new ConduitBundleNetworkDataSlot(this::getBundle));
        this.addAfterSyncRunnable(this::updateClient);
    }

    public void updateClient() {
        this.clientBundle = this.bundle.deepCopy();
        this.updateShape();
        this.requestModelDataUpdate();
        this.f_58857_.m_6550_(this.m_58899_(), Blocks.f_50016_.m_49966_(), this.m_58900_());
    }

    @UseOnly(value=LogicalSide.SERVER)
    public void handleConnectionStateUpdate(Direction direction, ConduitType<?> conduitType, DynamicConnectionState connectionState) {
        ConduitConnection connection = this.bundle.getConnection(direction);
        if (connection.getConnectionState(conduitType) instanceof DynamicConnectionState) {
            connection.setConnectionState(conduitType, (IConnectionState)connectionState);
            ConduitBlockEntity.pushIOState(direction, this.bundle.getNodeFor(conduitType), connectionState);
        }
        this.updateClient();
        this.updateConnectionToData(conduitType);
    }

    @UseOnly(value=LogicalSide.SERVER)
    public void handleExtendedDataUpdate(ConduitType<?> conduitType, CompoundTag compoundTag) {
        this.getBundle().getNodeFor(conduitType).getExtendedConduitData().deserializeNBT((Tag)compoundTag);
    }

    private void scheduleTick() {
        this.m_6596_();
    }

    public void onLoad() {
        this.updateShape();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.sync();
            this.bundle.onLoad(this.f_58857_, this.m_58899_());
            for (Map.Entry entry : this.lazyNodes.entrySet()) {
                NodeIdentifier node = (NodeIdentifier)entry.getValue();
                for (Direction dir : Direction.values()) {
                    this.tryConnectTo(dir, (ConduitType)entry.getKey(), false, false).ifPresent(otherNode -> Graph.connect((GraphObject)node, (GraphObject)otherNode));
                }
                for (GraphObject object : node.getGraph().getObjects()) {
                    if (!(object instanceof NodeIdentifier)) continue;
                    NodeIdentifier otherNode2 = (NodeIdentifier)object;
                    node.getExtendedConduitData().onConnectTo(otherNode2.getExtendedConduitData().cast());
                }
                ConduitSavedData.addPotentialGraph((ConduitType)entry.getKey(), Objects.requireNonNull(node.getGraph()), serverLevel);
            }
        }
    }

    public boolean stillValid(Player pPlayer) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return pPlayer.canReach(this.f_58858_, 1.5);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ConduitSavedData savedData = ConduitSavedData.get(serverLevel);
            for (ConduitType<?> type : this.bundle.getTypes()) {
                NodeIdentifier<?> node = this.bundle.getNodeFor(type);
                node.getExtendedConduitData().onRemoved(type, this.f_58857_, this.m_58899_());
                savedData.putUnloadedNodeIdentifier(type, this.f_58858_, node);
            }
        }
    }

    public void everyTick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.serverTick();
            this.checkConnection = this.checkConnection.next();
            if (this.checkConnection.isInitialized()) {
                this.updateConnections(this.f_58857_, this.f_58858_, null, false);
            }
        }
    }

    public void updateConnections(Level level, BlockPos pos, @Nullable BlockPos fromPos, boolean shouldActivate) {
        for (Direction direction : Direction.values()) {
            if (fromPos != null && level.m_7702_(fromPos) instanceof ConduitBlockEntity) continue;
            for (ConduitType<?> type : this.bundle.getTypes()) {
                IConnectionState connectionState;
                if (shouldActivate && type.getTicker().hasConnectionDelay()) {
                    this.checkConnection = this.checkConnection.activate();
                }
                if ((connectionState = this.bundle.getConnection(direction).getConnectionState(type)) instanceof DynamicConnectionState) {
                    DynamicConnectionState dyn = (DynamicConnectionState)connectionState;
                    if (type.getTicker().canConnectTo(level, pos, direction)) continue;
                    this.getBundle().getNodeFor(type).clearState(direction);
                    this.dropConnection(dyn);
                    this.getBundle().getConnection(direction).setConnectionState(type, (IConnectionState)StaticConnectionStates.DISCONNECTED);
                    this.updateShape();
                    this.updateConnectionToData(type);
                    continue;
                }
                if (connectionState != StaticConnectionStates.DISCONNECTED) continue;
                this.tryConnectTo(direction, type, true, true);
            }
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("ConduitBundle", (Tag)this.bundle.serializeNBT());
        ListTag listTag = new ListTag();
        for (ConduitType<?> type : this.bundle.getTypes()) {
            Object data = this.bundle.getNodeFor(type).getExtendedConduitData();
            listTag.add((Object)data.serializeNBT());
        }
        tag.m_128365_("ConduitExtraData", (Tag)listTag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.bundle.deserializeNBT(tag.m_128469_("ConduitBundle"));
        this.lazyNodeNBT = tag.m_128437_("ConduitExtraData", 10);
    }

    public void m_142339_(Level pLevel) {
        super.m_142339_(pLevel);
        if (!this.f_58857_.m_5776_()) {
            this.loadFromSavedData();
        }
    }

    public ModelData getModelData() {
        return ModelData.builder().with(BUNDLE_MODEL_PROPERTY, (Object)this.clientBundle).with(POS, (Object)this.f_58858_).build();
    }

    public boolean hasType(ConduitType<?> type) {
        return this.bundle.hasType(type);
    }

    public RightClickAction addType(ConduitType<?> type, Player player) {
        RightClickAction action = this.bundle.addType(this.f_58857_, type, player);
        if (action.hasChanged()) {
            RightClickAction.Upgrade upgrade;
            ArrayList nodes = new ArrayList();
            for (Direction dir : Direction.values()) {
                this.tryConnectTo(dir, type, false, false).ifPresent(nodes::add);
            }
            Level level = this.f_58857_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                NodeIdentifier<?> thisNode = Objects.requireNonNull(this.bundle.getNodeForTypeExact(type), "no node found in conduit");
                Graph.integrate(thisNode, nodes);
                for (GraphObject object : thisNode.getGraph().getObjects()) {
                    if (!(object instanceof NodeIdentifier)) continue;
                    NodeIdentifier node = (NodeIdentifier)object;
                    thisNode.getExtendedConduitData().onConnectTo(node.getExtendedConduitData().cast());
                }
                ConduitSavedData.addPotentialGraph(type, Objects.requireNonNull(thisNode.getGraph()), serverLevel);
            }
            if (action instanceof RightClickAction.Upgrade && !(upgrade = (RightClickAction.Upgrade)action).getNotInConduit().getTicker().canConnectTo(upgrade.getNotInConduit(), type)) {
                this.removeNeighborConnections(upgrade.notInConduit());
            }
            this.updateShape();
        }
        return action;
    }

    public Optional<GraphObject<Mergeable.Dummy>> tryConnectTo(Direction dir, ConduitType<?> type, boolean forceMerge, boolean shouldMergeGraph) {
        ConduitBlockEntity conduit;
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(dir));
        if (blockEntity instanceof ConduitBlockEntity && (conduit = (ConduitBlockEntity)blockEntity).connectTo(dir.m_122424_(), type, (ExtendedConduitData<?>)this.bundle.getNodeFor(type).getExtendedConduitData(), forceMerge)) {
            NodeIdentifier node;
            this.connect(dir, type);
            this.updateConnectionToData(type);
            conduit.updateConnectionToData(type);
            NodeIdentifier<?> firstNode = conduit.getBundle().getNodeFor(type);
            NodeIdentifier<?> secondNode = this.bundle.getNodeFor(type);
            firstNode.getExtendedConduitData().onConnectTo(secondNode.getExtendedConduitData().cast());
            if (firstNode.getGraph() != null) {
                for (GraphObject object : firstNode.getGraph().getObjects()) {
                    if (!(object instanceof NodeIdentifier) || (node = (NodeIdentifier)object) == firstNode) continue;
                    firstNode.getExtendedConduitData().onConnectTo(node.getExtendedConduitData().cast());
                }
            }
            if (secondNode.getGraph() != null && firstNode.getGraph() != secondNode.getGraph()) {
                for (GraphObject object : secondNode.getGraph().getObjects()) {
                    if (!(object instanceof NodeIdentifier) || (node = (NodeIdentifier)object) == secondNode) continue;
                    secondNode.getExtendedConduitData().onConnectTo(node.getExtendedConduitData().cast());
                }
            }
            if (shouldMergeGraph) {
                Graph.connect(this.bundle.getNodeFor(type), conduit.bundle.getNodeFor(type));
            }
            return Optional.of(conduit.bundle.getNodeFor(type));
        }
        if (type.getTicker().canConnectTo(this.f_58857_, this.m_58899_(), dir)) {
            this.connectEnd(dir, type);
            this.updateConnectionToData(type);
        }
        return Optional.empty();
    }

    public void updateConnectionToData(ConduitType<?> type) {
        if (!this.f_58857_.f_46443_) {
            this.getBundle().getNodeFor(type).getExtendedConduitData().updateConnection(Arrays.stream(Direction.values()).filter(streamDir -> this.getBundle().getConnection((Direction)streamDir).getConnectionState(type) != StaticConnectionStates.DISABLED).collect(Collectors.toSet()));
        }
    }

    public void removeTypeAndDelete(ConduitType<?> type) {
        if (this.removeType(type, false)) {
            this.f_58857_.m_7731_(this.m_58899_(), this.m_58900_().m_60819_().m_76188_(), this.f_58857_.f_46443_ ? 11 : 3);
        }
    }

    public boolean removeType(ConduitType<?> type, boolean shouldDrop) {
        if (shouldDrop && !this.f_58857_.m_5776_()) {
            this.dropItem(type.getConduitItem().m_7968_());
            for (Direction dir : Direction.values()) {
                IConnectionState iConnectionState = this.getBundle().getConnection(dir).getConnectionState(type);
                if (!(iConnectionState instanceof DynamicConnectionState)) continue;
                DynamicConnectionState dyn = (DynamicConnectionState)iConnectionState;
                this.dropConnection(dyn);
            }
        }
        boolean shouldRemove = this.bundle.removeType(this.f_58857_, type);
        this.removeNeighborConnections(type);
        this.updateShape();
        return shouldRemove;
    }

    public void updateEmptyDynConnection() {
        for (Direction dir : Direction.values()) {
            ConduitConnection connection = this.bundle.getConnection(dir);
            for (int i = 0; i < 9; ++i) {
                DynamicConnectionState dynState;
                IConnectionState iConnectionState = connection.getConnectionState(i);
                if (!(iConnectionState instanceof DynamicConnectionState) || !(dynState = (DynamicConnectionState)iConnectionState).isEmpty()) continue;
                this.dropConnection(dynState);
                connection.disableType(i);
            }
        }
    }

    public void dropConnection(DynamicConnectionState dyn) {
        for (SlotType slotType : SlotType.values()) {
            ItemStack item = dyn.getItem(slotType);
            if (item.m_41619_()) continue;
            this.dropItem(item);
        }
    }

    private void dropItem(ItemStack stack) {
        this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), stack));
    }

    public void removeNeighborConnections(ConduitType<?> type) {
        for (Direction dir : Direction.values()) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(dir));
            if (!(blockEntity instanceof ConduitBlockEntity)) continue;
            ConduitBlockEntity conduit = (ConduitBlockEntity)blockEntity;
            conduit.disconnect(dir.m_122424_(), type);
        }
        Direction[] directionArray = this.f_58857_;
        if (directionArray instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)directionArray;
            for (Direction dir : Direction.values()) {
                ConduitBlockEntity conduit;
                BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(dir));
                if (!(blockEntity instanceof ConduitBlockEntity) || !(conduit = (ConduitBlockEntity)blockEntity).hasType(type)) continue;
                Optional.of(conduit.bundle.getNodeFor(type)).map(NodeIdentifier::getGraph).filter(Objects::nonNull).ifPresent(graph -> ConduitSavedData.addPotentialGraph(type, (Graph<Mergeable.Dummy>)graph, serverLevel));
            }
        }
    }

    public void updateShape() {
        this.shape.updateConduit(this.bundle);
    }

    private void loadFromSavedData() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ConduitSavedData savedData = ConduitSavedData.get(serverLevel);
        for (int typeIndex = 0; typeIndex < this.bundle.getTypes().size(); ++typeIndex) {
            ConduitType<?> type = this.bundle.getTypes().get(typeIndex);
            NodeIdentifier<?> node = savedData.takeUnloadedNodeIdentifier(type, this.f_58858_);
            if (node == null && this.bundle.getNodeForTypeExact(type) == null) {
                Object data = type.createExtendedConduitData(this.f_58857_, this.f_58858_);
                if (typeIndex < this.lazyNodeNBT.size()) {
                    data.deserializeNBT((Tag)this.lazyNodeNBT.m_128728_(typeIndex));
                }
                node = new NodeIdentifier(this.f_58858_, data);
                for (Direction direction : Direction.values()) {
                    IConnectionState iConnectionState = this.bundle.getConnection(direction).getConnectionState(type);
                    if (!(iConnectionState instanceof DynamicConnectionState)) continue;
                    DynamicConnectionState connectionState = (DynamicConnectionState)iConnectionState;
                    ConduitBlockEntity.pushIOState(direction, node, connectionState);
                }
                Graph.integrate(node, List.of());
                this.bundle.setNodeFor(type, node);
                this.lazyNodes.put(type, node);
                continue;
            }
            if (node == null) continue;
            this.bundle.setNodeFor(type, node);
        }
        this.lazyNodeNBT.clear();
    }

    private boolean connectTo(Direction direction, ConduitType<?> type, ExtendedConduitData<?> data, boolean forceMerge) {
        if (!this.doTypesMatch(type)) {
            return false;
        }
        if (!data.canConnectTo(this.bundle.getNodeFor(type).getExtendedConduitData().cast())) {
            return false;
        }
        if (forceMerge || this.bundle.getConnection(direction).getConnectionState(type) != StaticConnectionStates.DISABLED) {
            this.connect(direction, type);
            return true;
        }
        return false;
    }

    private boolean doTypesMatch(ConduitType<?> type) {
        for (ConduitType<?> bundleType : this.bundle.getTypes()) {
            if (!bundleType.getTicker().canConnectTo(bundleType, type)) continue;
            return true;
        }
        return false;
    }

    private void connect(Direction direction, ConduitType<?> type) {
        this.bundle.connectTo(this.f_58857_, this.f_58858_, direction, type, false);
        this.updateClient();
    }

    private void connectEnd(Direction direction, ConduitType<?> type) {
        this.bundle.connectTo(this.f_58857_, this.f_58858_, direction, type, true);
        this.updateClient();
    }

    private void disconnect(Direction direction, ConduitType<?> type) {
        if (this.bundle.disconnectFrom(direction, type)) {
            this.updateClient();
        }
    }

    public ConduitBundle getBundle() {
        return this.bundle;
    }

    public ConduitShape getShape() {
        return this.shape;
    }

    public MenuProvider menuProvider(Direction direction, ConduitType<?> type) {
        return new ConduitMenuProvider(direction, type);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        for (ConduitType<?> type : this.bundle.getTypes()) {
            Optional<LazyOptional<T>> proxiedCap;
            NodeIdentifier<?> node = this.bundle.getNodeFor(type);
            Optional<NodeIdentifier.IOState> state = Optional.empty();
            if (node != null && side != null) {
                state = node.getIOState(side);
            }
            if (!(proxiedCap = type.proxyCapability(cap, node == null ? type.createExtendedConduitData(this.f_58857_, this.m_58899_()).cast() : node.getExtendedConduitData().cast(), this.f_58857_, this.f_58858_, side, state)).isPresent()) continue;
            return proxiedCap.get();
        }
        return super.getCapability(cap, side);
    }

    public IItemHandler getConduitItemHandler() {
        return new ConduitItemHandler();
    }

    public static void pushIOState(Direction direction, NodeIdentifier<?> node, DynamicConnectionState connectionState) {
        node.pushState(direction, connectionState.isInsert() ? connectionState.insert() : null, connectionState.isExtract() ? connectionState.extract() : null, connectionState.control(), connectionState.redstoneChannel());
    }

    public static enum UpdateState {
        NONE,
        NEXT_NEXT,
        NEXT,
        INITIALIZED;


        public boolean isInitialized() {
            return this == INITIALIZED;
        }

        public UpdateState next() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NONE, INITIALIZED -> NONE;
                case NEXT_NEXT -> NEXT;
                case NEXT -> INITIALIZED;
            };
        }

        public UpdateState activate() {
            return NEXT_NEXT;
        }
    }

    private class ConduitMenuProvider
    implements MenuProvider {
        private final Direction direction;
        private final ConduitType<?> type;

        private ConduitMenuProvider(Direction direction, ConduitType<?> type) {
            this.direction = direction;
            this.type = type;
        }

        public Component m_5446_() {
            return ConduitBlockEntity.this.m_58900_().m_60734_().m_49954_();
        }

        @Nullable
        public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
            return new ConduitMenu(ConduitBlockEntity.this, pInventory, pContainerId, this.direction, this.type);
        }
    }

    private class ConduitItemHandler
    implements IItemHandlerModifiable {
        private ConduitItemHandler() {
        }

        public int getSlots() {
            return 162;
        }

        public ItemStack getStackInSlot(int slot) {
            if (slot >= this.getSlots()) {
                return ItemStack.f_41583_;
            }
            SlotData data = SlotData.of(slot);
            if (data.conduitIndex() >= ConduitBlockEntity.this.bundle.getTypes().size()) {
                return ItemStack.f_41583_;
            }
            IConnectionState connectionState = ConduitBlockEntity.this.bundle.getConnection(data.direction()).getConnectionState(data.conduitIndex());
            if (!(connectionState instanceof DynamicConnectionState)) {
                return ItemStack.f_41583_;
            }
            DynamicConnectionState dynamicConnectionState = (DynamicConnectionState)connectionState;
            ConduitMenuData conduitData = ConduitBlockEntity.this.bundle.getTypes().get(data.conduitIndex()).getMenuData();
            if (data.slotType() == SlotType.FILTER_EXTRACT && conduitData.hasFilterExtract() || data.slotType() == SlotType.FILTER_INSERT && conduitData.hasFilterInsert() || data.slotType() == SlotType.UPGRADE_EXTRACT && conduitData.hasUpgrade()) {
                return dynamicConnectionState.getItem(data.slotType());
            }
            return ItemStack.f_41583_;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            boolean reachedLimit;
            int limit;
            if (stack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            ItemStack existing = this.getStackInSlot(slot);
            int n = stack.m_41720_().equals(ConduitItems.SPEED_UPGRADE.m_5456_()) ? 15 : (limit = stack.m_41720_().equals(ConduitItems.SPEED_DOWNGRADE.m_5456_()) ? 3 : Math.min(this.getSlotLimit(slot), stack.m_41741_()));
            if (!existing.m_41619_()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                    return stack;
                }
                limit -= existing.m_41613_();
            }
            if (limit <= 0) {
                return stack;
            }
            boolean bl = reachedLimit = stack.m_41613_() > limit;
            if (!simulate) {
                if (existing.m_41619_()) {
                    this.setStackInSlot(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
                } else {
                    existing.m_41769_(reachedLimit ? limit : stack.m_41613_());
                }
            }
            return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - limit)) : ItemStack.f_41583_;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount == 0) {
                return ItemStack.f_41583_;
            }
            ItemStack existing = this.getStackInSlot(slot);
            if (existing.m_41619_()) {
                return ItemStack.f_41583_;
            }
            int toExtract = Math.min(amount, existing.m_41741_());
            if (existing.m_41613_() <= toExtract) {
                if (!simulate) {
                    this.setStackInSlot(slot, ItemStack.f_41583_);
                    return existing;
                }
                return existing.m_41777_();
            }
            if (!simulate) {
                this.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.m_41613_() - toExtract)));
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
        }

        public int getSlotLimit(int slot) {
            return slot % 3 == 2 ? 64 : 1;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return slot < this.getSlots() && SlotData.of(slot).slotType().acceptsItem(stack.m_41720_());
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            if (slot >= this.getSlots()) {
                return;
            }
            SlotData data = SlotData.of(slot);
            if (data.conduitIndex() >= ConduitBlockEntity.this.bundle.getTypes().size()) {
                return;
            }
            ConduitConnection connection = ConduitBlockEntity.this.bundle.getConnection(data.direction());
            ConduitMenuData conduitData = ConduitBlockEntity.this.bundle.getTypes().get(data.conduitIndex()).getMenuData();
            if (data.slotType().isAvailableFor(conduitData)) {
                connection.setItem(data.slotType(), data.conduitIndex(), stack);
            }
        }
    }
}

