/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.blockentity;

import com.enderio.api.UseOnly;
import com.enderio.api.conduit.ConduitRegistries;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.NodeIdentifier;
import com.enderio.conduits.client.ConduitClientSetup;
import com.enderio.conduits.common.blockentity.ConduitBlockEntity;
import com.enderio.conduits.common.blockentity.ConduitConnection;
import com.enderio.conduits.common.blockentity.ConduitTypeSorter;
import com.enderio.conduits.common.blockentity.RightClickAction;
import com.enderio.conduits.common.blockentity.connection.DynamicConnectionState;
import com.enderio.conduits.common.blockentity.connection.IConnectionState;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.annotations.Nullable;

public final class ConduitBundle
implements INBTSerializable<CompoundTag> {
    public static final int MAX_CONDUIT_TYPES = 9;
    private final Map<Direction, ConduitConnection> connections = new EnumMap<Direction, ConduitConnection>(Direction.class);
    private final List<ConduitType<?>> types = new ArrayList();
    private final Map<ConduitType<?>, NodeIdentifier<?>> nodes = new HashMap();
    private final Runnable scheduleSync;
    private final BlockPos pos;
    private final Map<Direction, BlockState> facadeTextures = new EnumMap<Direction, BlockState>(Direction.class);
    private int dataVersion = Integer.MIN_VALUE;
    private static final boolean IS_NEO_ENV_AFTER_ON_LOAD_CHANGE;
    private static final String KEY_TYPES = "Types";
    private static final String KEY_CONNECTIONS = "Connections";
    private static final String KEY_FACADES = "Facades";
    private static final String KEY_NODE_TYPE = "NodeType";
    private static final String KEY_NODE_DATA = "NodeData";
    private static final String KEY_NODES = "Nodes";
    private static final String KEY_DATA = "ExtendedDataBackup";

    public ConduitBundle(Runnable scheduleSync, BlockPos pos) {
        this.scheduleSync = scheduleSync;
        for (Direction value : Direction.values()) {
            this.connections.put(value, new ConduitConnection(this));
        }
        this.pos = pos;
    }

    public RightClickAction addType(Level level, ConduitType<?> type, Player player) {
        if (this.types.size() == 9) {
            return new RightClickAction.Blocked();
        }
        if (this.types.contains(type)) {
            return new RightClickAction.Blocked();
        }
        Optional<ConduitType> first = this.types.stream().filter(existingConduit -> existingConduit.canBeReplacedBy(type)).findFirst();
        NodeIdentifier node = new NodeIdentifier(this.pos, type.createExtendedConduitData(level, this.pos));
        if (first.isPresent()) {
            int index = this.types.indexOf(first.get());
            this.types.set(index, type);
            NodeIdentifier<?> prevNode = this.nodes.remove(first.get());
            this.nodes.put(type, node);
            if (prevNode != null) {
                prevNode.getExtendedConduitData().onRemoved(type, level, this.pos);
                if (!level.m_5776_() && prevNode.getGraph() != null) {
                    prevNode.getGraph().remove(prevNode);
                }
            }
            node.getExtendedConduitData().onCreated(type, level, this.pos, player);
            this.connections.values().forEach(connection -> connection.disconnectType(index));
            this.scheduleSync.run();
            ++this.dataVersion;
            return new RightClickAction.Upgrade(first.get());
        }
        if (this.types.stream().anyMatch(existingConduit -> !existingConduit.canBeInSameBlock(type) || !type.canBeInSameBlock((ConduitType<?>)existingConduit))) {
            return new RightClickAction.Blocked();
        }
        int id = ConduitTypeSorter.getSortIndex(type);
        Optional<ConduitType> addBefore = this.types.stream().filter(existing -> ConduitTypeSorter.getSortIndex(existing) > id).findFirst();
        if (addBefore.isPresent()) {
            int value = this.types.indexOf(addBefore.get());
            this.types.add(value, type);
            this.nodes.put(type, node);
            node.getExtendedConduitData().onCreated(type, level, this.pos, player);
            for (Direction direction : Direction.values()) {
                this.connections.get(direction).addType(value);
            }
        } else {
            this.types.add(type);
            this.nodes.put(type, node);
            if (this.types.size() != 1 || !IS_NEO_ENV_AFTER_ON_LOAD_CHANGE) {
                node.getExtendedConduitData().onCreated(type, level, this.pos, player);
            }
        }
        this.scheduleSync.run();
        ++this.dataVersion;
        return new RightClickAction.Insert();
    }

    void onLoad(Level level, BlockPos pos) {
        for (ConduitType<?> type : this.types) {
            this.getNodeFor(type).getExtendedConduitData().onCreated(type, level, pos, null);
        }
    }

    public boolean removeType(Level level, ConduitType<?> type) {
        int index = this.types.indexOf(type);
        if (index == -1) {
            if (!FMLLoader.isProduction()) {
                throw new IllegalArgumentException("Conduit: " + ConduitRegistries.REGISTRY.get().getKey(type) + " is not present in conduit bundle " + Arrays.toString(this.types.stream().map(existingType -> ConduitRegistries.REGISTRY.get().getKey(existingType)).toArray()));
            }
            return this.types.isEmpty();
        }
        for (Direction direction : Direction.values()) {
            this.connections.get(direction).removeType(index);
        }
        if (EffectiveSide.get().isServer()) {
            this.removeNodeFor(level, type);
        }
        this.types.remove(index);
        this.scheduleSync.run();
        ++this.dataVersion;
        return this.types.isEmpty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag listTag = new ListTag();
        for (ConduitType<?> conduitType : this.types) {
            listTag.add((Object)StringTag.m_129297_((String)ConduitRegistries.getRegistry().getKey(conduitType).toString()));
        }
        tag.m_128365_(KEY_TYPES, (Tag)listTag);
        CompoundTag connectionsTag = new CompoundTag();
        for (Direction dir : Direction.values()) {
            connectionsTag.m_128365_(dir.m_122433_(), (Tag)this.connections.get(dir).serializeNBT());
        }
        tag.m_128365_(KEY_CONNECTIONS, (Tag)connectionsTag);
        CompoundTag compoundTag = new CompoundTag();
        for (Map.Entry<Direction, BlockState> entry : this.facadeTextures.entrySet()) {
            Tag blockStateTag = (Tag)BlockState.f_61039_.encode((Object)entry.getValue(), (DynamicOps)NbtOps.f_128958_, (Object)new CompoundTag()).get().left().orElse(new CompoundTag());
            compoundTag.m_128365_(entry.getKey().m_122433_(), blockStateTag);
        }
        tag.m_128365_(KEY_FACADES, (Tag)compoundTag);
        if (EffectiveSide.get().isServer()) {
            ListTag nodeTag = new ListTag();
            for (Map.Entry<ConduitType<?>, NodeIdentifier<?>> entry : this.nodes.entrySet()) {
                CompoundTag data = entry.getValue().getExtendedConduitData().serializeRenderNBT();
                if (data.m_128456_()) continue;
                CompoundTag dataTag = new CompoundTag();
                dataTag.m_128359_(KEY_NODE_TYPE, ConduitRegistries.getRegistry().getKey(entry.getKey()).toString());
                dataTag.m_128365_(KEY_NODE_DATA, (Tag)data);
                nodeTag.add((Object)dataTag);
            }
            if (!nodeTag.isEmpty()) {
                tag.m_128365_(KEY_NODES, (Tag)nodeTag);
            }
        }
        return tag;
    }

    public CompoundTag serializeGuiNBT() {
        CompoundTag nbt = new CompoundTag();
        for (ConduitType<?> type : this.getTypes()) {
            CompoundTag compoundTag = this.nodes.get(type).getExtendedConduitData().serializeGuiNBT();
            if (compoundTag.m_128456_()) continue;
            nbt.m_128365_(ConduitRegistries.getRegistry().getKey(type).toString(), (Tag)compoundTag);
        }
        return nbt;
    }

    public void deserializeGuiNBT(CompoundTag nbt) {
        for (ConduitType<?> type : this.getTypes()) {
            if (!nbt.m_128441_(ConduitRegistries.getRegistry().getKey(type).toString())) continue;
            this.nodes.get(type).getExtendedConduitData().deserializeNBT((Tag)nbt.m_128469_(ConduitRegistries.getRegistry().getKey(type).toString()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void deserializeNBT(CompoundTag nbt) {
        block11: {
            block10: {
                void var7_11;
                Direction[] stringTag;
                this.types.clear();
                ListTag typesTag = nbt.m_128437_(KEY_TYPES, 8);
                ArrayList<Integer> invalidTypes = new ArrayList<Integer>();
                for (int i = 0; i < typesTag.size(); ++i) {
                    stringTag = (Direction[])typesTag.get(i);
                    ConduitType type2 = (ConduitType)ConduitRegistries.getRegistry().getValue(ResourceLocation.m_135820_((String)stringTag.m_7916_()));
                    if (type2 == null) {
                        invalidTypes.add(i);
                        continue;
                    }
                    this.types.add(type2);
                }
                CompoundTag connectionsTag = nbt.m_128469_(KEY_CONNECTIONS);
                stringTag = Direction.values();
                int type2 = stringTag.length;
                boolean bl = false;
                while (var7_11 < type2) {
                    Direction dir = stringTag[var7_11];
                    this.connections.get(dir).deserializeNBT(connectionsTag.m_128469_(dir.m_122433_()));
                    for (Integer invalidType : invalidTypes) {
                        this.connections.get(dir).removeType(invalidType);
                    }
                    for (int i = invalidTypes.size() - 1; i >= 0; --i) {
                        this.connections.get(dir).removeType((Integer)invalidTypes.get(i));
                    }
                    ++var7_11;
                }
                this.facadeTextures.clear();
                CompoundTag facades = nbt.m_128469_(KEY_FACADES);
                for (Direction direction : Direction.values()) {
                    if (!facades.m_128441_(direction.m_122433_())) continue;
                    this.facadeTextures.put(direction, (BlockState)((Pair)BlockState.f_61039_.decode((DynamicOps)NbtOps.f_128958_, (Object)facades.m_128469_(direction.m_122433_())).get().left().get()).getFirst());
                }
                for (Map.Entry entry2 : this.facadeTextures.entrySet()) {
                    Tag blockStateTag = (Tag)BlockState.f_61039_.encode((Object)((BlockState)entry2.getValue()), (DynamicOps)NbtOps.f_128958_, (Object)new CompoundTag()).get().left().orElse(new CompoundTag());
                    facades.m_128365_(((Direction)entry2.getKey()).m_122433_(), blockStateTag);
                }
                this.nodes.entrySet().removeIf(entry -> !this.types.contains(entry.getKey()));
                if (!EffectiveSide.get().isServer()) break block10;
                for (ConduitType conduitType : this.types) {
                    if (!this.nodes.containsKey(conduitType)) continue;
                    for (Direction direction : Direction.values()) {
                        IConnectionState iConnectionState = this.getConnection(direction).getConnectionState(conduitType);
                        if (!(iConnectionState instanceof DynamicConnectionState)) continue;
                        DynamicConnectionState dyn = (DynamicConnectionState)iConnectionState;
                        ConduitBlockEntity.pushIOState(direction, this.nodes.get(conduitType), dyn);
                    }
                }
                break block11;
            }
            this.types.forEach(type -> {
                if (!this.nodes.containsKey(type)) {
                    this.nodes.put((ConduitType<?>)type, new NodeIdentifier(this.pos, type.createExtendedConduitData(ConduitClientSetup.getClientLevel(), this.pos)));
                }
            });
            if (!nbt.m_128441_(KEY_NODES)) break block11;
            ListTag nodesTag = nbt.m_128437_(KEY_NODES, 10);
            for (Tag tag : nodesTag) {
                CompoundTag cmp = (CompoundTag)tag;
                this.nodes.get(ConduitRegistries.getRegistry().getValue(new ResourceLocation(cmp.m_128461_(KEY_NODE_TYPE)))).getExtendedConduitData().deserializeNBT((Tag)cmp.m_128469_(KEY_NODE_DATA));
            }
        }
    }

    public ConduitConnection getConnection(Direction direction) {
        return this.connections.get(direction);
    }

    public List<ConduitType<?>> getTypes() {
        return this.types;
    }

    public boolean hasFacade(Direction direction) {
        return this.facadeTextures.containsKey(direction);
    }

    public Optional<BlockState> getFacade(Direction direction) {
        return Optional.ofNullable(this.facadeTextures.get(direction));
    }

    public void setFacade(BlockState facade, Direction direction) {
        this.facadeTextures.put(direction, facade);
        ++this.dataVersion;
    }

    public void connectTo(Level level, BlockPos pos, Direction direction, ConduitType<?> type, boolean end) {
        this.getConnection(direction).connectTo(level, pos, this.getNodeFor(type), direction, type, this.getTypeIndex(type), end);
        this.scheduleSync.run();
        ++this.dataVersion;
    }

    public boolean disconnectFrom(Direction direction, ConduitType<?> type) {
        for (int i = 0; i < this.types.size(); ++i) {
            if (!type.getTicker().canConnectTo(type, this.types.get(i))) continue;
            this.getConnection(direction).tryDisconnect(i);
            this.scheduleSync.run();
            ++this.dataVersion;
            return true;
        }
        return false;
    }

    @Nullable
    public NodeIdentifier<?> getNodeForTypeExact(ConduitType<?> type) {
        return this.nodes.get(type);
    }

    public NodeIdentifier<?> getNodeFor(ConduitType<?> type) {
        for (Map.Entry<ConduitType<?>, NodeIdentifier<?>> entry : this.nodes.entrySet()) {
            if (!entry.getKey().getTicker().canConnectTo(entry.getKey(), type)) continue;
            return this.nodes.get(entry.getKey());
        }
        throw new IllegalStateException("no node matching original type");
    }

    public void setNodeFor(ConduitType<?> type, NodeIdentifier<?> node) {
        this.nodes.put(type, node);
        for (Direction direction : Direction.values()) {
            IConnectionState state;
            ConduitConnection connection = this.connections.get(direction);
            int index = this.types.indexOf(type);
            if (index < 0 || !((state = connection.getConnectionState(index)) instanceof DynamicConnectionState)) continue;
            DynamicConnectionState dynamicState = (DynamicConnectionState)state;
            ConduitBlockEntity.pushIOState(direction, node, dynamicState);
        }
        ++this.dataVersion;
    }

    public void removeNodeFor(Level level, ConduitType<?> type) {
        NodeIdentifier<?> node = this.nodes.get(type);
        node.getExtendedConduitData().onRemoved(type, level, this.pos);
        if (node.getGraph() != null) {
            node.getGraph().remove(node);
        }
        this.nodes.remove(type);
        ++this.dataVersion;
    }

    public boolean hasType(ConduitType<?> type) {
        for (ConduitType<?> conduitType : this.types) {
            if (!conduitType.getTicker().canConnectTo(conduitType, type)) continue;
            return true;
        }
        return false;
    }

    public int getTypeIndex(ConduitType<?> type) {
        for (int i = 0; i < this.types.size(); ++i) {
            if (!this.types.get(i).getTicker().canConnectTo(this.types.get(i), type)) continue;
            return i;
        }
        throw new IllegalStateException("no conduit matching type in bundle");
    }

    public int getDataVersion() {
        return this.dataVersion;
    }

    public void incrementDataVersion() {
        ++this.dataVersion;
    }

    @UseOnly(value=LogicalSide.CLIENT)
    public ConduitBundle deepCopy() {
        ConduitBundle bundle = new ConduitBundle(() -> {}, this.pos);
        bundle.types.addAll(this.types);
        this.connections.forEach((dir, connection) -> bundle.connections.put((Direction)dir, connection.deepCopy(bundle)));
        bundle.facadeTextures.putAll(this.facadeTextures);
        this.nodes.forEach((type, node) -> bundle.setNodeFor((ConduitType<?>)type, new NodeIdentifier(node.getPos(), node.getExtendedConduitData().deepCopy())));
        return bundle;
    }

    static {
        IModInfo forge = (IModInfo)ModList.get().getModFileById("forge").getMods().get(0);
        IS_NEO_ENV_AFTER_ON_LOAD_CHANGE = forge.getDisplayName().equals("NeoForge") && forge.getVersion().compareTo((Object)new DefaultArtifactVersion("47.1.77")) >= 0;
    }
}

