/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.blockentity;

import com.enderio.api.conduit.ConduitRegistries;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.TieredConduit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConduitTypeSorter {
    private static final List<ConduitType<?>> SORTED_TYPES = new ArrayList();

    @SubscribeEvent
    public static void afterRegistryFreeze(FMLCommonSetupEvent event) {
        ForgeRegistry<ConduitType<?>> registry = ConduitRegistries.getRegistry();
        ArrayList<ResourceLocation> tieredTypes = new ArrayList<ResourceLocation>();
        for (ConduitType value : registry) {
            TieredConduit tiered;
            if (!(value instanceof TieredConduit) || tieredTypes.contains((tiered = (TieredConduit)value).getType())) continue;
            tieredTypes.add(tiered.getType());
        }
        tieredTypes.sort(ResourceLocation::compareTo);
        for (ResourceLocation tieredType : tieredTypes) {
            ArrayList<ConduitType> typesInType = new ArrayList<ConduitType>();
            for (ConduitType type : registry) {
                TieredConduit tiered;
                if (!(type instanceof TieredConduit) || !(tiered = (TieredConduit)type).getType().equals((Object)tieredType)) continue;
                typesInType.add(type);
            }
            typesInType.sort(Comparator.comparing(arg_0 -> registry.getKey(arg_0)));
            SORTED_TYPES.addAll(typesInType);
        }
        ArrayList<ConduitType> unadded = new ArrayList<ConduitType>();
        for (ConduitType type : registry) {
            if (type instanceof TieredConduit) continue;
            unadded.add(type);
        }
        unadded.sort(Comparator.comparing(arg_0 -> registry.getKey(arg_0)));
        SORTED_TYPES.addAll(unadded);
    }

    public static int getSortIndex(ConduitType<?> type) {
        return SORTED_TYPES.indexOf(type);
    }
}

