/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.items;

import com.enderio.api.capability.IMultiCapabilityItem;
import com.enderio.api.capability.MultiCapabilityProvider;
import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.conduits.common.ConduitFilter;
import com.enderio.conduits.common.init.ConduitMenus;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class FilterItem
extends Item
implements IMultiCapabilityItem {
    private final int size;

    public static FilterItem basic() {
        return new FilterItem(18);
    }

    public static FilterItem large() {
        return new FilterItem(36);
    }

    public FilterItem(int size) {
        super(new Item.Properties().m_41487_(64));
        this.size = size;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, level, tooltip, tooltipFlag);
        if (Screen.m_96638_()) {
            stack.getCapability(EIOCapabilities.ITEM_FILTER).ifPresent(filterCap -> {
                tooltip.add((Component)Component.m_237113_((String)"Ignore Mode: ").m_7220_((Component)(filterCap.getIgnoreMode() ? Component.m_237115_((String)"options.on").m_130940_(ChatFormatting.GREEN) : Component.m_237115_((String)"options.off").m_130940_(ChatFormatting.RED))));
                tooltip.add((Component)Component.m_237113_((String)"Strict Mode: ").m_7220_((Component)(filterCap.getStrictMode() ? Component.m_237115_((String)"options.on").m_130940_(ChatFormatting.GREEN) : Component.m_237115_((String)"options.off").m_130940_(ChatFormatting.RED))));
            });
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (!level.m_5776_()) {
            ConduitMenus.CONDUIT_FILTER_MENU.open((ServerPlayer)player, stack.m_41611_(), buf -> buf.writeBoolean(usedHand == InteractionHand.MAIN_HAND));
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    @Override
    @Nullable
    public MultiCapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt, MultiCapabilityProvider provider) {
        provider.add(EIOCapabilities.ITEM_FILTER, LazyOptional.of(() -> new ConduitFilter(stack, this.size)));
        return provider;
    }
}

