/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.menu;

import com.enderio.api.misc.Vector2i;
import com.enderio.conduits.common.items.FilterInventory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ConduitFilterMenu
extends AbstractContainerMenu {
    public final InteractionHand hand;
    public final FilterInventory inventory;
    public final List<Vector2i> filterSlots;

    protected ConduitFilterMenu(@Nullable MenuType<ConduitFilterMenu> menuType, int containerId, Inventory playerInventory, InteractionHand hand) {
        super(menuType, containerId);
        this.hand = hand;
        this.inventory = new FilterInventory(playerInventory.f_35978_.m_21120_(hand));
        this.filterSlots = new ArrayList<Vector2i>();
        this.inventory.getDrawableSlots(this.filterSlots);
        for (int i = 0; i < this.filterSlots.size(); ++i) {
            Vector2i slotPos = this.filterSlots.get(i);
            this.m_38897_(new Slot(this.inventory, i, slotPos.x(), slotPos.y()){

                public void m_142406_(Player player, ItemStack stack) {
                }

                public ItemStack m_6201_(int amount) {
                    return ItemStack.f_41583_;
                }

                public boolean m_8010_(Player player) {
                    return false;
                }

                public boolean m_5857_(ItemStack stack) {
                    return false;
                }
            });
        }
        int offset = 15 + Math.abs(this.filterSlots.size() / 9) * 18 + 3 + 9 + 8;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventory, x + y * 9 + 9, 23 + x * 18, offset + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            final int i = x;
            this.m_38897_(new Slot((Container)playerInventory, x, 23 + x * 18, offset + 4 + 54){

                public boolean m_8010_(Player player) {
                    return i != player.m_150109_().f_35977_;
                }
            });
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack stack;
        Slot slot;
        if (index >= this.filterSlots.size() && this.inventory.getFilterCap().getItems().size() < this.filterSlots.size() && index != player.m_150109_().f_35977_ + this.filterSlots.size() && (slot = this.m_38853_(index)) != null && !(stack = slot.m_7993_()).m_41619_()) {
            for (ItemStack stack1 : this.inventory.getFilterCap().getItems()) {
                if (stack1.m_41720_() != stack.m_41720_() || !ItemStack.m_150942_((ItemStack)stack1, (ItemStack)stack)) continue;
                return ItemStack.f_41583_;
            }
            ItemStack is = stack.m_41777_();
            is.m_41764_(1);
            this.inventory.getFilterCap().getItems().add(is);
            this.inventory.getFilterCap().save();
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public void m_150399_(int slotId, int dragType, ClickType clickType, Player player) {
        if (slotId >= 0 && slotId < this.filterSlots.size()) {
            ItemStack stack = this.m_142621_().m_41777_();
            stack.m_41764_(1);
            if (stack.m_41619_()) {
                if (slotId < this.inventory.getFilterCap().getItems().size()) {
                    this.inventory.getFilterCap().getItems().remove(slotId);
                    this.inventory.getFilterCap().save();
                }
            } else {
                for (ItemStack stack1 : this.inventory.getFilterCap().getItems()) {
                    if (stack1.m_41720_() != stack.m_41720_() || !ItemStack.m_150942_((ItemStack)stack1, (ItemStack)stack)) continue;
                    return;
                }
                if (slotId < this.inventory.getFilterCap().getItems().size()) {
                    this.inventory.getFilterCap().getItems().set(slotId, stack);
                    this.inventory.getFilterCap().save();
                } else {
                    this.inventory.getFilterCap().getItems().add(stack);
                    this.inventory.getFilterCap().save();
                }
            }
        } else {
            super.m_150399_(slotId, dragType, clickType, player);
        }
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public static ConduitFilterMenu factory(@Nullable MenuType<ConduitFilterMenu> pMenuType, int pContainerId, Inventory inventory, @Nullable FriendlyByteBuf buf) {
        return new ConduitFilterMenu(pMenuType, pContainerId, inventory, buf == null ? InteractionHand.MAIN_HAND : (buf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND));
    }
}

