/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.network;

import com.enderio.api.capability.IConduitFilter;
import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.conduits.common.init.ConduitItems;
import com.enderio.conduits.common.menu.ConduitFilterMenu;
import com.enderio.core.common.network.Packet;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class ConduitItemFilterPacket
implements Packet {
    public final ItemStack theFilter;
    public boolean ignoreMode;
    public boolean strictMode;

    public ConduitItemFilterPacket(ItemStack theFilter, boolean ignoreMode, boolean strictMode) {
        this.theFilter = theFilter;
        this.ignoreMode = ignoreMode;
        this.strictMode = strictMode;
    }

    public ConduitItemFilterPacket(FriendlyByteBuf buf) {
        this.theFilter = buf.m_130267_();
        this.ignoreMode = buf.readBoolean();
        this.strictMode = buf.readBoolean();
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130055_(this.theFilter);
        buf.writeBoolean(this.ignoreMode);
        buf.writeBoolean(this.strictMode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isValid(NetworkEvent.Context context) {
        AbstractContainerMenu abstractContainerMenu;
        if (context.getSender() == null) return false;
        if (this.theFilter.m_41619_()) return false;
        if (!this.theFilter.m_150930_(ConduitItems.BASIC_ITEM_FILTER.m_5456_())) {
            if (!this.theFilter.m_150930_(ConduitItems.BIG_ITEM_FILTER.m_5456_())) return false;
        }
        if (!((abstractContainerMenu = context.getSender().f_36096_) instanceof ConduitFilterMenu)) return false;
        ConduitFilterMenu cfm = (ConduitFilterMenu)abstractContainerMenu;
        if (!ItemStack.m_41656_((ItemStack)this.theFilter, (ItemStack)cfm.inventory.filter)) return false;
        return true;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        AbstractContainerMenu abstractContainerMenu = Objects.requireNonNull(context.getSender()).f_36096_;
        if (abstractContainerMenu instanceof ConduitFilterMenu) {
            ConduitFilterMenu cfm = (ConduitFilterMenu)abstractContainerMenu;
            IConduitFilter cap = (IConduitFilter)cfm.inventory.filter.getCapability(EIOCapabilities.ITEM_FILTER).resolve().get();
            cap.setIgnoreMode(this.ignoreMode);
            cap.setStrictMode(this.strictMode);
        }
    }

    public static class Handler
    extends Packet.PacketHandler<ConduitItemFilterPacket> {
        @Override
        public ConduitItemFilterPacket fromNetwork(FriendlyByteBuf buf) {
            return new ConduitItemFilterPacket(buf);
        }

        @Override
        public void toNetwork(ConduitItemFilterPacket packet, FriendlyByteBuf buf) {
            packet.write(buf);
        }

        @Override
        public Optional<NetworkDirection> getDirection() {
            return Optional.of(NetworkDirection.PLAY_TO_SERVER);
        }
    }
}

