/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.network;

import com.enderio.EnderIO;
import com.enderio.api.conduit.ConduitRegistries;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.ExtendedConduitData;
import com.enderio.api.conduit.NodeIdentifier;
import com.enderio.api.misc.ColorControl;
import com.enderio.conduits.common.blockentity.ConduitBlockEntity;
import com.enderio.conduits.common.init.ConduitTypes;
import com.enderio.conduits.common.types.redstone.RedstoneExtendedData;
import com.mojang.datafixers.util.Pair;
import dev.gigaherz.graph3.Graph;
import dev.gigaherz.graph3.GraphObject;
import dev.gigaherz.graph3.Mergeable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class ConduitSavedData
extends SavedData {
    private final Map<ConduitType<?>, List<Graph<Mergeable.Dummy>>> networks = new HashMap();
    private final Map<ConduitType<?>, Map<ChunkPos, Map<BlockPos, NodeIdentifier<?>>>> deserializedNodes = new HashMap();
    private static final String KEY_GRAPHS = "Graphs";
    private static final String KEY_TYPE = "Type";
    private static final String KEY_GRAPH_OBJECTS = "GraphObjects";
    private static final String KEY_GRAPH_CONNECTIONS = "GraphConnections";
    private static final String KEY_DATA = "Data";

    public static ConduitSavedData get(ServerLevel level) {
        return (ConduitSavedData)level.m_8895_().m_164861_(nbt -> new ConduitSavedData((Level)level, (CompoundTag)nbt), ConduitSavedData::new, "enderio_conduit_network");
    }

    private ConduitSavedData() {
    }

    private ConduitSavedData(Level level, CompoundTag nbt) {
        ListTag graphsTag = nbt.m_128437_(KEY_GRAPHS, 10);
        for (Tag tag : graphsTag) {
            CompoundTag typedGraphTag = (CompoundTag)tag;
            ResourceLocation type = new ResourceLocation(typedGraphTag.m_128461_(KEY_TYPE));
            if (!ConduitRegistries.getRegistry().containsKey(type)) continue;
            ConduitType value = Objects.requireNonNull((ConduitType)ConduitRegistries.getRegistry().getValue(type));
            ListTag graphsForTypeTag = typedGraphTag.m_128437_(KEY_GRAPHS, 10);
            for (Tag tag1 : graphsForTypeTag) {
                CompoundTag graphTag = (CompoundTag)tag1;
                ListTag graphObjectsTag = graphTag.m_128437_(KEY_GRAPH_OBJECTS, 10);
                ListTag graphConnectionsTag = graphTag.m_128437_(KEY_GRAPH_CONNECTIONS, 10);
                ArrayList graphObjects = new ArrayList();
                ArrayList<Pair<GraphObject<Mergeable.Dummy>, GraphObject<Mergeable.Dummy>>> connections = new ArrayList<Pair<GraphObject<Mergeable.Dummy>, GraphObject<Mergeable.Dummy>>>();
                for (Tag tag2 : graphObjectsTag) {
                    BlockPos pos;
                    CompoundTag nodeTag = (CompoundTag)tag2;
                    if (nodeTag.m_128425_("BlockPos", 99)) {
                        pos = BlockPos.m_122022_((long)nodeTag.m_128454_("BlockPos"));
                    } else {
                        CompoundTag posTag = nodeTag.m_128469_("BlockPos");
                        pos = BlockEntity.m_187472_((CompoundTag)posTag);
                    }
                    NodeIdentifier node = new NodeIdentifier(pos, value.createExtendedConduitData(level, pos));
                    node.getExtendedConduitData().deserializeNBT((Tag)nodeTag.m_128469_(KEY_DATA));
                    graphObjects.add(node);
                    this.putUnloadedNodeIdentifier(value, pos, node);
                }
                for (Tag tag2 : graphConnectionsTag) {
                    CompoundTag connectionTag = (CompoundTag)tag2;
                    connections.add((Pair<GraphObject<Mergeable.Dummy>, GraphObject<Mergeable.Dummy>>)new Pair((Object)((GraphObject)graphObjects.get(connectionTag.m_128451_("0"))), (Object)((GraphObject)graphObjects.get(connectionTag.m_128451_("1")))));
                }
                NodeIdentifier graphObject = (NodeIdentifier)graphObjects.get(0);
                Graph.integrate((GraphObject)graphObject, List.of());
                this.merge(graphObject, connections);
                this.networks.computeIfAbsent(value, ignored -> new ArrayList()).add(graphObject.getGraph());
            }
        }
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag graphsTag = new ListTag();
        for (Map.Entry<ConduitType<?>, List<Graph<Mergeable.Dummy>>> entry : this.networks.entrySet()) {
            ConduitType<?> type = entry.getKey();
            List<Graph<Mergeable.Dummy>> graphs = entry.getValue();
            if (graphs.isEmpty()) continue;
            CompoundTag typedGraphTag = new CompoundTag();
            typedGraphTag.m_128359_(KEY_TYPE, ConduitRegistries.getRegistry().getKey(type).toString());
            ListTag graphsForTypeTag = new ListTag();
            for (Graph<Mergeable.Dummy> graph : graphs) {
                if (graph.getObjects().isEmpty()) continue;
                graphsForTypeTag.add((Object)ConduitSavedData.serializeGraph(graph));
            }
            if (graphsForTypeTag.isEmpty()) continue;
            typedGraphTag.m_128365_(KEY_GRAPHS, (Tag)graphsForTypeTag);
            graphsTag.add((Object)typedGraphTag);
        }
        nbt.m_128365_(KEY_GRAPHS, (Tag)graphsTag);
        return nbt;
    }

    public boolean m_77764_() {
        return true;
    }

    private static CompoundTag serializeGraph(Graph<Mergeable.Dummy> graph) {
        ArrayList graphObjects = new ArrayList(graph.getObjects());
        ArrayList<Pair<GraphObject<Mergeable.Dummy>, GraphObject<Mergeable.Dummy>>> connections = new ArrayList<Pair<GraphObject<Mergeable.Dummy>, GraphObject<Mergeable.Dummy>>>();
        CompoundTag graphTag = new CompoundTag();
        ListTag graphObjectsTag = new ListTag();
        ListTag graphConnectionsTag = new ListTag();
        for (GraphObject graphObject : graphObjects) {
            for (GraphObject neighbour : graph.getNeighbours(graphObject)) {
                Pair connection = new Pair((Object)graphObject, (Object)neighbour);
                if (ConduitSavedData.containsConnection(connections, (Pair<GraphObject<Mergeable.Dummy>, GraphObject<Mergeable.Dummy>>)connection)) continue;
                connections.add((Pair<GraphObject<Mergeable.Dummy>, GraphObject<Mergeable.Dummy>>)connection);
            }
            if (graphObject instanceof NodeIdentifier) {
                NodeIdentifier nodeIdentifier = (NodeIdentifier)graphObject;
                CompoundTag dataTag = new CompoundTag();
                CompoundTag posTag = new CompoundTag();
                dataTag.m_128365_("BlockPos", (Tag)posTag);
                posTag.m_128405_("x", nodeIdentifier.getPos().m_123341_());
                posTag.m_128405_("y", nodeIdentifier.getPos().m_123342_());
                posTag.m_128405_("z", nodeIdentifier.getPos().m_123343_());
                dataTag.m_128365_(KEY_DATA, nodeIdentifier.getExtendedConduitData().serializeNBT());
                graphObjectsTag.add((Object)dataTag);
                continue;
            }
            throw new ClassCastException("graphObject was not of type nodeIdentifier");
        }
        for (Pair pair : connections) {
            CompoundTag connectionTag = new CompoundTag();
            connectionTag.m_128365_("0", (Tag)IntTag.m_128679_((int)graphObjects.indexOf(pair.getFirst())));
            connectionTag.m_128365_("1", (Tag)IntTag.m_128679_((int)graphObjects.indexOf(pair.getSecond())));
            graphConnectionsTag.add((Object)connectionTag);
        }
        graphTag.m_128365_(KEY_GRAPH_OBJECTS, (Tag)graphObjectsTag);
        graphTag.m_128365_(KEY_GRAPH_CONNECTIONS, (Tag)graphConnectionsTag);
        return graphTag;
    }

    private void merge(GraphObject<Mergeable.Dummy> object, List<Pair<GraphObject<Mergeable.Dummy>, GraphObject<Mergeable.Dummy>>> connections) {
        List<Pair> filteredConnections = connections.stream().filter(pair -> pair.getFirst() == object || pair.getSecond() == object).toList();
        List<GraphObject> neighbors = filteredConnections.stream().map(pair -> pair.getFirst() == object ? (GraphObject)pair.getSecond() : (GraphObject)pair.getFirst()).toList();
        for (GraphObject neighbor : neighbors) {
            Graph.connect(object, (GraphObject)neighbor);
        }
        if (!(connections = connections.stream().filter(v -> !filteredConnections.contains(v)).toList()).isEmpty()) {
            this.merge((GraphObject<Mergeable.Dummy>)((GraphObject)connections.get(0).getFirst()), connections);
        }
    }

    @Nullable
    public <T extends ExtendedConduitData<T>> NodeIdentifier<T> takeUnloadedNodeIdentifier(ConduitType<T> type, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        Map<ChunkPos, Map<BlockPos, NodeIdentifier<?>>> typeMap = this.deserializedNodes.get(type);
        if (typeMap == null) {
            EnderIO.LOGGER.warn("Conduit data is missing!");
            return null;
        }
        Map<BlockPos, NodeIdentifier<?>> chunkMap = typeMap.get(chunkPos);
        if (chunkMap == null) {
            EnderIO.LOGGER.warn("Conduit data is missing!");
            return null;
        }
        NodeIdentifier<?> node = chunkMap.get(pos);
        chunkMap.remove(pos);
        if (chunkMap.isEmpty()) {
            typeMap.remove(chunkPos);
        }
        if (typeMap.isEmpty()) {
            this.deserializedNodes.remove(type);
        }
        return node;
    }

    public void putUnloadedNodeIdentifier(ConduitType<?> type, BlockPos pos, NodeIdentifier<?> node) {
        ChunkPos chunkPos = new ChunkPos(pos);
        Map typeMap = this.deserializedNodes.computeIfAbsent(type, k -> new HashMap());
        Map chunkMap = typeMap.computeIfAbsent(chunkPos, k -> new HashMap());
        chunkMap.put(pos, node);
    }

    private static boolean containsConnection(List<Pair<GraphObject<Mergeable.Dummy>, GraphObject<Mergeable.Dummy>>> connections, Pair<GraphObject<Mergeable.Dummy>, GraphObject<Mergeable.Dummy>> connection) {
        return connections.contains(connection) || connections.contains(connection.swap());
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Level level = event.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ConduitSavedData.get(serverLevel).tick(serverLevel);
        }
    }

    private void tick(ServerLevel serverLevel) {
        this.m_77762_();
        for (Map.Entry<ConduitType<?>, List<Graph<Mergeable.Dummy>>> entry : this.networks.entrySet()) {
            entry.getValue().removeIf(graph -> graph.getObjects().isEmpty() || ((GraphObject)graph.getObjects().iterator().next()).getGraph() != graph);
        }
        for (Map.Entry<ConduitType<?>, List<Graph<Mergeable.Dummy>>> entry : this.networks.entrySet()) {
            for (Graph<Mergeable.Dummy> graph2 : entry.getValue()) {
                if (serverLevel.m_46467_() % (long)entry.getKey().getTicker().getTickRate() != (long)(ConduitRegistries.getRegistry().getID(entry.getKey()) % entry.getKey().getTicker().getTickRate())) continue;
                entry.getKey().getTicker().tickGraph(entry.getKey(), graph2, serverLevel, (TriFunction<ServerLevel, BlockPos, ColorControl, Boolean>)((TriFunction)ConduitSavedData::isRedstoneActive));
            }
        }
    }

    private static boolean isRedstoneActive(ServerLevel serverLevel, BlockPos pos, ColorControl color) {
        if (!serverLevel.m_46749_(pos) || !serverLevel.m_220393_(pos)) {
            return false;
        }
        BlockEntity blockEntity = serverLevel.m_7702_(pos);
        if (!(blockEntity instanceof ConduitBlockEntity)) {
            return false;
        }
        ConduitBlockEntity conduit = (ConduitBlockEntity)blockEntity;
        if (!conduit.getBundle().getTypes().contains(ConduitTypes.REDSTONE.get())) {
            return false;
        }
        RedstoneExtendedData data = (RedstoneExtendedData)conduit.getBundle().getNodeFor((ConduitType)ConduitTypes.REDSTONE.get()).getExtendedConduitData().cast();
        return data.isActive(color);
    }

    public static void addPotentialGraph(ConduitType<?> type, Graph<Mergeable.Dummy> graph, ServerLevel level) {
        ConduitSavedData.get(level).addPotentialGraph(type, graph);
    }

    private void addPotentialGraph(ConduitType<?> type, Graph<Mergeable.Dummy> graph) {
        if (!this.networks.computeIfAbsent(type, unused -> new ArrayList()).contains(graph)) {
            this.networks.get(type).add(graph);
        }
    }

    public void m_77757_(File file) {
        if (this.m_77764_()) {
            File tempFile = file.toPath().getParent().resolve(file.getName() + ".tmp").toFile();
            super.m_77757_(tempFile);
            if (file.exists() && !file.delete()) {
                EnderIO.LOGGER.error("Failed to delete " + file.getName());
            }
            if (!tempFile.renameTo(file)) {
                EnderIO.LOGGER.error("Failed to rename " + tempFile.getName());
            }
        }
    }
}

