/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.types;

import com.enderio.api.UseOnly;
import com.enderio.api.conduit.ClientConduitData;
import com.enderio.api.conduit.ConduitMenuData;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.ExtendedConduitData;
import com.enderio.api.conduit.ticker.ConduitTicker;
import com.enderio.api.misc.Vector2i;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;

public class SimpleConduitType<T extends ExtendedConduitData<T>>
implements ConduitType<T> {
    private final ResourceLocation texture;
    private final ConduitTicker ticker;
    private final Supplier<T> extendedDataFactory;
    private final ClientConduitData<T> clientConduitData;
    private final ConduitMenuData menuData;

    public SimpleConduitType(ResourceLocation texture, ConduitTicker ticker, Supplier<T> extendedDataFactory, ResourceLocation iconTexture, Vector2i iconTexturePos, ConduitMenuData menuData) {
        this(texture, ticker, extendedDataFactory, new ClientConduitData.Simple(iconTexture, iconTexturePos), menuData);
    }

    public SimpleConduitType(ResourceLocation texture, ConduitTicker ticker, Supplier<T> extendedDataFactory, ClientConduitData<T> clientConduitData, ConduitMenuData menuData) {
        this.texture = texture;
        this.ticker = ticker;
        this.extendedDataFactory = extendedDataFactory;
        this.clientConduitData = clientConduitData;
        this.menuData = menuData;
    }

    @Override
    public ResourceLocation getTexture(T data) {
        return this.texture;
    }

    @Override
    public ResourceLocation getItemTexture() {
        return this.texture;
    }

    @Override
    public ConduitTicker getTicker() {
        return this.ticker;
    }

    @Override
    @UseOnly(value=LogicalSide.CLIENT)
    public ClientConduitData<T> getClientData() {
        return this.clientConduitData;
    }

    @Override
    public ConduitMenuData getMenuData() {
        return this.menuData;
    }

    @Override
    public T createExtendedConduitData(Level level, BlockPos pos) {
        return (T)((ExtendedConduitData)this.extendedDataFactory.get());
    }
}

