/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.types.energy;

import com.enderio.EnderIO;
import com.enderio.api.conduit.ClientConduitData;
import com.enderio.api.conduit.ConduitMenuData;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.NodeIdentifier;
import com.enderio.api.misc.RedstoneControl;
import com.enderio.api.misc.Vector2i;
import com.enderio.conduits.common.init.ConduitTypes;
import com.enderio.conduits.common.tag.ConduitTags;
import com.enderio.conduits.common.types.SimpleConduitType;
import com.enderio.conduits.common.types.energy.EnergyConduitTicker;
import com.enderio.conduits.common.types.energy.EnergyExtendedData;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class EnergyConduitType
extends SimpleConduitType<EnergyExtendedData> {
    public EnergyConduitType() {
        super(EnderIO.loc("block/conduit/energy"), new EnergyConduitTicker(), EnergyExtendedData::new, new ClientConduitData.Simple(ConduitTypes.ICON_TEXTURE, new Vector2i(0, 24)), ConduitMenuData.ENERGY);
    }

    @Override
    public ConduitType.ConduitConnectionData getDefaultConnection(Level level, BlockPos pos, Direction direction) {
        LazyOptional capability;
        BlockEntity blockEntity = level.m_7702_(pos.m_121945_(direction));
        if (blockEntity != null && (capability = blockEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_())).isPresent()) {
            IEnergyStorage storage = (IEnergyStorage)capability.orElseThrow(() -> new RuntimeException("present capability was not found"));
            return new ConduitType.ConduitConnectionData(storage.canReceive(), storage.canExtract(), RedstoneControl.ALWAYS_ACTIVE);
        }
        return super.getDefaultConnection(level, pos, direction);
    }

    @Override
    public <K> Optional<LazyOptional<K>> proxyCapability(Capability<K> cap, EnergyExtendedData extendedConduitData, Level level, BlockPos pos, @Nullable Direction direction, Optional<NodeIdentifier.IOState> state) {
        if (ForgeCapabilities.ENERGY == cap && state.map(NodeIdentifier.IOState::isExtract).orElse(true).booleanValue() && (direction == null || !level.m_8055_(pos.m_121945_(direction)).m_204336_(ConduitTags.Blocks.ENERGY_CABLE))) {
            return Optional.of(extendedConduitData.getSelfCap().cast());
        }
        return Optional.empty();
    }
}

