/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.types.fluid;

import com.enderio.EnderIO;
import com.enderio.api.conduit.ClientConduitData;
import com.enderio.api.misc.Vector2i;
import com.enderio.base.common.lang.EIOLang;
import com.enderio.conduits.common.types.fluid.FluidExtendedData;
import com.enderio.core.client.RenderUtil;
import com.enderio.core.common.util.TooltipUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class FluidClientData
extends ClientConduitData.Simple<FluidExtendedData> {
    private static final ResourceLocation MODEL = EnderIO.loc("block/extra/fluids");
    private static final ResourceLocation WIDGET_TEXTURE = EnderIO.loc("textures/gui/fluidbackground.png");

    public FluidClientData(ResourceLocation getTextureLocation, Vector2i getTexturePosition) {
        super(getTextureLocation, getTexturePosition);
    }

    @Override
    public List<BakedQuad> createConnectionQuads(FluidExtendedData extendedConduitData, @Nullable Direction facing, Direction connectionDirection, RandomSource rand, @Nullable RenderType type) {
        if (!extendedConduitData.isMultiFluid && extendedConduitData.lockedFluid != null) {
            return new FluidPaintQuadTransformer(extendedConduitData.lockedFluid).process(this.getModel(MODEL).getQuads(Blocks.f_50652_.m_49966_(), facing, rand, ModelData.EMPTY, type));
        }
        return List.of();
    }

    @Override
    public List<AbstractWidget> createWidgets(Screen screen, FluidExtendedData extendedConduitData, ClientConduitData.UpdateExtendedData<FluidExtendedData> updateExtendedConduitData, Supplier<Direction> direction, Vector2i widgetsStart) {
        return List.of(new FluidWidget(widgetsStart.add(0, 20), () -> extendedConduitData.lockedFluid, () -> updateExtendedConduitData.update(data -> {
            data.shouldReset = true;
            return data;
        })));
    }

    @Override
    public List<ResourceLocation> modelsToLoad() {
        return List.of(MODEL);
    }

    private record FluidPaintQuadTransformer(Fluid fluid) implements IQuadTransformer
    {
        public void processInPlace(BakedQuad quad) {
            IClientFluidTypeExtensions clientExtension = IClientFluidTypeExtensions.of((Fluid)this.fluid);
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(clientExtension.getStillTexture());
            for (int i = 0; i < 4; ++i) {
                float[] uv0 = RenderUtil.unpackVertices(quad.m_111303_(), i, IQuadTransformer.UV0, 2);
                uv0[0] = (uv0[0] - quad.m_173410_().m_118409_()) * (float)sprite.m_245424_().m_246492_() / (float)quad.m_173410_().m_245424_().m_245330_() + sprite.m_118409_();
                uv0[1] = (uv0[1] - quad.m_173410_().m_118411_()) * (float)sprite.m_245424_().m_246492_() / (float)quad.m_173410_().m_245424_().m_245330_() + sprite.m_118411_();
                int[] packedTextureData = RenderUtil.packUV(uv0[0], uv0[1]);
                quad.m_111303_()[4 + i * FluidPaintQuadTransformer.STRIDE] = packedTextureData[0];
                quad.m_111303_()[5 + i * FluidPaintQuadTransformer.STRIDE] = packedTextureData[1];
                RenderUtil.putColorARGB(quad.m_111303_(), i, clientExtension.getTintColor());
            }
        }
    }

    private static class FluidWidget
    extends AbstractWidget {
        private final Runnable onPress;
        private final Supplier<Fluid> currentFluid;

        FluidWidget(Vector2i pos, Supplier<Fluid> fluid, Runnable onPress) {
            super(pos.x(), pos.y(), 14, 14, (Component)Component.m_237119_());
            this.onPress = onPress;
            this.currentFluid = fluid;
        }

        public void m_168797_(NarrationElementOutput pNarrationElementOutput) {
        }

        public void m_87963_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            if (this.m_198029_()) {
                MutableComponent tooltip = EIOLang.FLUID_CONDUIT_CHANGE_FLUID1.m_6881_();
                tooltip.m_130946_("\n").m_7220_(EIOLang.FLUID_CONDUIT_CHANGE_FLUID2);
                if (this.currentFluid.get() != null) {
                    tooltip.m_130946_("\n").m_7220_((Component)TooltipUtil.withArgs(EIOLang.FLUID_CONDUIT_CHANGE_FLUID3, this.currentFluid.get().getFluidType().getDescription()));
                }
                this.m_257544_(Tooltip.m_257550_((Component)TooltipUtil.style(tooltip)));
            }
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            guiGraphics.m_280218_(WIDGET_TEXTURE, this.m_252754_(), this.m_252907_(), 0, 0, this.f_93618_, this.f_93619_);
            if (this.currentFluid.get() == null) {
                return;
            }
            IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)this.currentFluid.get());
            ResourceLocation still = props.getStillTexture();
            AbstractTexture texture = Minecraft.m_91087_().m_91097_().m_118506_(TextureAtlas.f_118259_);
            if (texture instanceof TextureAtlas) {
                TextureAtlas atlas = (TextureAtlas)texture;
                TextureAtlasSprite sprite = atlas.m_118316_(still);
                int color = props.getTintColor();
                RenderSystem.setShaderColor((float)((float)FastColor.ARGB32.m_13665_((int)color) / 255.0f), (float)((float)FastColor.ARGB32.m_13667_((int)color) / 255.0f), (float)((float)FastColor.ARGB32.m_13669_((int)color) / 255.0f), (float)((float)FastColor.ARGB32.m_13655_((int)color) / 255.0f));
                RenderSystem.enableBlend();
                int atlasWidth = (int)((float)sprite.m_245424_().m_246492_() / (sprite.m_118410_() - sprite.m_118409_()));
                int atlasHeight = (int)((float)sprite.m_245424_().m_245330_() / (sprite.m_118412_() - sprite.m_118411_()));
                guiGraphics.m_280398_(TextureAtlas.f_118259_, this.m_252754_() + 1, this.m_252907_() + 1, 0, sprite.m_118409_() * (float)atlasWidth, sprite.m_118411_() * (float)atlasHeight, 12, 12, atlasWidth, atlasHeight);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            RenderSystem.disableBlend();
            RenderSystem.disableDepthTest();
        }

        public void m_5716_(double pMouseX, double pMouseY) {
            this.onPress.run();
        }
    }
}

