/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.types.fluid;

import com.enderio.api.conduit.ConduitMenuData;
import com.enderio.api.conduit.TieredConduit;
import com.enderio.api.conduit.ticker.ConduitTicker;
import com.enderio.api.misc.Vector2i;
import com.enderio.conduits.common.types.fluid.FluidClientData;
import com.enderio.conduits.common.types.fluid.FluidConduitTicker;
import com.enderio.conduits.common.types.fluid.FluidExtendedData;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class FluidConduitType
extends TieredConduit<FluidExtendedData> {
    public static final ConduitMenuData MENU_DATA = new ConduitMenuData.Simple(false, false, false, false, false, true);
    private final boolean isMultiFluid;
    private final int transferRate;

    public FluidConduitType(ResourceLocation texture, int tier, boolean isMultiFluid, ResourceLocation iconTexture, Vector2i iconTexturePos) {
        super(texture, new ResourceLocation("forge:fluid"), (isMultiFluid ? 100000 : 0) + tier, iconTexture, iconTexturePos);
        this.isMultiFluid = isMultiFluid;
        this.transferRate = tier;
        this.clientConduitData = new FluidClientData(iconTexture, iconTexturePos);
    }

    @Override
    public ConduitTicker getTicker() {
        return new FluidConduitTicker(!this.isMultiFluid, this.transferRate);
    }

    @Override
    public ConduitMenuData getMenuData() {
        return MENU_DATA;
    }

    @Override
    public FluidExtendedData createExtendedConduitData(Level level, BlockPos pos) {
        return new FluidExtendedData(this.isMultiFluid);
    }
}

