/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.types.fluid;

import com.enderio.EnderIO;
import com.enderio.api.conduit.ExtendedConduitData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class FluidExtendedData
implements ExtendedConduitData<FluidExtendedData> {
    public final boolean isMultiFluid;
    @Nullable
    Fluid lockedFluid = null;
    boolean shouldReset = false;
    private static final String SHOULD_RESET = "ShouldReset";

    public FluidExtendedData(boolean isMultiFluid) {
        this.isMultiFluid = isMultiFluid;
    }

    @Override
    public void onConnectTo(FluidExtendedData otherData) {
        if (this.lockedFluid != null) {
            if (otherData.lockedFluid != null && this.lockedFluid != otherData.lockedFluid) {
                EnderIO.LOGGER.warn("incompatible fluid conduits merged");
            }
            otherData.setLockedFluid(this.lockedFluid);
        } else if (otherData.lockedFluid != null) {
            this.setLockedFluid(otherData.lockedFluid);
        }
    }

    @Override
    public boolean canConnectTo(FluidExtendedData otherData) {
        return this.lockedFluid == null || otherData.lockedFluid == null || this.lockedFluid == otherData.lockedFluid;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (!this.isMultiFluid) {
            if (this.lockedFluid != null) {
                nbt.m_128359_("Fluid", ForgeRegistries.FLUIDS.getKey((Object)this.lockedFluid).toString());
            } else {
                nbt.m_128359_("Fluid", "null");
            }
        }
        return nbt;
    }

    @Override
    public CompoundTag serializeRenderNBT() {
        return this.serializeNBT();
    }

    @Override
    public CompoundTag serializeGuiNBT() {
        CompoundTag nbt = this.serializeNBT();
        nbt.m_128379_(SHOULD_RESET, this.shouldReset);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("Fluid") && !this.isMultiFluid) {
            String fluid = nbt.m_128461_("Fluid");
            if (fluid.equals("null") || ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluid)) == Fluids.f_76191_) {
                this.setLockedFluid(null);
            } else {
                this.setLockedFluid((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluid)));
            }
        } else {
            this.setLockedFluid(null);
        }
        if (nbt.m_128441_(SHOULD_RESET)) {
            this.shouldReset = nbt.m_128471_(SHOULD_RESET);
        }
    }

    private void setLockedFluid(@Nullable Fluid lockedFluid) {
        this.lockedFluid = lockedFluid;
    }
}

