/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.types.item;

import com.enderio.api.capability.IConduitFilter;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.NodeIdentifier;
import com.enderio.api.conduit.ticker.CapabilityAwareConduitTicker;
import com.enderio.api.misc.ColorControl;
import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.conduits.common.blockentity.ConduitBlockEntity;
import com.enderio.conduits.common.blockentity.SlotData;
import com.enderio.conduits.common.blockentity.SlotType;
import com.enderio.conduits.common.init.ConduitItems;
import com.enderio.conduits.common.types.item.ItemExtendedData;
import dev.gigaherz.graph3.Graph;
import dev.gigaherz.graph3.Mergeable;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.function.TriFunction;

public class ItemConduitTicker
extends CapabilityAwareConduitTicker<IItemHandler> {
    @Override
    public void tickGraph(ConduitType<?> type, List<NodeIdentifier<?>> loadedNodes, ServerLevel level, Graph<Mergeable.Dummy> graph, TriFunction<ServerLevel, BlockPos, ColorControl, Boolean> isRedstoneActive) {
        super.tickGraph(type, loadedNodes, level, graph, isRedstoneActive);
        for (NodeIdentifier<?> node : loadedNodes) {
            BlockEntity blockEntity = level.m_7702_(node.getPos());
            if (!(blockEntity instanceof ConduitBlockEntity)) continue;
            ConduitBlockEntity conduitBlockEntity = (ConduitBlockEntity)blockEntity;
            IItemHandler conduitItemHandler = conduitBlockEntity.getConduitItemHandler();
            for (SlotType slotType : SlotType.values()) {
                for (Direction dir : Direction.values()) {
                    ItemExtendedData.ItemSidedData extendedData = node.getExtendedConduitData().castTo(ItemExtendedData.class).compute(dir);
                    ItemStack item = conduitItemHandler.getStackInSlot(new SlotData(dir, conduitBlockEntity.getBundle().getTypes().indexOf(type), slotType).slotIndex());
                    if (slotType == SlotType.FILTER_EXTRACT) {
                        extendedData.extractFilter = item;
                    }
                    if (slotType == SlotType.FILTER_INSERT) {
                        extendedData.insertFilter = item;
                    }
                    if (slotType != SlotType.UPGRADE_EXTRACT) continue;
                    extendedData.extractRate = item.m_41619_() ? 4 : (item.m_41720_().equals(ConduitItems.SPEED_DOWNGRADE.m_5456_()) ? item.m_41613_() : 4 + 4 * item.m_41613_());
                }
            }
        }
    }

    @Override
    protected void tickCapabilityGraph(ConduitType<?> type, List<CapabilityAwareConduitTicker.CapabilityConnection> inserts, List<CapabilityAwareConduitTicker.CapabilityConnection> extracts, ServerLevel level, Graph<Mergeable.Dummy> graph, TriFunction<ServerLevel, BlockPos, ColorControl, Boolean> isRedstoneActive) {
        block0: for (CapabilityAwareConduitTicker.CapabilityConnection extract : extracts) {
            IItemHandler extractHandler = (IItemHandler)extract.cap;
            for (int i = 0; i < extractHandler.getSlots(); ++i) {
                LazyOptional insertFilterCap;
                ItemExtendedData.ItemSidedData sidedExtractData = extract.data.castTo(ItemExtendedData.class).compute(extract.direction);
                ItemStack extractedItem = extractHandler.extractItem(i, sidedExtractData.extractRate, true);
                if (extractedItem.m_41619_() || (insertFilterCap = sidedExtractData.extractFilter.getCapability(EIOCapabilities.ITEM_FILTER)).isPresent() && !((IConduitFilter)insertFilterCap.resolve().get()).testItem(extractedItem)) continue;
                if (sidedExtractData.roundRobin) {
                    if (inserts.size() <= sidedExtractData.rotatingIndex) {
                        sidedExtractData.rotatingIndex = 0;
                    }
                } else {
                    sidedExtractData.rotatingIndex = 0;
                }
                for (int j = sidedExtractData.rotatingIndex; j < sidedExtractData.rotatingIndex + inserts.size(); ++j) {
                    ItemStack notInserted;
                    int insertIndex = j % inserts.size();
                    CapabilityAwareConduitTicker.CapabilityConnection insert = inserts.get(insertIndex);
                    ItemExtendedData.ItemSidedData insertData = insert.data.castTo(ItemExtendedData.class).compute(insert.direction);
                    LazyOptional extractFilterCap = insertData.insertFilter.getCapability(EIOCapabilities.ITEM_FILTER);
                    if (extractFilterCap.isPresent() && !((IConduitFilter)extractFilterCap.resolve().get()).testItem(extractedItem) || !sidedExtractData.selfFeed && extract.direction == insert.direction && extract.data == insert.data || (notInserted = ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)insert.cap), (ItemStack)extractedItem, (boolean)false)).m_41613_() >= extractedItem.m_41613_()) continue;
                    extractHandler.extractItem(i, extractedItem.m_41613_() - notInserted.m_41613_(), false);
                    if (!sidedExtractData.roundRobin) continue block0;
                    sidedExtractData.rotatingIndex = insertIndex + 1;
                    continue block0;
                }
            }
        }
    }

    @Override
    protected Capability<IItemHandler> getCapability() {
        return ForgeCapabilities.ITEM_HANDLER;
    }

    @Override
    public int getTickRate() {
        return 20;
    }
}

