/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.types.item;

import com.enderio.api.conduit.ExtendedConduitData;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemExtendedData
implements ExtendedConduitData<ItemExtendedData> {
    private final Map<Direction, ItemSidedData> itemSidedData = new EnumMap<Direction, ItemSidedData>(Direction.class);

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        for (Direction direction : Direction.values()) {
            @Nullable ItemSidedData sidedData = this.itemSidedData.get(direction);
            if (sidedData == null) continue;
            tag.m_128365_(direction.name(), (Tag)sidedData.toNbt());
        }
        return tag;
    }

    @Override
    public CompoundTag serializeGuiNBT() {
        CompoundTag tag = new CompoundTag();
        for (Direction direction : Direction.values()) {
            @Nullable ItemSidedData sidedData = this.itemSidedData.get(direction);
            if (sidedData == null) continue;
            tag.m_128365_(direction.name(), (Tag)sidedData.toGuiNbt());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        for (Direction direction : Direction.values()) {
            if (!nbt.m_128441_(direction.name())) continue;
            this.itemSidedData.put(direction, ItemSidedData.fromNbt(nbt.m_128469_(direction.name())));
        }
    }

    public ItemSidedData get(Direction direction) {
        return this.itemSidedData.getOrDefault(direction, new ItemSidedData());
    }

    public ItemSidedData compute(Direction direction) {
        return this.itemSidedData.computeIfAbsent(direction, dir -> new ItemSidedData());
    }

    public static class ItemSidedData {
        public boolean roundRobin = false;
        public int rotatingIndex = 0;
        public boolean selfFeed = false;
        public int priority = 0;
        public ItemStack insertFilter = ItemStack.f_41583_;
        public ItemStack extractFilter = ItemStack.f_41583_;
        public int extractRate = 4;
        private static final String KEY_ROTATING_INDEX = "RotatingIndex";
        private static final String KEY_ROUND_ROBIN = "RoundRobin";
        private static final String KEY_SELF_FEED = "SelfFeed";
        private static final String KEY_PRIORITY = "Priority";
        private static final String KEY_INSERT_FILTER = "InsertFilter";
        private static final String KEY_EXTRACT_FILTER = "ExtractFilter";
        private static final String KEY_EXTRACT_RATE = "ExtractRate";

        private CompoundTag toNbt() {
            CompoundTag nbt = this.toGuiNbt();
            nbt.m_128405_(KEY_ROTATING_INDEX, this.rotatingIndex);
            nbt.m_128405_(KEY_EXTRACT_RATE, this.extractRate);
            nbt.m_128365_(KEY_INSERT_FILTER, (Tag)this.insertFilter.m_41739_(new CompoundTag()));
            nbt.m_128365_(KEY_EXTRACT_FILTER, (Tag)this.extractFilter.m_41739_(new CompoundTag()));
            return nbt;
        }

        private CompoundTag toGuiNbt() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_(KEY_ROUND_ROBIN, this.roundRobin);
            nbt.m_128379_(KEY_SELF_FEED, this.selfFeed);
            nbt.m_128405_(KEY_PRIORITY, this.priority);
            return nbt;
        }

        private static ItemSidedData fromNbt(CompoundTag nbt) {
            ItemSidedData sidedData = new ItemSidedData();
            sidedData.roundRobin = nbt.m_128471_(KEY_ROUND_ROBIN);
            sidedData.selfFeed = nbt.m_128471_(KEY_SELF_FEED);
            sidedData.priority = nbt.m_128451_(KEY_PRIORITY);
            sidedData.extractRate = nbt.m_128451_(KEY_EXTRACT_RATE);
            if (nbt.m_128441_(KEY_ROTATING_INDEX)) {
                sidedData.rotatingIndex = nbt.m_128451_(KEY_ROTATING_INDEX);
            }
            sidedData.insertFilter = ItemStack.m_41712_((CompoundTag)nbt.m_128469_(KEY_INSERT_FILTER));
            sidedData.extractFilter = ItemStack.m_41712_((CompoundTag)nbt.m_128469_(KEY_EXTRACT_FILTER));
            return sidedData;
        }
    }
}

