/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.menu;

import com.enderio.core.common.blockentity.EnderBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.jetbrains.annotations.Nullable;

public abstract class SyncedMenu<T extends EnderBlockEntity>
extends AbstractContainerMenu {
    @Nullable
    private final T blockEntity;
    private final Inventory inventory;
    private final List<Slot> playerInventorySlots = new ArrayList<Slot>();
    private boolean playerInvVisible = true;
    private static final ResourceLocation[] ARMOR_SLOT_TEXTURES = new ResourceLocation[]{InventoryMenu.f_39696_, InventoryMenu.f_39695_, InventoryMenu.f_39694_, InventoryMenu.f_39693_};
    private static final EquipmentSlot[] EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};

    protected SyncedMenu(@Nullable T blockEntity, Inventory inventory, @Nullable MenuType<?> pMenuType, int pContainerId) {
        super(pMenuType, pContainerId);
        this.blockEntity = blockEntity;
        this.inventory = inventory;
    }

    @Nullable
    public T getBlockEntity() {
        return this.blockEntity;
    }

    public void addInventorySlots(int xPos, int yPos) {
        for (int x = 0; x < 9; ++x) {
            Slot ref = new Slot((Container)this.inventory, x, xPos + x * 18, yPos + 58){

                public boolean m_6659_() {
                    return SyncedMenu.this.playerInvVisible;
                }
            };
            this.playerInventorySlots.add(ref);
            this.m_38897_(ref);
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                Slot ref = new Slot((Container)this.inventory, x + y * 9 + 9, xPos + x * 18, yPos + y * 18);
                this.playerInventorySlots.add(ref);
                this.m_38897_(ref);
            }
        }
    }

    public void addArmorSlots(int xPos, int Ypos) {
        for (int i = 0; i < 4; ++i) {
            final EquipmentSlot slot = EQUIPMENT_SLOTS[i];
            this.m_38897_(new Slot((Container)this.inventory, 36 + (3 - i), xPos, Ypos + i * 18){

                public int m_6641_() {
                    return 1;
                }

                public boolean m_5857_(ItemStack stack) {
                    return stack.canEquip(slot, (Entity)SyncedMenu.this.inventory.f_35978_);
                }

                public boolean m_8010_(Player player) {
                    ItemStack itemstack = this.m_7993_();
                    return super.m_8010_(player) && !EnchantmentHelper.m_44920_((ItemStack)itemstack);
                }
            }.setBackground(InventoryMenu.f_39692_, ARMOR_SLOT_TEXTURES[slot.m_20749_()]));
        }
    }

    public boolean getPlayerInvVisible() {
        return this.playerInvVisible;
    }

    public boolean setPlayerInvVisible(boolean visible) {
        if (this.playerInvVisible != visible) {
            this.playerInvVisible = visible;
            int offset = this.playerInvVisible ? 1000 : -1000;
            this.playerInventorySlots.forEach(slot -> slot.f_40221_ += offset);
        }
        return visible;
    }
}

