/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.client.rendering.travel;

import com.enderio.api.travel.TravelRenderer;
import com.enderio.machines.client.rendering.travel.OutlineBuffer;
import com.enderio.machines.client.rendering.travel.OutlineRenderType;
import com.enderio.machines.common.travel.AnchorTravelTarget;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.joml.Matrix4f;

public class TravelAnchorRenderer
implements TravelRenderer<AnchorTravelTarget> {
    public static final RenderType BOLD_LINES = OutlineRenderType.createLines("bold_lines", 3);
    public static final RenderType VERY_BOLD_LINES = OutlineRenderType.createLines("very_bold_lines", 5);

    @Override
    public void render(AnchorTravelTarget travelData, LevelRenderer levelRenderer, PoseStack poseStack, double distanceSquared, boolean active) {
        float scale;
        double doubleScale;
        if (!travelData.getVisibility()) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_252880_((float)travelData.getPos().m_123341_(), (float)travelData.getPos().m_123342_(), (float)travelData.getPos().m_123343_());
        Minecraft minecraft = Minecraft.m_91087_();
        OutlineBuffer buffer = OutlineBuffer.INSTANCE;
        int color = 0xFFFFFF;
        if (active) {
            color = ChatFormatting.GOLD.m_126665_() == null ? 0xFFFFFF : ChatFormatting.GOLD.m_126665_();
        }
        BlockState blockState = minecraft.f_91073_.m_8055_(travelData.getPos());
        BakedModel blockModel = minecraft.m_91289_().m_110910_(blockState);
        VertexConsumer solid = buffer.m_6299_(RenderType.m_110451_());
        minecraft.m_91289_().m_110937_().m_111067_(poseStack.m_85850_(), solid, blockState, blockModel, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_);
        RenderType lineType = distanceSquared > 7225.0 ? RenderType.m_110504_() : (distanceSquared > 1444.0 ? BOLD_LINES : VERY_BOLD_LINES);
        VertexConsumer lines = buffer.m_6299_(lineType);
        LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)lines, (double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0, (float)((float)FastColor.ARGB32.m_13665_((int)color) / 255.0f), (float)((float)FastColor.ARGB32.m_13667_((int)color) / 255.0f), (float)((float)FastColor.ARGB32.m_13669_((int)color) / 255.0f), (float)1.0f);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Vec3 position = player.m_20182_();
        float f1 = (float)(Mth.m_14136_((double)(position.f_82481_ - (double)travelData.getPos().m_123343_() - 0.5), (double)(position.f_82479_ - (double)travelData.getPos().m_123341_() - 0.5)) + 1.5707963267948966);
        if (!travelData.getName().trim().isEmpty()) {
            doubleScale = Math.sqrt((double)(0.0035 * Math.sqrt((double)distanceSquared)));
            if (doubleScale < (double)0.1f) {
                doubleScale = 0.1f;
            }
            doubleScale *= Math.sin((double)Math.toRadians((double)((double)((Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_()).intValue() / 4.0)));
            if (active) {
                doubleScale *= 1.3;
            }
            scale = (float)doubleScale;
            poseStack.m_85836_();
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            poseStack.m_85837_(0.5, 1.05 + doubleScale * 9.0, 0.5);
            poseStack.m_252781_(Axis.f_252392_.m_252961_(f1));
            poseStack.m_85841_(-scale, -scale, scale);
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            MutableComponent tc = Component.m_237113_((String)travelData.getName().trim());
            float textOpacitySetting = minecraft.f_91066_.m_92141_(0.5f);
            int alpha = (int)(textOpacitySetting * 255.0f) << 24;
            float halfWidth = -minecraft.f_91062_.m_92852_((FormattedText)tc) / 2;
            minecraft.f_91062_.m_272077_((Component)tc, halfWidth, 0.0f, color, false, matrix4f, (MultiBufferSource)buffer, Font.DisplayMode.SEE_THROUGH, alpha, LightTexture.m_109885_((int)15, (int)15));
            minecraft.f_91062_.m_272077_((Component)tc, halfWidth, 0.0f, color, false, matrix4f, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, LightTexture.m_109885_((int)15, (int)15));
            poseStack.m_85849_();
        }
        if (travelData.getIcon() != Items.f_41852_) {
            doubleScale = Math.sqrt((double)Math.sqrt((double)distanceSquared));
            doubleScale *= Math.sin((double)Math.toRadians((double)((double)((Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_()).intValue() / 4.0)));
            if (active) {
                doubleScale *= 1.3;
            }
            scale = (float)doubleScale;
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.5, 0.5);
            poseStack.m_252781_(Axis.f_252392_.m_252961_(f1));
            poseStack.m_252880_(0.0f, 0.0f, -1.0f);
            poseStack.m_85841_(-scale, scale, -scale);
            ItemStack stack = new ItemStack((ItemLike)travelData.getIcon());
            BakedModel bakedmodel = minecraft.m_91291_().m_174264_(stack, (Level)minecraft.f_91073_, null, 0);
            minecraft.m_91291_().m_115143_(stack, ItemDisplayContext.GUI, true, poseStack, (MultiBufferSource)OutlineBuffer.INSTANCE, 0xF000F0, OverlayTexture.f_118083_, bakedmodel);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
        minecraft.m_91269_().m_110104_().m_109911_();
    }
}

